/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.message;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.msg.Message;
import ru.bgcrm.dao.message.MessageTypeContactSaver;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@Bean(oldClasses={"ru.bgcrm.plugin.bgbilling.dao.MessageTypeContactSaverPhone"})
public class BGBillingMessageTypeContactSaverPhone
extends MessageTypeContactSaver {
    private final int paramId;

    public BGBillingMessageTypeContactSaverPhone(ConfigMap config) throws Exception {
        super(config);
        this.paramId = config.getInt("paramId", -1);
        if (this.paramId <= 0) {
            throw new BGException("paramId incorrect", new Object[0]);
        }
    }

    @Override
    public void saveContact(DynActionForm form, Connection con, Message message, Process process, int saveMode) {
        ParameterPhoneValueItem value;
        CommonObjectLink contractLink = Utils.getFirst(new ProcessLinkDAO(con).getObjectLinksWithType(process.getId(), "contract%"));
        if (contractLink == null) {
            return;
        }
        String phone = message.getFrom();
        String billingId = new Contract(contractLink).getBillingId();
        ContractParamDAO paramDao = new ContractParamDAO(form.getUser(), billingId);
        List<ParameterPhoneValueItem> values = paramDao.getPhoneParam(contractLink.getLinkObjectId(), this.paramId).getItemList();
        boolean exists = false;
        Iterator<ParameterPhoneValueItem> iterator = values.iterator();
        while (iterator.hasNext() && !(exists = phone.equals((value = iterator.next()).getPhone()))) {
        }
        if (!exists) {
            ParameterPhoneValueItem item = new ParameterPhoneValueItem();
            item.setPhone(phone);
            values.add(item);
            ParameterPhoneValue phoneValue = new ParameterPhoneValue();
            phoneValue.setItemList(values);
            paramDao.updatePhoneParameter(contractLink.getLinkObjectId(), this.paramId, phoneValue);
        }
    }
}

