/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.dist.inst.InstalledModule;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exec.scheduler.Scheduler;
import org.bgerp.util.Log;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class AdminPortListener
implements Runnable {
    private Log log = Log.getLog();
    private static final Date START_TIME = new Date();
    public static final String RESPONSE_SCHEDULER_HAS_TASKS = "Scheduler has running tasks, need wait to stop.";
    protected ServerSocket s = null;
    protected boolean run = true;

    public AdminPortListener(int port) {
        this.log.info("Starting listen admin port {}", port);
        try {
            this.s = new ServerSocket();
            this.s.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
        }
        catch (Exception ex) {
            this.log.error("Port " + port + " is busy! [" + ex.getMessage() + "]", new Object[0]);
            System.exit(1);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run && this.s != null) {
            Socket socket = null;
            try {
                socket = this.s.accept();
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
                try {
                    String command = in.readLine().trim();
                    this.log.info("Executing " + command, new Object[0]);
                    if (command.equals("stop")) {
                        if (Scheduler.getInstance().getRunningTaskCount() > 0) {
                            out.println(RESPONSE_SCHEDULER_HAS_TASKS);
                            continue;
                        }
                        out.println("OK stopping..");
                        System.exit(0);
                        continue;
                    }
                    if (command.equals("status")) {
                        String status = AdminPortListener.statusApp() + "\n" + Setup.getSetup().getConnectionPool().poolStatus();
                        out.println(status.replace('\n', '$'));
                        continue;
                    }
                    if (command.equals("gc")) {
                        System.gc();
                        out.println("GC forced..");
                        continue;
                    }
                    if (command.startsWith("runclass")) {
                        String className = StringUtils.substringAfter((String)command, (String)" ").trim();
                        Class<?> clazz = null;
                        try {
                            clazz = Bean.getClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new BGException("Class not found: " + className, e);
                        }
                        if (Runnable.class.isAssignableFrom(clazz)) {
                            new Thread((Runnable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).start();
                        } else {
                            out.println("Incorrect Runnable class.");
                        }
                        out.println("Dynamic class started..");
                        continue;
                    }
                    out.println("Unknown admin command: " + command);
                }
                catch (Exception ex) {
                    out.println(ex.getMessage());
                    this.log.error(ex.getMessage(), ex);
                }
                finally {
                    socket.close();
                }
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), ex);
            }
        }
    }

    public static String getVersionInfo() {
        StringBuilder result = new StringBuilder(200);
        InstalledModule vi = InstalledModule.get("update");
        InstalledModule viLib = InstalledModule.get("update_lib");
        if (vi != null && viLib != null) {
            result.append("BGERP ").append(vi.getVersion()).append(".").append(vi.getBuildNumber());
            String changeId = vi.getChangeId();
            if (Utils.notBlankString(changeId)) {
                result.append(".").append(changeId);
            }
            result.append(" from ").append(vi.getBuildTime()).append("; lib set ").append(viLib.getBuildNumber()).append(" from ").append(viLib.getBuildTime());
        } else {
            result.append("BGERP DEV");
        }
        return result.toString();
    }

    public static String statusApp() {
        StringBuilder result = new StringBuilder(1000);
        result.append(AdminPortListener.getVersionInfo()).append("\n").append(AdminPortListener.uptimeStatus()).append("\n").append(AdminPortListener.memoryStatus());
        return result.toString();
    }

    public static final String uptimeStatus() {
        StringBuilder report = new StringBuilder(100);
        report.append("Started: ").append(TimeUtils.format(START_TIME, "ymdhms")).append(" ");
        long delta = (System.currentTimeMillis() - START_TIME.getTime()) / 1000L;
        int days = (int)(delta / 86400L);
        int hours = (int)((delta -= (long)(days * 86400)) / 3600L);
        int min = (int)((delta -= (long)(hours * 3600)) / 60L);
        int sec = (int)(delta -= (long)(min * 60));
        DecimalFormat dfTime = new DecimalFormat("00");
        report.append("Uptime: ").append(days).append(" d ").append(dfTime.format(hours)).append(":").append(dfTime.format(min)).append(":").append(dfTime.format(sec));
        return report.toString();
    }

    public static final String memoryStatus() {
        StringBuilder report = new StringBuilder(150);
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);
        Runtime r = Runtime.getRuntime();
        report.append("Memory total: ").append(df.format(r.totalMemory())).append("; max: ").append(df.format(r.maxMemory())).append("; free: ").append(df.format(r.freeMemory()));
        report.append("\nMemory pools:");
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            report.append("\n  ").append(String.valueOf((Object)pool.getType()) + "[" + pool.getName() + "]: ").append("max: ").append(df.format(pool.getUsage().getMax())).append("; used: ").append(df.format(pool.getUsage().getUsed())).append("; peek: ").append(df.format(pool.getPeakUsage().getUsed()));
        }
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        report.append("\nThread count: ").append(threads.getThreadCount());
        return report.toString();
    }

    public void start() {
        new Thread((Runnable)this, "AdminPortListener").start();
    }
}

