/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.process.queue.Column;
import org.bgerp.model.process.queue.filter.Filter;
import org.bgerp.model.process.queue.filter.FilterCustomerParam;
import org.bgerp.model.process.queue.filter.FilterExecutors;
import org.bgerp.model.process.queue.filter.FilterGrEx;
import org.bgerp.model.process.queue.filter.FilterLinkObject;
import org.bgerp.model.process.queue.filter.FilterList;
import org.bgerp.model.process.queue.filter.FilterOpenClose;
import org.bgerp.model.process.queue.filter.FilterParam;
import org.bgerp.model.process.queue.filter.FilterProcessType;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.model.LastModify;
import ru.bgcrm.model.process.queue.Action;
import ru.bgcrm.model.process.queue.MediaColumn;
import ru.bgcrm.model.process.queue.Processor;
import ru.bgcrm.model.process.queue.SortMode;
import ru.bgcrm.model.process.queue.SortSet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class Queue
extends IdTitle {
    private static final Log log = Log.getLog();
    public static final String MEDIA_HTML = "html";
    public static final String MEDIA_HTML_OPEN = "html.open";
    public static final String MEDIA_PRINT = "print";
    public static final String MEDIA_XLS = "xls";
    private static final Set<String> SUPPORTED_PARAM_TYPES = Set.of("address", "datetime", "date", "list", "listcount", "money", "text", "blob");
    private String config;
    private Set<Integer> processTypeIds = new HashSet<Integer>();
    private ConfigMap configMap;
    private List<Column> columnList;
    private Map<Integer, Column> columnMap;
    private SortSet sortSet = new SortSet();
    private final FilterList filterList = new FilterList();
    private final Map<Integer, Processor> processorMap = new HashMap<Integer, Processor>();
    private final List<Action> actionList = new ArrayList<Action>();
    private final List<IdTitle> createAllowedProcessList = new ArrayList<IdTitle>();
    private LastModify lastModify = new LastModify();

    public Queue() {
    }

    public Queue(int id, String title) {
        super(id, title);
    }

    public String getConfig() {
        return this.config;
    }

    private List<String> getMediaColumns(String media) {
        ConfigMap configMap = this.getConfigMap();
        List<String> result = Utils.toList(configMap.get("media." + media + ".columns"));
        if (result.isEmpty() && MEDIA_HTML.equals(media)) {
            result = this.columnMap.keySet().stream().map(String::valueOf).collect(Collectors.toList());
        }
        return result;
    }

    public Queue clone() {
        Queue result = new Queue();
        result.processTypeIds = this.processTypeIds;
        result.configMap = this.configMap;
        result.columnList = this.columnList;
        result.columnMap = this.columnMap;
        result.sortSet = this.sortSet;
        return result;
    }

    public List<MediaColumn> getMediaColumnList(String media) throws NotFoundException {
        return this.getMediaColumnList(this.getMediaColumns(media));
    }

    public List<MediaColumn> getMediaColumnList(List<String> columnIds) throws NotFoundException {
        ArrayList<MediaColumn> result = new ArrayList<MediaColumn>(columnIds.size());
        for (String columnIdStr : columnIds) {
            Column column = this.columnMap.get(Utils.parseInt(columnIdStr));
            int cellIndex = this.columnList.indexOf(column) + 1;
            if (column == null) {
                throw new NotFoundException(Log.format("Not found media queue column with ID: {}", columnIdStr));
            }
            result.add(new MediaColumn(column, cellIndex));
        }
        return result;
    }

    public void replaceRowsForMedia(DynActionForm form, String media, List<Object[]> list) throws SQLException, NotFoundException {
        List<MediaColumn> mediaColumns = this.getMediaColumnList(media);
        boolean isHtmlMedia = MEDIA_HTML.equals(media) || MEDIA_HTML_OPEN.equals(media);
        this.replaceRowsForMediaColumns(form, list, mediaColumns, isHtmlMedia);
    }

    public void replaceRowsForMediaColumns(DynActionForm form, List<Object[]> list, List<MediaColumn> mediaColumns, boolean isHtmlMedia) throws SQLException {
        int columnsForMedia = mediaColumns.size();
        int size = isHtmlMedia ? columnsForMedia + 1 : columnsForMedia;
        int records = list.size();
        for (int k = 0; k < records; ++k) {
            Object[] row = list.get(k);
            Object[] mediaRow = new Object[size];
            if (isHtmlMedia) {
                mediaRow[0] = row[0];
                for (i = 1; i < size; ++i) {
                    mediaColumn = mediaColumns.get(i - 1);
                    if (mediaColumn == null) continue;
                    mediaRow[i] = mediaColumn.getValue(form, isHtmlMedia, row);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    mediaColumn = mediaColumns.get(i);
                    if (mediaColumn == null) continue;
                    mediaRow[i] = mediaColumn.getValue(form, isHtmlMedia, row);
                }
            }
            list.set(k, mediaRow);
        }
    }

    public ConfigMap getConfigMap() {
        if (this.configMap == null) {
            this.configMap = new Preferences(this.config);
        }
        return this.configMap;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Set<Integer> getProcessTypeIds() {
        return this.processTypeIds;
    }

    public void setProcessTypeIds(Set<Integer> processTypes) {
        this.processTypeIds = processTypes;
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public Map<Integer, Column> getColumnMap() {
        return this.columnMap;
    }

    public FilterList getFilterList() {
        return this.filterList;
    }

    public Processor getProcessor(int id) {
        return this.processorMap.get(id);
    }

    public List<Processor> getProcessors(String iface) {
        return this.processorMap.values().stream().filter(p -> p.getIface().equals(iface)).collect(Collectors.toList());
    }

    public Processor getProcessorByPageUrl(String url) {
        return this.processorMap.values().stream().filter(p -> url.equals(p.getPageUrl())).findFirst().orElse(null);
    }

    public SortSet getSortSet() {
        return this.sortSet;
    }

    public List<Action> getActionList() {
        return this.actionList;
    }

    @Dynamic
    public List<IdTitle> getCreateAllowedProcessList() {
        return this.createAllowedProcessList;
    }

    public LastModify getLastModify() {
        return this.lastModify;
    }

    public void setLastModify(LastModify lastModify) {
        this.lastModify = lastModify;
    }

    public String getOpenUrl() {
        return this.getConfigMap().get("openUrl");
    }

    public void extractFiltersAndSorts() throws Exception {
        log.debug("Extracting queue ID: {}, title: {}", this.id, this.title);
        Preferences config = new Preferences(this.config);
        this.columnMap = new TreeMap<Integer, Column>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("column.").entrySet()) {
            this.columnMap.put(me.getKey(), Column.of(String.valueOf(me.getKey()), me.getValue()));
        }
        this.columnList = new ArrayList<Column>(this.columnMap.values());
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("filter.").entrySet()) {
            int id = me.getKey();
            ConfigMap configMap = me.getValue();
            try {
                int paramId;
                String type = configMap.get("type", "");
                if (Strings.CS.equalsAny((CharSequence)type, new CharSequence[]{"status", "groups", "close_date", "create_date", "status_date", "code", "description", "message:systemId", "create_user", "close_user"})) {
                    this.filterList.add(new Filter(id, configMap));
                    continue;
                }
                if ("executors".equals(type)) {
                    this.filterList.add(new FilterExecutors(id, configMap));
                    continue;
                }
                if ("grex".equals(type)) {
                    this.filterList.add(new FilterGrEx(id, configMap));
                    continue;
                }
                if ("openClose".equals(type)) {
                    this.filterList.add(new FilterOpenClose(id, configMap));
                    continue;
                }
                if ("quarter".equals(type)) {
                    paramId = Utils.parseInt(configMap.get("param"));
                    if (paramId <= 0) continue;
                    Parameter parameter = ParameterCache.getParameter(paramId);
                    this.filterList.add(new FilterParam(id, configMap, parameter));
                    continue;
                }
                if ("type".equals(type)) {
                    this.filterList.add(new FilterProcessType(id, configMap));
                    continue;
                }
                if (type.startsWith("linkCustomer:") || type.startsWith("linkedCustomer:")) {
                    int paramId2;
                    Parameter parameter;
                    String entity = StringUtils.substringAfter((String)type, (String)":");
                    if (entity.startsWith("title")) {
                        this.filterList.add(new Filter(id, configMap));
                        continue;
                    }
                    if (!entity.startsWith("param:") || !"list".equals((parameter = ParameterCache.getParameter(paramId2 = Utils.parseInt(StringUtils.substringAfter((String)entity, (String)"param:")))).getType())) continue;
                    this.filterList.add(new FilterCustomerParam(id, configMap, parameter));
                    continue;
                }
                if (type.startsWith("linkObject")) {
                    this.filterList.add(new FilterLinkObject(id, configMap, configMap.get("objectType"), configMap.get("whatFilter", "id")));
                    continue;
                }
                if ("linkedObject".equals(type)) {
                    this.filterList.add(new Filter(id, configMap));
                    continue;
                }
                if (type.startsWith("param:")) {
                    paramId = Utils.parseInt(StringUtils.substringAfter((String)type, (String)":"));
                    Parameter param = ParameterCache.getParameter(paramId);
                    if (param == null) {
                        log.error("Param not found for filter: " + paramId, new Object[0]);
                        continue;
                    }
                    String paramType = param.getType();
                    if (SUPPORTED_PARAM_TYPES.contains(paramType)) {
                        this.filterList.add(new FilterParam(id, configMap, param));
                        continue;
                    }
                    log.error("Queue configuration error " + this.id + " \"" + this.title + "\": in the filter " + id + " configured to unsupported parameter type - " + paramType, new Object[0]);
                    continue;
                }
                log.error("Queue configuration error " + this.id + " \"" + this.title + "\": incorrect filter type " + id + " - " + type, new Object[0]);
            }
            catch (Throwable t) {
                log.error("An error occurred while reading the queue configuration " + this.id + " \"" + this.title + "\" ", t);
            }
        }
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("processor.").entrySet()) {
            Processor p = new Processor(me.getKey(), me.getValue());
            if (Utils.notBlankString(p.getClassName())) {
                Class<?> clazz = Bean.getClass(p.getClassName());
                p = (Processor)clazz.getDeclaredConstructor(Integer.TYPE, ConfigMap.class).newInstance(me.getKey(), me.getValue());
            } else if (Utils.isBlankString(p.getPageUrl())) {
                log.error("For processor {} in process queue {} defined neither 'page.url' or 'className'", me.getKey(), this.id);
                continue;
            }
            this.processorMap.put(p.getId(), p);
        }
        this.sortSet.setComboCount(config.getInt("sort.combo.count", 0));
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("sort.combo.").entrySet()) {
            int value;
            int id = me.getKey();
            ConfigMap configMap = me.getValue();
            int defaultValue = configMap.getInt("default");
            if (defaultValue > 0) {
                this.sortSet.setDefaultSortValue(id, defaultValue);
            }
            if ((value = configMap.getInt("value")) <= 0) continue;
            this.sortSet.setSortValue(id, value);
        }
        for (ConfigMap modeParams : config.subIndexed("sort.mode.").values()) {
            SortMode mode = new SortMode();
            mode.setDesc(modeParams.getBoolean("desc"));
            mode.setTitle(modeParams.get("title"));
            String string = modeParams.get("expr");
            int columnId = (int)modeParams.getSokLong(-1L, "columnId", "column.id");
            if (Utils.notBlankString(string)) {
                mode.setOrderExpression(string);
            } else if (columnId > 0) {
                Column column = this.columnMap.get(columnId);
                if (column == null) {
                    log.error("Queue configuration error " + this.id + " \"" + this.title + "\": sort by non existent column " + columnId, new Object[0]);
                    continue;
                }
                mode.setColumnPos(this.columnList.indexOf(column) + 1);
            } else if (columnId == 0) {
                mode.setOrderExpression("RAND()");
            } else {
                log.error("Incorrect columnId: " + columnId, new Object[0]);
                continue;
            }
            if (!Utils.notBlankString(mode.getTitle())) continue;
            this.sortSet.addMode(mode);
            log.debug("Sort mode add: {}", mode);
        }
        for (ConfigMap actionConfig : config.subIndexed("action.").values()) {
            this.actionList.add(new Action(actionConfig));
        }
        for (Iterator<Object> iterator : config.get("createAllowedProcessList", "").split(";")) {
            String[] pair = ((String)((Object)iterator)).split(":");
            if (pair.length != 2) continue;
            this.createAllowedProcessList.add(new IdTitle(Utils.parseInt(pair[0]), pair[1]));
        }
    }
}

