/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.customer.CustomerGroup;
import ru.bgcrm.util.sql.SQLUtils;

public class CustomerGroupDAO
extends CommonDAO {
    public CustomerGroupDAO(Connection con) {
        super(con);
    }

    public void searchGroup(Pageable<CustomerGroup> searchResult) {
        searchResult.getList().addAll(this.getGroupList());
    }

    public List<CustomerGroup> getGroupList() {
        ArrayList<CustomerGroup> result = new ArrayList<CustomerGroup>();
        try {
            String query = "SELECT * FROM  customer_group_title  ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public CustomerGroup getGroupById(int id) {
        CustomerGroup result = null;
        try {
            String query = "SELECT * FROM  customer_group_title  WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRs(rs);
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void updateGroup(CustomerGroup group) {
        try {
            PreparedStatement ps = null;
            if (group.getId() <= 0) {
                ps = this.con.prepareStatement("INSERT INTO  customer_group_title  (title, comment) VALUES (?,?)", 1);
            } else {
                ps = this.con.prepareStatement("UPDATE  customer_group_title  SET title=?, comment=? WHERE id=?");
                ps.setInt(3, group.getId());
            }
            ps.setString(1, group.getTitle());
            ps.setString(2, group.getComment());
            ps.executeUpdate();
            if (group.getId() <= 0) {
                group.setId(SQLUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteGroup(int id) throws SQLException {
        this.deleteById(" customer_group_title ", id);
    }

    private CustomerGroup getFromRs(ResultSet rs) throws SQLException {
        CustomerGroup result = new CustomerGroup();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        return result;
    }
}

