/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.telegram;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.plugin.telegram.Config;
import org.bgerp.util.Log;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class Bot
extends TelegramLongPollingBot {
    private static final Log log = Log.getLog();
    private static final Set<String> SPECIAL_CHARACTERS = Set.of("_", "~", "`", ">", "#", "+", "-", "=", "|", "{", "}", ".", "!");
    private static Bot instance;
    private final Map<String, UserData> userMap = new HashMap<String, UserData>();
    private static BotSession botSession;

    @VisibleForTesting
    Bot() {
    }

    public static Bot getInstance() {
        if (instance == null) {
            Bot.reinit();
        }
        if (instance == null) {
            log.info("In config server not enable bot (telegram:botStart)", new Object[0]);
        }
        return instance;
    }

    private static void reinit() {
        log.info("Re init.... telegramBot", new Object[0]);
        Config config = Setup.getSetup().getConfig(Config.class);
        if (!config.isBotStart()) {
            log.info("Skipping telegramBot start.", new Object[0]);
            return;
        }
        try {
            instance = Bot.init();
        }
        catch (Throwable t) {
            log.error("telegramBot start ERROR", t);
        }
    }

    private static Bot init() throws Exception {
        try {
            if (botSession != null) {
                botSession.stop();
                botSession = null;
            }
        }
        catch (Exception e) {
            log.error("Catch exception", e);
        }
        TelegramBotsApi botapi = new TelegramBotsApi(DefaultBotSession.class);
        DefaultBotOptions botOptions = new DefaultBotOptions();
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config.getProxyHost() != null) {
            botOptions.setProxyHost(config.getProxyHost());
            botOptions.setProxyPort(Utils.parseInt(config.getProxyPort(), -1));
            DefaultBotOptions.ProxyType type = DefaultBotOptions.ProxyType.NO_PROXY;
            if (config.getProxyType().toUpperCase().equals("SOCKS5")) {
                type = DefaultBotOptions.ProxyType.SOCKS5;
            } else if (config.getProxyType().toUpperCase().equals("HTTP")) {
                type = DefaultBotOptions.ProxyType.HTTP;
            }
            botOptions.setProxyType(type);
        }
        Bot bot = new Bot(botOptions);
        for (int i = 0; i < 3; ++i) {
            try {
                log.info("try start botSession... on " + config.getProxyType() + ":" + config.getProxyHost() + ":" + config.getProxyPort(), new Object[0]);
                botSession = botapi.registerBot((LongPollingBot)bot);
                log.info("botSession=" + String.valueOf(botSession), new Object[0]);
                break;
            }
            catch (TelegramApiException e) {
                log.error("Error start telegram bot", e);
                continue;
            }
        }
        return bot;
    }

    private Bot(DefaultBotOptions botOptions) {
        super(botOptions);
    }

    public String getBotUsername() {
        Config config = Setup.getSetup().getConfig(Config.class);
        return config.getUserName();
    }

    public String getBotToken() {
        Config config = Setup.getSetup().getConfig(Config.class);
        return config.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdateReceived(Update e) {
        if (e.getMessage().isUserMessage() && e.hasMessage() && e.getMessage().hasText()) {
            Config config = Setup.getSetup().getConfig(Config.class);
            Message msg = e.getMessage();
            String text = msg.getText().toLowerCase();
            String chatId = Long.toString(msg.getChatId());
            log.debug("Message: {}", text);
            if (text.equals("/start")) {
                this.sendMessage(chatId, config.getMsgDefaultAnswer());
                return;
            }
            if (text.equals("/login")) {
                this.userMap.put(chatId, new UserData());
                this.sendMessage(chatId, config.getMsgAskLogin());
                return;
            }
            if (text.equals("/getid")) {
                this.userMap.put(chatId, null);
                this.sendMessage(chatId, "Your telegramId=" + chatId);
                return;
            }
            if (text.equals("/help")) {
                this.userMap.put(chatId, null);
                this.sendMessage(chatId, config.getMsgUrlHelp());
                return;
            }
            UserData userData = this.userMap.get(chatId);
            if (userData != null) {
                if (userData.login == null) {
                    userData.login = text;
                    this.sendMessage(chatId, config.getMsgAskPassword());
                } else {
                    User user = UserCache.getUser(userData.login);
                    if (user == null || !user.getPassword().equals(text)) {
                        this.sendMessage(chatId, config.getMsgWrongPassword());
                        this.userMap.put(chatId, new UserData());
                        this.sendMessage(chatId, config.getMsgAskLogin());
                        return;
                    }
                    Connection con = Setup.getSetup().getDBConnectionFromPool();
                    try {
                        ParamValueDAO paramDAO = new ParamValueDAO(con);
                        paramDAO.updateParamText(user.getId(), config.getParamId(), chatId);
                        con.commit();
                        this.userMap.put(chatId, null);
                        this.sendMessage(chatId, config.getMsgLinkChange());
                    }
                    catch (Exception ex) {
                        log.error("Error storing subscription in Telegram ", ex);
                    }
                    finally {
                        SQLUtils.closeConnection(con);
                    }
                }
            }
        }
    }

    void sendMessage(String chatId, String text) {
        SendMessage message = SendMessage.builder().chatId(chatId).text(text).build();
        try {
            this.execute((BotApiMethod)message);
        }
        catch (TelegramApiException e) {
            log.error("Message was not sent ", e);
        }
    }

    void sendMessage(String chatId, String text, String parseMode) {
        SendMessage message = SendMessage.builder().chatId(chatId).text(this.escapeSpecialCharacters(text)).parseMode(parseMode).build();
        try {
            this.execute((BotApiMethod)message);
        }
        catch (TelegramApiException e) {
            log.error("Message was not sent ", e);
        }
    }

    @VisibleForTesting
    String escapeSpecialCharacters(String message) {
        return Arrays.stream(message.split("")).map(c -> {
            if (SPECIAL_CHARACTERS.contains(c)) {
                return "\\" + c;
            }
            return c;
        }).collect(Collectors.joining());
    }

    private static class UserData {
        private String login;

        private UserData() {
        }
    }
}

