/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.action;

import java.io.OutputStream;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.plugin.pln.callboard.cache.CallboardCache;
import org.bgerp.plugin.pln.callboard.dao.ShiftDAO;
import org.bgerp.plugin.pln.callboard.dao.TabelDAO;
import org.bgerp.plugin.pln.callboard.dao.WorkTaskDAO;
import org.bgerp.plugin.pln.callboard.dao.WorkTypeDAO;
import org.bgerp.plugin.pln.callboard.model.DayType;
import org.bgerp.plugin.pln.callboard.model.Shift;
import org.bgerp.plugin.pln.callboard.model.UserComparator;
import org.bgerp.plugin.pln.callboard.model.WorkDaysCalendar;
import org.bgerp.plugin.pln.callboard.model.WorkShift;
import org.bgerp.plugin.pln.callboard.model.WorkTask;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import org.bgerp.plugin.pln.callboard.model.WorkTypeTime;
import org.bgerp.plugin.pln.callboard.model.config.CalendarConfig;
import org.bgerp.plugin.pln.callboard.model.config.CallboardConfig;
import org.bgerp.plugin.pln.callboard.model.config.CategoryConfig;
import org.bgerp.plugin.pln.callboard.model.config.DayTypeConfig;
import org.bgerp.plugin.pln.callboard.model.config.ProcessTimeSetConfig;
import org.bgerp.plugin.pln.callboard.model.work.CellRange;
import org.bgerp.plugin.pln.callboard.model.work.FreeSlotRange;
import org.bgerp.plugin.pln.callboard.model.work.ShiftData;
import org.bgerp.plugin.pln.callboard.model.work.SlotRange;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.ParamChangingEvent;
import ru.bgcrm.event.client.ProcessChangedEvent;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.model.user.User;
import ru.bgcrm.model.user.UserGroup;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.ProcessAction;
import ru.bgcrm.struts.action.admin.UserAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/plugin/callboard/work")
public class WorkAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/callboard";
    private static final Object SET_TIME_MUTEX = new Object();

    public ActionForward planGet(DynActionForm form, Connection con) throws Exception {
        int graphId = form.getParamInt("graphId", 0);
        ConfigMap perm = form.getPermission();
        CallboardConfig config = this.setup.getConfig(CallboardConfig.class);
        form.setResponseData("callboardList", config.getCallboards(Utils.toIntegerSet(perm.get("allowOnlyCallboards"))));
        Date date = form.getParamDate("date");
        form.setResponseData("date", date);
        if (date != null && graphId > 0) {
            CallboardConfig.Callboard callboard = config.get(graphId);
            if (callboard.getCalendarId() > 0) {
                WorkDaysCalendar calendar = this.setup.getConfig(CalendarConfig.class).getCalendar(callboard.getCalendarId());
                Map<Date, Integer> excludeDates = new WorkTypeDAO(con).getWorkDaysCalendarExcludes(callboard.getCalendarId());
                form.setRequestAttribute("dayType", calendar.getDayType(date, excludeDates));
            }
            form.setResponseData("callboard", callboard);
            Map<Integer, List<Integer>> groupWithUsersMap = this.getGroupWithUsersMap(con, callboard, this.getGroupList(form, callboard, true, Utils.toIntegerSet(form.getPermission().get("allowOnlyGroups"))), TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(date));
            Map<Integer, List<WorkShift>> workShiftMap = new ShiftDAO(con).getWorkShift(callboard, TimeUtils.getNextDay(date), date, groupWithUsersMap);
            LinkedHashMap<Integer, List<ShiftData>> groupDataMap = new LinkedHashMap<Integer, List<ShiftData>>();
            form.setResponseData("groupDataMap", groupDataMap);
            this.separateShiftData(date, workShiftMap, groupDataMap);
            new WorkTaskDAO(con).loadWorkTask(graphId, date, groupDataMap);
            form.setResponseData("workTypeMap", CallboardCache.getWorkTypeMap());
        }
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/callboard/plan.jsp");
    }

    public ActionForward processTime(DynActionForm form, Connection con) throws Exception {
        int processId = form.getParamInt("processId");
        if (processId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Process process = new ProcessDAO(con).getProcess(processId);
        ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
        if (type == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430.", new Object[0]);
        }
        ProcessTimeSetConfig timeSetConfig = type.getProperties().getConfigMap().getConfig(ProcessTimeSetConfig.class);
        if (timeSetConfig.getCallboard() != null) {
            WorkTask task = new WorkTaskDAO(con).getTaskByProcessId(processId);
            form.setResponseData("task", task);
            Date date = form.getParamDate("date");
            if (date == null) {
                date = TimeUtils.getNextDay(new Date());
                form.setParam("date", TimeUtils.format(date, "ymd"));
            }
            CallboardConfig.Callboard callboard = timeSetConfig.getCallboard();
            Calendar dateTo = TimeUtils.convertDateToCalendar(date);
            dateTo.add(6, timeSetConfig.getDaysShow());
            List<FreeSlotRange> freeSlots = this.getFreeSlots(con, process, callboard, date, TimeUtils.convertCalendarToDate(dateTo));
            form.setResponseData("slotList", freeSlots);
        }
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/callboard/timeset.jsp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward processTimeSet(DynActionForm form, Connection con) throws Exception {
        int processId = form.getParamInt("processId");
        Date time = TimeUtils.parse(form.getParam("time"), "ymdhm");
        Set<Integer> userIds = Utils.toIntegerSet(form.getParam("userIds"));
        if (processId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ProcessDAO processDao = new ProcessDAO(con);
        Process process = processDao.getProcess(processId);
        ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
        if (type == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430.", new Object[0]);
        }
        ProcessTimeSetConfig timeSetConfig = type.getProperties().getConfigMap().getConfig(ProcessTimeSetConfig.class);
        if (timeSetConfig.getCallboard() != null) {
            CallboardConfig.Callboard callboard = timeSetConfig.getCallboard();
            Object object = SET_TIME_MUTEX;
            synchronized (object) {
                if (time != null) {
                    Calendar cal = TimeUtils.convertDateToCalendar(time);
                    TimeUtils.clear_HOUR_MIN_MIL_SEC(cal);
                    Date date = TimeUtils.convertCalendarToDate(cal);
                    List<FreeSlotRange> slots = this.getFreeSlots(con, process, timeSetConfig.getCallboard(), date, date);
                    FreeSlotRange allowedSlot = slots.stream().filter(slot -> slot.getTime().equals(time)).filter(slot -> slot.getShiftData().userIds.equals(userIds)).findFirst().orElse(null);
                    if (allowedSlot == null) {
                        throw new BGMessageException("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0441\u043b\u043e\u0442 \u0437\u0430\u043d\u044f\u0442.", new Object[0]);
                    }
                    int userId = 0;
                    if (allowedSlot.shiftData.userIds.size() > 0) {
                        userId = Utils.getFirst(allowedSlot.shiftData.userIds);
                    }
                    WorkTask task = new WorkTask();
                    task.setGraphId(callboard.getId());
                    task.setProcessId(processId);
                    task.setReference(process.getTitle());
                    task.setDuration(allowedSlot.duration);
                    task.setSlotFrom(allowedSlot.slotFrom);
                    task.setGroupId(allowedSlot.groupId);
                    task.setTeam(allowedSlot.shiftData.team);
                    task.setUserId(allowedSlot.shiftData.team > 0 ? 0 : userId);
                    task.setTime(time);
                    new WorkTaskDAO(con).addTask(task);
                    ProcessGroup processGroup = new ProcessGroup(allowedSlot.groupId > 0 ? allowedSlot.groupId : callboard.getGroupId());
                    Set<ProcessExecutor> currentExecutors = process.getExecutors();
                    ProcessExecutor.updateProcessExecutors(currentExecutors, processGroup, allowedSlot.shiftData.getUserIds());
                    process.setExecutors(currentExecutors);
                    processDao.updateProcessExecutors(currentExecutors, processId);
                    EventProcessor.processEvent(new ParamChangingEvent(form, timeSetConfig.getParam(), processId, time), new SingleConnectionSet(con));
                    new ParamValueDAO(con).updateParamDateTime(processId, timeSetConfig.getParam().getId(), time);
                    EventProcessor.processEvent(new ParamChangedEvent(form, timeSetConfig.getParam(), processId, time), new SingleConnectionSet(con));
                    int changeStatusToId = timeSetConfig.getChangeStatusToId();
                    if (changeStatusToId > 0 && changeStatusToId != process.getStatusId()) {
                        StatusChange change = new StatusChange();
                        change.setProcessId(process.getId());
                        change.setStatusId(changeStatusToId);
                        change.setDate(new Date());
                        change.setComment("\u041f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
                        ProcessAction.processStatusUpdate(form, con, process, change);
                    }
                    form.getResponse().addEvent(new ProcessChangedEvent(process.getId()));
                } else {
                    new ParamValueDAO(con).updateParamDateTime(processId, timeSetConfig.getParam().getId(), null);
                    new WorkTaskDAO(con).removeTaskForProcess(processId);
                    form.getResponse().addEvent(new ProcessChangedEvent(process.getId()));
                }
            }
        }
        return this.json(con, form);
    }

    public ActionForward processTimeLock(DynActionForm form, Connection con) throws BGMessageException {
        return this.processTimeLockAction(form, con, true);
    }

    public ActionForward processTimeUnlock(DynActionForm form, Connection con) throws BGMessageException {
        return this.processTimeLockAction(form, con, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActionForward processTimeLockAction(DynActionForm form, Connection con, boolean lock) throws BGMessageException {
        int graphId = form.getParamInt("graphId");
        Date date = form.getParamDate("date");
        int groupId = form.getParamInt("groupId");
        int team = form.getParamInt("team");
        int userId = form.getParamInt("userId");
        int dayMinuteFrom = form.getParamInt("dayMinuteFrom");
        if (graphId <= 0 || date == null) {
            throw new BGIllegalArgumentException();
        }
        CallboardConfig.Callboard callboard = Setup.getSetup().getConfig(CallboardConfig.class).get(graphId);
        Calendar cal = TimeUtils.convertDateToCalendar(date);
        cal.add(12, dayMinuteFrom);
        Date time = TimeUtils.convertCalendarToDate(cal);
        Pair<CellRange, SlotRange> result = null;
        Object object = SET_TIME_MUTEX;
        synchronized (object) {
            Map<Integer, List<Integer>> groupWithUsersMap = this.getGroupWithUsersMap(con, callboard, Collections.singletonList(groupId), cal, cal);
            Map<Integer, List<WorkShift>> workShiftMap = new ShiftDAO(con).getWorkShift(callboard, TimeUtils.getNextDay(date), date, groupWithUsersMap);
            LinkedHashMap<Integer, List<ShiftData>> groupDataMap = new LinkedHashMap<Integer, List<ShiftData>>();
            this.separateShiftData(date, workShiftMap, groupDataMap);
            new WorkTaskDAO(con).loadWorkTask(callboard.getId(), date, groupDataMap);
            List dataList = (List)Utils.getFirst(groupDataMap.values());
            if (dataList != null) {
                block3: for (ShiftData data : dataList) {
                    if (team > 0 && data.team != team || !data.userIds.contains(userId)) continue;
                    for (CellRange range : data.getCellRanges(callboard.getPlanConfig())) {
                        for (SlotRange slotRange : range.getSlotRanges()) {
                            if (range.getDayMinuteFrom(slotRange) != dayMinuteFrom) continue;
                            result = new Pair<CellRange, SlotRange>(range, slotRange);
                            break block3;
                        }
                    }
                }
            }
        }
        if (lock) {
            if (result == null) throw new BGException("\u0421\u043b\u043e\u0442 \u0437\u0430\u043d\u044f\u0442 \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!", new Object[0]);
            if (((SlotRange)result.getSecond()).task != null && ((SlotRange)result.getSecond()).task.getProcessId() > 0) {
                throw new BGMessageException("\u0421\u043b\u043e\u0442 \u0437\u0430\u043d\u044f\u0442!", new Object[0]);
            }
            task = new WorkTask();
            task.setGraphId(callboard.getId());
            task.setProcessId(-100);
            task.setDuration(((CellRange)result.getFirst()).workType.getTimeSetStep());
            task.setSlotFrom(((SlotRange)result.getSecond()).slotFrom);
            task.setGroupId(groupId);
            task.setTeam(team);
            task.setUserId(userId);
            task.setTime(time);
            task.setReference("");
            new WorkTaskDAO(con).addTask(task);
            return this.json(con, form);
        } else {
            if (result == null) throw new BGException("\u0421\u043b\u043e\u0442 \u0437\u0430\u043d\u044f\u0442 \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!", new Object[0]);
            if (((SlotRange)result.getSecond()).task == null) return this.json(con, form);
            if (!((SlotRange)result.getSecond()).task.isLock()) {
                throw new BGMessageException("\u0421\u043b\u043e\u0442 \u0437\u0430\u043d\u044f\u0442!", new Object[0]);
            }
            task = new WorkTask();
            task.setGraphId(callboard.getId());
            task.setGroupId(groupId);
            task.setTeam(team);
            task.setUserId(userId);
            task.setTime(time);
            new WorkTaskDAO(con).removeTask(task);
        }
        return this.json(con, form);
    }

    private List<FreeSlotRange> getFreeSlots(Connection con, Process process, CallboardConfig.Callboard callboard, Date dateFrom, Date dateTo) {
        HashSet<Integer> groupIds;
        ArrayList<FreeSlotRange> result = new ArrayList<FreeSlotRange>();
        Set<Integer> processGroupIds = ProcessGroup.getGroupsWithRole(process.getGroups(), 0);
        Integer groupId = (Integer)Utils.getFirst(CollectionUtils.intersection(processGroupIds, groupIds = new HashSet<Integer>(this.getGroupList(null, callboard, false, null))));
        if (groupId != null) {
            Map<Integer, List<Integer>> groupWithUsersMap = this.getGroupWithUsersMap(con, callboard, Collections.singletonList(groupId), TimeUtils.convertDateToCalendar(dateFrom), TimeUtils.convertDateToCalendar(dateTo));
            this.log.debug("groupId: {}; groupWithUsersMap: {}", groupId, groupWithUsersMap);
            Map<Integer, List<WorkShift>> workShiftMap = new ShiftDAO(con).getWorkShift(callboard, TimeUtils.getNextDay(dateFrom), dateTo, groupWithUsersMap);
            this.log.debug("workShiftMap: {}", workShiftMap);
            Date date = (Date)dateFrom.clone();
            while (!date.after(dateTo)) {
                LinkedHashMap<Integer, List<ShiftData>> groupDataMap = new LinkedHashMap<Integer, List<ShiftData>>();
                this.separateShiftData(date, workShiftMap, groupDataMap);
                this.log.debug("Processing: {}; groupDataMap: {}", date, groupDataMap);
                new WorkTaskDAO(con).loadWorkTask(callboard.getId(), date, groupDataMap);
                List dataList = (List)Utils.getFirst(groupDataMap.values());
                if (dataList != null) {
                    for (ShiftData data : dataList) {
                        for (CellRange range : data.getCellRanges(callboard.getPlanConfig())) {
                            WorkType type;
                            if (range.workTypeTime == null || (type = range.workType) == null) continue;
                            int slotSize = type.getTimeSetStep();
                            int time = type.getProcessExecuteTime(con, data, process);
                            if (time <= 0) continue;
                            List<int[]> freeSlotRanges = range.getFreeSlotRanges();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Date: {}; Shift team: {}; userIds: {}; shiftId: {}; time: {}; slotSize: ", TimeUtils.format(date, "ymd"), data.team, data.userIds, data.shiftId, time, slotSize);
                                StringBuilder ranges = new StringBuilder();
                                for (int[] r : freeSlotRanges) {
                                    Utils.addSeparated(ranges, ", ", r[0] + "-" + r[1]);
                                }
                                this.log.debug("Checking free ranges: {}", ranges);
                            }
                            for (int[] freeRange : freeSlotRanges) {
                                for (int rangeStart = freeRange[0]; rangeStart < freeRange[1]; ++rangeStart) {
                                    if ((freeRange[1] - rangeStart + 1) * slotSize < time) continue;
                                    result.add(new FreeSlotRange(date, groupId, data, range, rangeStart, time));
                                    this.log.debug("FreeSlotRange: {}", rangeStart);
                                }
                            }
                        }
                    }
                }
                date = TimeUtils.getNextDay(date);
            }
        }
        return result;
    }

    private void separateShiftData(Date date, Map<Integer, List<WorkShift>> workShiftMap, Map<Integer, List<ShiftData>> groupDataMap) {
        for (Map.Entry<Integer, List<WorkShift>> me : workShiftMap.entrySet()) {
            int groupId = me.getKey();
            List<ShiftData> groupData = groupDataMap.get(groupId);
            if (groupData == null) {
                groupData = new ArrayList<ShiftData>();
                groupDataMap.put(groupId, groupData);
            }
            for (WorkShift shift : me.getValue()) {
                if (!date.equals(shift.getDate())) continue;
                int team = shift.getTeam();
                int userId = shift.getUserId();
                int shiftId = shift.getShiftId();
                ShiftData existData = null;
                for (ShiftData data : groupData) {
                    if (team <= 0 || shiftId != data.shiftId || team != data.team) continue;
                    existData = data;
                    existData.userIds.add(userId);
                    break;
                }
                if (existData != null) continue;
                existData = new ShiftData();
                existData.team = team;
                existData.shiftId = shiftId;
                existData.userIds = new HashSet<Integer>(Arrays.asList(userId));
                existData.workTypeTimeList = shift.getWorkTypeTimeList();
                groupData.add(existData);
            }
        }
    }

    public ActionForward callboardGet(DynActionForm form, Connection con) throws Exception {
        long time = System.currentTimeMillis();
        int graphId = form.getParamInt("graphId", 0);
        ConfigMap perm = form.getPermission();
        CallboardConfig config = this.setup.getConfig(CallboardConfig.class);
        this.log.debug("callboardGet1: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
        form.setResponseData("callboardList", config.getCallboards(Utils.toIntegerSet(perm.get("allowOnlyCallboards", perm.get("allowOnlyTabels")))));
        Date fromDate = form.getParamDate("fromDate");
        Date toDate = form.getParamDate("toDate");
        LinkedHashMap<Integer, List<Integer>> groupWithUsersMap = new LinkedHashMap();
        if (fromDate != null && toDate != null) {
            if (fromDate.compareTo(toDate) > 0) {
                throw new BGException("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u043a\u043e\u043d\u0446\u0430", new Object[0]);
            }
            ArrayList<Date> dateSet = new ArrayList<Date>();
            Date day = fromDate;
            while (day.compareTo(toDate) <= 0) {
                dateSet.add(day);
                day = TimeUtils.getNextDay(day);
            }
            form.setResponseData("dateSet", dateSet);
            form.setRequestAttribute("prevDate", TimeUtils.getPrevDay(fromDate));
            if (graphId > 0) {
                CallboardConfig.Callboard callboard = config.get(graphId);
                if (callboard.getCalendarId() > 0) {
                    WorkDaysCalendar calendar = this.setup.getConfig(CalendarConfig.class).getCalendar(callboard.getCalendarId());
                    Map<Date, Integer> excludeDates = new WorkTypeDAO(con).getWorkDaysCalendarExcludes(callboard.getCalendarId());
                    HashMap<Date, Pair<DayType, Boolean>> dateTypeMap = new HashMap<Date, Pair<DayType, Boolean>>();
                    form.setResponseData("dateTypeMap", dateTypeMap);
                    for (Date date : dateSet) {
                        dateTypeMap.put(date, calendar.getDayType(date, excludeDates));
                    }
                }
                groupWithUsersMap = this.getGroupWithUsersMap(con, callboard, this.getGroupList(form, callboard, true, Utils.toIntegerSet(form.getPermission().get("allowOnlyGroups"))), TimeUtils.convertDateToCalendar(fromDate), TimeUtils.convertDateToCalendar(toDate));
                form.setResponseData("callboard", callboard);
                this.log.debug("callboardGet2: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
                Map<Integer, Shift> allShiftMap = new ShiftDAO(con).getAllShiftMap();
                LinkedHashMap<Integer, Shift> avaiableShiftMap = new LinkedHashMap<Integer, Shift>();
                Set<Integer> availableCategoryIds = this.getAvailableCategoryIds(perm);
                for (Map.Entry entry : allShiftMap.entrySet()) {
                    if (!availableCategoryIds.contains(((Shift)entry.getValue()).getCategory())) continue;
                    avaiableShiftMap.put((Integer)entry.getKey(), (Shift)entry.getValue());
                }
                this.log.debug("callboardGet3: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
                form.setResponseData("shiftMap", allShiftMap);
                form.setResponseData("avaiableShiftMap", avaiableShiftMap);
                Map<Integer, List<WorkShift>> workShiftMap = new ShiftDAO(con).getWorkShift(callboard, fromDate, toDate, groupWithUsersMap);
                form.setResponseData("workShiftMap", workShiftMap);
                form.setResponseData("availableDays", new ShiftDAO(con).getAvailableDateForShift(callboard, groupWithUsersMap, fromDate, toDate));
                this.log.debug("callboardGet4: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
                form.setResponseData("groupWithUsersMap", groupWithUsersMap);
                this.log.debug("callboardGet5: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
                form.setResponseData("workTypeList", this.getAvailableWorkTypeList(con, perm));
                this.log.debug("callboardGet6: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
                form.setResponseData("allowOnlyCategories", this.getAvailableCategories(perm));
            }
            this.log.debug("callboardGet: " + (System.currentTimeMillis() - time) + " ms.", new Object[0]);
        }
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/callboard/callboard/update.jsp");
    }

    protected List<CategoryConfig.Category> getAvailableCategories(ConfigMap perm) throws Exception {
        return this.setup.getConfig(CategoryConfig.class).getCategoryList(Utils.toIntegerSet(perm.get("allowOnlyCategories", "")));
    }

    protected Set<Integer> getAvailableCategoryIds(ConfigMap perm) throws Exception {
        return this.setup.getConfig(CategoryConfig.class).getCategoryIds(Utils.toIntegerSet(perm.get("allowOnlyCategories", "")));
    }

    private List<WorkType> getAvailableWorkTypeList(Connection con, ConfigMap perm) throws Exception {
        ArrayList<WorkType> resultList = new ArrayList<WorkType>();
        Set<Integer> availableCategoryIds = this.getAvailableCategoryIds(perm);
        for (WorkType workType : new WorkTypeDAO(con).getWorkTypeList()) {
            if (!availableCategoryIds.contains(workType.getCategory())) continue;
            resultList.add(workType);
        }
        return resultList;
    }

    public ActionForward callboardUpdateFilters(DynActionForm form, Connection con) throws Exception {
        Boolean hideEmptyGroups = form.getParamBoolean("hideEmptyGroups", false);
        Boolean hideEmptyShifts = form.getParamBoolean("hideEmptyShifts", false);
        int graphId = form.getParamInt("graphId", 0);
        CallboardConfig config = this.setup.getConfig(CallboardConfig.class);
        CallboardConfig.Callboard callboard = config.get(graphId);
        if (callboard == null) {
            throw new BGException("\u0413\u0440\u0430\u0444\u0438\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", new Object[0]);
        }
        callboard.setHideEmptyGroups(hideEmptyGroups);
        callboard.setHideEmptyShifts(hideEmptyShifts);
        return this.json(con, form);
    }

    public ActionForward callboardUpdateShift(DynActionForm form, Connection con) throws Exception {
        int graphId = form.getParamInt("graphId", 0);
        int userId = form.getParamInt("userId", 0);
        int groupId = form.getParamInt("groupId", -1);
        int teamId = form.getParamInt("team", 0);
        int shiftId = form.getParamInt("shiftId", 0);
        ShiftDAO shiftDAO = new ShiftDAO(con);
        if (graphId == 0) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0433\u0440\u0430\u0444\u0438\u043a\u0430", new Object[0]);
        }
        if (userId == 0) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", new Object[0]);
        }
        if (groupId < 0) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0433\u0440\u0443\u043f\u043f\u0430", new Object[0]);
        }
        if (form.getParam("date", "").length() == 0) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430", new Object[0]);
        }
        Set<Integer> allowedCallboards = Utils.toIntegerSet(form.getPermission().get("allowOnlyCallboards"));
        if (allowedCallboards.size() != 0 && !allowedCallboards.contains(graphId)) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u0442\u043e\u0433\u043e \u0433\u0440\u0430\u0444\u0438\u043a\u0430.", new Object[0]);
        }
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yy");
        Date date = format.parse(form.getParam("date"));
        CallboardConfig config = this.setup.getConfig(CallboardConfig.class);
        CallboardConfig.Callboard callboard = config.get(graphId);
        if (callboard == null) {
            throw new BGException("\u0413\u0440\u0430\u0444\u0438\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", new Object[0]);
        }
        boolean allowed = callboard.getConfigMap().getBoolean("pastEditAllowed", true);
        if (!allowed && TimeUtils.dateBefore(date, new Date())) {
            throw new BGException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0433\u0440\u0430\u0444\u0438\u043a \u0437\u0430 \u043f\u0440\u043e\u0448\u0435\u0434\u0448\u0438\u0435 \u0434\u043d\u0438", new Object[0]);
        }
        if (!this.hasMembershipAtDate(userId, groupId > 0 ? groupId : callboard.getGroupId(), date)) {
            if (callboard.getConfigMap().getBoolean("autoAddGroup", false)) {
                UserDAO userDao = new UserDAO(con);
                UserGroup group = new UserGroup(groupId, date, date);
                Date prevDate = TimeUtils.getPrevDay(date);
                Date nextDate = TimeUtils.getNextDay(date);
                boolean existChanged = false;
                List<UserGroup> existGroups = UserCache.getUserGroupList(userId);
                for (UserGroup userGroup : existGroups) {
                    if (userGroup.getGroupId() != groupId) continue;
                    if (TimeUtils.dateEqual(userGroup.getDateFrom(), nextDate)) {
                        userDao.removeUserGroup(userId, groupId, userGroup.getDateFrom(), userGroup.getDateTo());
                        userGroup.setDateFrom(date);
                        userDao.addUserGroup(userId, userGroup);
                        existChanged = true;
                        break;
                    }
                    if (!TimeUtils.dateEqual(userGroup.getDateTo(), prevDate)) continue;
                    userDao.removeUserGroup(userId, groupId, userGroup.getDateFrom(), userGroup.getDateTo());
                    userGroup.setDateTo(date);
                    userDao.addUserGroup(userId, userGroup);
                    existChanged = true;
                    break;
                }
                if (!existChanged) {
                    new UserDAO(con).addUserGroup(userId, group);
                }
                UserCache.flush(con);
            } else {
                throw new BGException("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0441\u0442\u043e\u0438\u0442 \u0432 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 \u0432 \u044d\u0442\u043e\u0442 \u0434\u0435\u043d\u044c", new Object[0]);
            }
        }
        shiftDAO.deleteWorkShift(graphId, groupId, userId, date);
        if (shiftId > 0) {
            Shift shift = shiftDAO.getShift(shiftId);
            WorkShift workShift = new WorkShift();
            workShift.setGraphId(graphId);
            workShift.setGroupId(groupId);
            workShift.setUserId(userId);
            workShift.setTeam(teamId);
            workShift.setDate(date);
            workShift.setWorkTypeTimeList(shift.getWorkTypeTimeList());
            workShift.setShiftId(shiftId);
            shiftDAO.updateWorkShift(workShift);
            form.setResponseData("minutes", WorkTypeTime.getWorkMinutesInDay(shift.getWorkTypeTimeList(), date, form.getParamBoolean("lastDate", false) != false ? date : null));
        } else {
            form.setResponseData("minutes", 0);
        }
        return this.json(con, form);
    }

    public ActionForward userChangeGroup(DynActionForm form, Connection con) throws Exception {
        int userId = form.getParamInt("userId", 0);
        int groupId = form.getParamInt("group", -1);
        int graphId = form.getParamInt("graphId", -1);
        Date dateFrom = form.getParamDate("fromDate");
        Date dateTo = form.getParamDate("toDate");
        CallboardConfig config = this.setup.getConfig(CallboardConfig.class);
        CallboardConfig.Callboard callboard = config.get(graphId);
        List<Integer> groups = ((WorkAction)((Object)WorkAction.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))).getGroupList(form, callboard, false, null);
        List<UserGroup> userGroupList = UserCache.getUserGroupList(userId);
        ArrayList<UserGroup> result = new ArrayList<UserGroup>();
        for (Integer group : groups) {
            for (UserGroup userGroup : userGroupList) {
                if (userGroup.getGroupId() != group.intValue()) continue;
                result.add(userGroup);
            }
        }
        if (result.size() > 1) {
            throw new BGException("\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442 \u0447\u0438\u0441\u043b\u0438\u0442\u0441\u044f \u0432 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b, \u043e\u0434\u043d\u0443 \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043d\u0430\u0434\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0438 \u043f\u0435\u0440\u0435\u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u0437\u0430\u043d\u043e\u0432\u043e.", new Object[0]);
        }
        Calendar cal = Calendar.getInstance();
        ((UserAction)((Object)UserAction.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))).addGroup(form, con, dateFrom, dateTo, groupId, userId);
        Integer oldGroupId = ((UserGroup)result.get(0)).getGroupId();
        cal.setTime(dateFrom);
        cal.add(5, -1);
        Date closeDate = cal.getTime();
        ((UserAction)((Object)UserAction.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))).closeGroup(form, con, userId, oldGroupId, closeDate, ((UserGroup)result.get(0)).getDateFrom(), null);
        cal.setTime(dateTo);
        cal.add(5, 1);
        dateFrom = cal.getTime();
        ((UserAction)((Object)UserAction.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))).addGroup(form, con, dateFrom, null, oldGroupId, userId);
        return this.json(con, form);
    }

    private boolean hasMembershipAtDate(int userId, int groupId, Date date) {
        boolean hasMembership = false;
        List<UserGroup> userGroupList = UserCache.getUserGroupList(userId);
        Iterator<UserGroup> iterator = userGroupList.iterator();
        while (iterator.hasNext() && !hasMembership) {
            UserGroup userGroup = iterator.next();
            if (userGroup.getGroupId() != groupId || !TimeUtils.dateInRange(this.convertToCalendarAndTruncateTime(date), this.convertToCalendarAndTruncateTime(userGroup.getDateFrom()), this.convertToCalendarAndTruncateTime(userGroup.getDateTo()))) continue;
            hasMembership = true;
        }
        return hasMembership;
    }

    private Calendar convertToCalendarAndTruncateTime(Date date) {
        GregorianCalendar calendar = null;
        if (date != null) {
            calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar;
    }

    public ActionForward callboardChangeOrder(DynActionForm form, Connection con) throws Exception {
        int graphId = form.getParamInt("graphId", 0);
        int groupId = form.getParamInt("groupId", 0);
        HashMap<Integer, Integer> userOrderMap = new HashMap<Integer, Integer>();
        for (String item : Utils.toSet(form.getParam("order", ""))) {
            if (!item.contains(":")) continue;
            userOrderMap.put(Integer.parseInt(item.substring(0, item.indexOf(":"))), Integer.parseInt(item.substring(item.indexOf(":") + 1)));
        }
        if (userOrderMap.size() > 0) {
            new ShiftDAO(con).updateShiftOrder(graphId, groupId, userOrderMap);
        }
        return this.json(con, form);
    }

    public ActionForward callboardGetTabel(DynActionForm form, Connection con) throws Exception {
        int graphId = form.getParamInt("graphId", 0);
        Date fromDate = form.getParamDate("fromDate");
        Date toDate = form.getParamDate("toDate");
        CallboardConfig.Callboard callboard = this.setup.getConfig(CallboardConfig.class).get(graphId);
        if (callboard == null) {
            throw new BGException("Not found callboard " + graphId, new Object[0]);
        }
        HSSFWorkbook book = new TabelDAO(con).generateTabel(callboard, fromDate, toDate);
        HttpServletResponse response = form.getHttpResponse();
        Utils.setFileNameHeaders(response, "tabel_" + TimeUtils.format(fromDate, "ymd") + "_" + TimeUtils.format(toDate, "ymd") + ".xls");
        book.write((OutputStream)response.getOutputStream());
        return null;
    }

    public ActionForward callboardAvailableShift(DynActionForm form, Connection con) throws Exception {
        int categoryId = form.getParamInt("categoryId", 0);
        int graphId = form.getParamInt("graphId", 0);
        Set<Integer> shiftIds = Utils.toIntegerSet(form.getParam("shiftIds", ""));
        if (!(categoryId <= 0 && shiftIds.size() != 0 || this.getAvailableCategoryIds(form.getPermission()).contains(categoryId))) {
            throw new BGException("\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0441\u043c\u0435\u043d \u0432 \u044d\u0442\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", new Object[0]);
        }
        form.setResponseData("workTypeMap", CallboardCache.getWorkTypeMap());
        form.setResponseData("shiftList", categoryId > 0 ? new ShiftDAO(con).getShiftList(categoryId) : new ShiftDAO(con).getShiftList(shiftIds));
        if (graphId > 0 && this.setup.subIndexed("callboard.").containsKey(graphId)) {
            form.setResponseData("minimalVersion", ((ConfigMap)this.setup.subIndexed("callboard.").get(graphId)).getInt("minimalVersion", 0));
        } else {
            form.setResponseData("minimalVersion", 0);
        }
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/callboard/callboard/available_shift.jsp");
    }

    public ActionForward workDaysCalendarList(DynActionForm form, Connection con) throws Exception {
        form.setResponseData("workDaysCalendarList", this.setup.getConfig(CalendarConfig.class).getCalendars());
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/callboard/calendar/list.jsp");
    }

    public ActionForward workDaysCalendarGet(DynActionForm form, Connection con) throws Exception {
        int selectedYear = form.getParamInt("year", new GregorianCalendar().get(1));
        form.setParam("year", String.valueOf(selectedYear));
        DayTypeConfig dayTypesConfig = this.setup.getConfig(DayTypeConfig.class);
        if (dayTypesConfig.getTypes().size() == 0) {
            throw new BGException("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0439 \u0442\u0438\u043f\u043e\u0432 \u0440\u0430\u0431\u043e\u0447\u0438\u0445 \u0434\u043d\u0435\u0439", new Object[0]);
        }
        WorkDaysCalendar calendar = this.setup.getConfig(CalendarConfig.class).getCalendar(form.getId());
        if (calendar == null) {
            throw new BGException("\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", new Object[0]);
        }
        Map<Date, Integer> excludeDates = new WorkTypeDAO(con).getWorkDaysCalendarExcludes(form.getId());
        HashMap<Date, Pair<DayType, Boolean>> dateTypeMap = new HashMap<Date, Pair<DayType, Boolean>>();
        form.setResponseData("dateTypeMap", dateTypeMap);
        GregorianCalendar dateFrom = new GregorianCalendar(selectedYear, 0, 1);
        GregorianCalendar dateTo = new GregorianCalendar(selectedYear, 11, 31);
        while (TimeUtils.dateBeforeOrEq(dateFrom, dateTo)) {
            Date date = dateFrom.getTime();
            dateTypeMap.put(date, calendar.getDayType(date, excludeDates));
            ((Calendar)dateFrom).add(6, 1);
        }
        form.setResponseData("calendar", calendar);
        form.setResponseData("dayTypes", dayTypesConfig.getTypes());
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/callboard/calendar/update.jsp");
    }

    public ActionForward workDaysCalendarUpdate(DynActionForm form, Connection con) throws Exception {
        int calendarId = form.getParamInt("calendarId", 0);
        int type = form.getParamInt("type", 0);
        Date date = form.getParamDate("date");
        WorkDaysCalendar calendar = this.setup.getConfig(CalendarConfig.class).getCalendar(calendarId);
        if (calendar == null) {
            throw new BGException("\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", new Object[0]);
        }
        if (date == null) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f: \u0434\u0430\u0442\u0430 \u043d\u0435 \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u043d\u0430", new Object[0]);
        }
        Pair<DayType, Boolean> byRule = calendar.getDayType(date, null);
        if (byRule != null && byRule.getFirst().getId() == type) {
            type = 0;
        }
        new WorkTypeDAO(con).updateWorkDaysCalendar(calendarId, type, date);
        return this.json(con, form);
    }

    public ActionForward workDaysCalendarCopy(DynActionForm form, Connection con) throws Exception {
        int calendarId = form.getParamInt("calendarId", 0);
        int from = form.getParamInt("from", 0);
        int to = form.getParamInt("to", 0);
        if (from == 0 || to == 0) {
            throw new BGException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u0435 \u0434\u0430\u0442\u044b", new Object[0]);
        }
        if (from == to) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0430\u043c\u043e\u0433\u043e \u0432 \u0441\u0435\u0431\u044f", new Object[0]);
        }
        new WorkTypeDAO(con).copyWorkDaysCalendar(calendarId, from, to);
        return this.json(con, form);
    }

    protected List<Integer> getGroupList(DynActionForm form, CallboardConfig.Callboard callboard, boolean excludeHidden, Set<Integer> allowOnlyGroups) {
        Group parentGroup;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Set<Object> groupsFilter = Collections.emptySet();
        if (form != null) {
            groupsFilter = form.getParamValues("groupId");
        }
        if ((parentGroup = UserCache.getUserGroup(callboard.getGroupId())) == null) {
            throw new BGException("\u0413\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c: " + callboard.getGroupId(), new Object[0]);
        }
        Set<Integer> groups = parentGroup.getChildSet();
        for (Group group : UserCache.getUserGroupList()) {
            int groupId = group.getId();
            if (!groups.contains(groupId) || excludeHidden && group.getArchive() > 0 || groupsFilter.size() > 0 && !groupsFilter.contains(groupId) || CollectionUtils.isNotEmpty(allowOnlyGroups) && !allowOnlyGroups.contains(groupId)) continue;
            result.add(groupId);
        }
        if (groupsFilter.size() == 0 && CollectionUtils.isEmpty(allowOnlyGroups)) {
            result.add(callboard.getGroupId());
        }
        return result;
    }

    protected Map<Integer, List<Integer>> getGroupWithUsersMap(Connection con, CallboardConfig.Callboard callboard, List<Integer> groupIds, Calendar dateFrom, Calendar dateTo) {
        LinkedHashMap<Integer, List<Integer>> resultMap = new LinkedHashMap<Integer, List<Integer>>();
        HashSet<Integer> userInSubGroups = new HashSet<Integer>();
        for (Integer groupId : groupIds) {
            List<Integer> userList;
            if (groupId.intValue() != callboard.getGroupId()) {
                userList = this.getGroupUsers(con, callboard, groupId, dateFrom, dateTo);
                resultMap.put(groupId, userList);
                userInSubGroups.addAll(userList);
                continue;
            }
            userList = this.getGroupUsers(con, callboard, callboard.getGroupId(), dateFrom, dateTo);
            userList.removeAll(userInSubGroups);
            resultMap.put(0, userList);
            break;
        }
        return resultMap;
    }

    private List<Integer> getGroupUsers(Connection con, CallboardConfig.Callboard callboard, int groupId, Calendar dateFrom, Calendar dateTo) {
        ArrayList<Integer> userList = new ArrayList<Integer>();
        Map<Integer, Integer> shiftOrderMap = new ShiftDAO(con).getShiftOrder(callboard.getId(), groupId);
        block0: for (User user : UserCache.getUserList()) {
            for (UserGroup userGroup : UserCache.getUserGroupList(user.getId())) {
                if (userGroup.getGroupId() != groupId || !TimeUtils.checkDateIntervalsIntersection(TimeUtils.convertDateToCalendar(userGroup.getDateFrom()), TimeUtils.convertDateToCalendar(userGroup.getDateTo()), dateFrom, dateTo)) continue;
                userList.add(user.getId());
                continue block0;
            }
        }
        Collections.sort(userList, shiftOrderMap.size() > 0 ? new UserComparator(shiftOrderMap) : new UserComparator());
        return userList;
    }
}

