/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.bgerp.util.Log;

public class OpenFilter
implements Filter {
    private static final Log log = Log.getLog();
    private static final String OPEN_URL_PREFIX = "/open/";
    private static final String REQUEST_ATTRIBUTE_URI = OpenFilter.class.getName() + ".URI";
    private static final String REQUEST_ATTRIBUTE_SECRET = OpenFilter.class.getName() + ".Secret";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestURI = request.getRequestURI();
        if (requestURI.endsWith(".jsp")) {
            log.warn("Attempt to access JSP: {}", requestURI);
            return;
        }
        if (requestURI.endsWith(".do")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        RequestDispatcher requestDispatcher = request.getServletContext().getRequestDispatcher("/open/shell.jsp");
        request.setAttribute(REQUEST_ATTRIBUTE_URI, (Object)requestURI);
        request.setAttribute(REQUEST_ATTRIBUTE_SECRET, (Object)request.getParameter("secret"));
        requestDispatcher.forward((ServletRequest)request, servletResponse);
    }

    public static final String getRequestURI(ServletRequest request) {
        return (String)request.getAttribute(REQUEST_ATTRIBUTE_URI);
    }

    public static final String getRequestSecret(ServletRequest request) {
        return (String)request.getAttribute(REQUEST_ATTRIBUTE_SECRET);
    }
}

