/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.internal.AsyncEventPump;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.EventBuilderImpl;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.internal.ResponseBuilderImpl;
import org.asteriskjava.manager.internal.backwardsCompatibility.BackwardsCompatibilityForManagerEvents;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;

public class ManagerReaderImpl
implements ManagerReader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final EventBuilder eventBuilder;
    private final ResponseBuilder responseBuilder;
    private final Map<String, Class<? extends ManagerResponse>> expectedResponseClasses;
    private final Object source;
    private SocketConnectionFacade socket;
    private volatile boolean die = false;
    private boolean dead = false;
    private IOException terminationException;
    BackwardsCompatibilityForManagerEvents compatibility = new BackwardsCompatibilityForManagerEvents();
    private final Dispatcher rawDispatcher;

    public ManagerReaderImpl(Dispatcher dispatcher, Object source) {
        this.rawDispatcher = dispatcher;
        this.source = source;
        this.eventBuilder = new EventBuilderImpl();
        this.responseBuilder = new ResponseBuilderImpl();
        this.expectedResponseClasses = new ConcurrentHashMap<String, Class<? extends ManagerResponse>>();
    }

    @Override
    public void setSocket(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    @Override
    public void registerEventClass(Class<? extends ManagerEvent> eventClass) {
        this.eventBuilder.registerEventClass(eventClass);
    }

    @Override
    public void expectResponseClass(String internalActionId, Class<? extends ManagerResponse> responseClass) {
        this.expectedResponseClasses.put(internalActionId, responseClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long timeOfLastEvent = 0L;
        long reserve = 0L;
        HashMap<String, Object> buffer = new HashMap<String, Object>();
        if (this.socket == null) {
            throw new IllegalStateException("Unable to run: socket is null.");
        }
        this.die = false;
        this.dead = false;
        AsyncEventPump dispatcher = new AsyncEventPump(this, this.rawDispatcher, Thread.currentThread().getName());
        long slowEventThresholdMs = 10L;
        RateLimiter slowEventLogLimiter = RateLimiter.create((double)4.0);
        try {
            String line;
            while (!this.die && (line = this.socket.readLine()) != null) {
                if (line.startsWith("Asterisk Call Manager/") || line.startsWith("Asterisk Call Manager Proxy/") || line.startsWith("Asterisk Manager Proxy/") || line.startsWith("OpenPBX Call Manager/") || line.startsWith("CallWeaver Call Manager/")) {
                    ProtocolIdentifierReceivedEvent protocolIdentifierReceivedEvent = new ProtocolIdentifierReceivedEvent(this.source);
                    protocolIdentifierReceivedEvent.setProtocolIdentifier(line);
                    protocolIdentifierReceivedEvent.setDateReceived(DateUtil.getDate());
                    dispatcher.dispatchEvent(protocolIdentifierReceivedEvent, null);
                    continue;
                }
                if ("Follows".equals(buffer.get("response")) && line.endsWith("--END COMMAND--")) {
                    buffer.put("__result__", line);
                    continue;
                }
                if (line.length() > 0) {
                    int isFromAtStart = line.indexOf("From ");
                    int isToAtStart = line.indexOf("To ");
                    int delimiterIndex = isFromAtStart == 0 || isToAtStart == 0 ? line.indexOf(" ") : line.indexOf(":");
                    int delimiterLength = 1;
                    if (delimiterIndex > 0 && line.length() > delimiterIndex + delimiterLength) {
                        String name = line.substring(0, delimiterIndex).toLowerCase(Locale.ENGLISH).trim();
                        String value = line.substring(delimiterIndex + delimiterLength).trim();
                        this.addToBuffer(buffer, name, value);
                    }
                }
                if (line.length() != 0) continue;
                Serializable cause = null;
                LogTime timer = new LogTime();
                if (buffer.containsKey("event")) {
                    ManagerEvent event = this.buildEvent(this.source, buffer);
                    if (event != null) {
                        cause = event;
                        dispatcher.dispatchEvent(event, null);
                        ManagerEvent secondaryEvent = this.compatibility.handleEvent(event);
                        if (secondaryEvent != null) {
                            dispatcher.dispatchEvent(secondaryEvent, null);
                        }
                    } else {
                        this.logger.debug("buildEvent returned null");
                    }
                } else if (buffer.containsKey("response")) {
                    ManagerResponse response = this.buildResponse(buffer);
                    if (response != null) {
                        cause = response;
                        dispatcher.dispatchResponse(response, null);
                    }
                } else if (!buffer.isEmpty()) {
                    this.logger.debug("Buffer contains neither response nor event");
                }
                buffer.clear();
                long elapsed = timer.timeTaken();
                long now = System.currentTimeMillis();
                long add = now - timeOfLastEvent;
                reserve = reserve + add - elapsed * 2L;
                reserve = Math.min(500L, reserve);
                reserve = Math.max(0L, reserve);
                timeOfLastEvent = now;
                if (elapsed <= slowEventThresholdMs || reserve > 0L || !slowEventLogLimiter.tryAcquire()) continue;
                this.logger.warn("(This is normal during JVM warmup) Slow processing of event " + elapsed + "\n" + cause);
            }
            this.dead = true;
            this.logger.debug("Reached end of stream, terminating reader.");
        }
        catch (IOException e) {
            this.terminationException = e;
            this.dead = true;
            this.logger.info("Terminating reader thread: " + e.getMessage());
        }
        catch (Exception e) {
            if (this.terminationException == null) {
                this.terminationException = new IOException(e);
            }
            this.logger.error("Manager reader exiting due to unexpected Exception...");
            this.logger.error(e, e);
        }
        finally {
            this.dead = true;
            DisconnectEvent disconnectEvent = new DisconnectEvent(this.source);
            disconnectEvent.setDateReceived(DateUtil.getDate());
            dispatcher.dispatchEvent(disconnectEvent, null);
            dispatcher.stop();
        }
    }

    private void addToBuffer(Map<String, Object> buffer, String name, String value) {
        if (buffer.containsKey(name)) {
            Object currentValue = buffer.get(name);
            if (currentValue instanceof List) {
                ((List)currentValue).add(value);
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (currentValue instanceof String) {
                list.add((String)currentValue);
            } else {
                list.add(currentValue.toString());
            }
            list.add(value);
            buffer.put(name, list);
        } else {
            buffer.put(name, value);
        }
    }

    @Override
    public void die() {
        this.die = true;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    @Override
    public IOException getTerminationException() {
        return this.terminationException;
    }

    private ManagerResponse buildResponse(Map<String, Object> buffer) {
        ManagerResponse response;
        Class<? extends ManagerResponse> responseClass = null;
        String actionId = (String)buffer.get("actionid");
        String internalActionId = ManagerUtil.getInternalActionId(actionId);
        if (internalActionId != null) {
            responseClass = this.expectedResponseClasses.remove(internalActionId);
        }
        if ((response = this.responseBuilder.buildResponse(responseClass, buffer)) != null) {
            response.setDateReceived(DateUtil.getDate());
        }
        return response;
    }

    private ManagerEvent buildEvent(Object source, Map<String, Object> buffer) {
        ManagerEvent event = this.eventBuilder.buildEvent(source, buffer);
        if (event != null) {
            event.setDateReceived(DateUtil.getDate());
        }
        return event;
    }

    @Override
    public void deregisterEventClass(Class<? extends ManagerEvent> eventClass) {
        this.eventBuilder.deregisterEventClass(eventClass);
    }
}

