/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.facilities.TelegramHttpClientBuilder;
import org.telegram.telegrambots.facilities.filedownloader.TelegramFileDownloader;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.groupadministration.SetChatPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendAnimation;
import org.telegram.telegrambots.meta.api.methods.send.SendAudio;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaGroup;
import org.telegram.telegrambots.meta.api.methods.send.SendPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendSticker;
import org.telegram.telegrambots.meta.api.methods.send.SendVideo;
import org.telegram.telegrambots.meta.api.methods.send.SendVideoNote;
import org.telegram.telegrambots.meta.api.methods.send.SendVoice;
import org.telegram.telegrambots.meta.api.methods.stickers.AddStickerToSet;
import org.telegram.telegrambots.meta.api.methods.stickers.CreateNewStickerSet;
import org.telegram.telegrambots.meta.api.methods.stickers.SetStickerSetThumb;
import org.telegram.telegrambots.meta.api.methods.stickers.UploadStickerFile;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageMedia;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaVideo;
import org.telegram.telegrambots.meta.bots.AbsSender;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.updateshandlers.DownloadFileCallback;
import org.telegram.telegrambots.meta.updateshandlers.SentCallback;

public abstract class DefaultAbsSender
extends AbsSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultAbsSender.class);
    private static final ContentType TEXT_PLAIN_CONTENT_TYPE = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
    protected final ExecutorService exe;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DefaultBotOptions options;
    private final CloseableHttpClient httpClient;
    private final RequestConfig requestConfig;
    private final TelegramFileDownloader telegramFileDownloader;

    protected DefaultAbsSender(DefaultBotOptions options) {
        this.exe = Executors.newFixedThreadPool(options.getMaxThreads());
        this.options = options;
        this.httpClient = TelegramHttpClientBuilder.build(options);
        this.telegramFileDownloader = new TelegramFileDownloader((HttpClient)this.httpClient, this::getBotToken);
        this.configureHttpContext();
        RequestConfig configFromOptions = options.getRequestConfig();
        this.requestConfig = configFromOptions != null ? configFromOptions : RequestConfig.copy((RequestConfig)RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
    }

    public abstract String getBotToken();

    public final DefaultBotOptions getOptions() {
        return this.options;
    }

    public String getBaseUrl() {
        return this.options.getBaseUrl() + this.getBotToken() + "/";
    }

    public final File downloadFile(String filePath) throws TelegramApiException {
        return this.telegramFileDownloader.downloadFile(filePath);
    }

    public final File downloadFile(org.telegram.telegrambots.meta.api.objects.File file) throws TelegramApiException {
        return this.telegramFileDownloader.downloadFile(file);
    }

    public final File downloadFile(org.telegram.telegrambots.meta.api.objects.File file, File outputFile) throws TelegramApiException {
        return this.telegramFileDownloader.downloadFile(file, outputFile);
    }

    public final File downloadFile(String filePath, File outputFile) throws TelegramApiException {
        return this.telegramFileDownloader.downloadFile(filePath, outputFile);
    }

    public final void downloadFileAsync(String filePath, DownloadFileCallback<String> callback) throws TelegramApiException {
        this.telegramFileDownloader.downloadFileAsync(filePath, callback);
    }

    public final void downloadFileAsync(org.telegram.telegrambots.meta.api.objects.File file, DownloadFileCallback<org.telegram.telegrambots.meta.api.objects.File> callback) throws TelegramApiException {
        this.telegramFileDownloader.downloadFileAsync(file, callback);
    }

    public final InputStream downloadFileAsStream(String filePath) throws TelegramApiException {
        return this.telegramFileDownloader.downloadFileAsStream(filePath);
    }

    public final InputStream downloadFileAsStream(org.telegram.telegrambots.meta.api.objects.File file) throws TelegramApiException {
        return this.telegramFileDownloader.downloadFileAsStream(file);
    }

    public final Message execute(SendDocument sendDocument) throws TelegramApiException {
        this.assertParamNotNull(sendDocument, "sendDocument");
        sendDocument.validate();
        try {
            String url = this.getBaseUrl() + "senddocument";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendDocument.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendDocument.getDocument(), "document", true);
            if (sendDocument.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendDocument.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendDocument.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendDocument.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getCaption() != null) {
                builder.addTextBody("caption", sendDocument.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                if (sendDocument.getParseMode() != null) {
                    builder.addTextBody("parse_mode", sendDocument.getParseMode(), TEXT_PLAIN_CONTENT_TYPE);
                }
            }
            if (sendDocument.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendDocument.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendDocument.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendDocument.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getDisableContentTypeDetection() != null) {
                builder.addTextBody("disable_content_type_detection", sendDocument.getDisableContentTypeDetection().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getCaptionEntities() != null) {
                builder.addTextBody("caption_entities", this.objectMapper.writeValueAsString((Object)sendDocument.getCaptionEntities()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getThumb() != null) {
                this.addInputFile(builder, sendDocument.getThumb(), "thumb", false);
                builder.addTextBody("thumb", sendDocument.getThumb().getAttachName(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendDocument.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send document", (Throwable)e);
        }
    }

    public final Message execute(SendPhoto sendPhoto) throws TelegramApiException {
        this.assertParamNotNull(sendPhoto, "sendPhoto");
        sendPhoto.validate();
        try {
            String url = this.getBaseUrl() + "sendphoto";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendPhoto.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendPhoto.getPhoto(), "photo", true);
            if (sendPhoto.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendPhoto.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendPhoto.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendPhoto.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getCaption() != null) {
                builder.addTextBody("caption", sendPhoto.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                if (sendPhoto.getParseMode() != null) {
                    builder.addTextBody("parse_mode", sendPhoto.getParseMode(), TEXT_PLAIN_CONTENT_TYPE);
                }
            }
            if (sendPhoto.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendPhoto.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendPhoto.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendPhoto.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getCaptionEntities() != null) {
                builder.addTextBody("caption_entities", this.objectMapper.writeValueAsString((Object)sendPhoto.getCaptionEntities()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendPhoto.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send photo", (Throwable)e);
        }
    }

    public final Message execute(SendVideo sendVideo) throws TelegramApiException {
        this.assertParamNotNull(sendVideo, "sendVideo");
        sendVideo.validate();
        try {
            String url = this.getBaseUrl() + "sendvideo";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendVideo.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendVideo.getVideo(), "video", true);
            if (sendVideo.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendVideo.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendVideo.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendVideo.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getCaption() != null) {
                builder.addTextBody("caption", sendVideo.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                if (sendVideo.getParseMode() != null) {
                    builder.addTextBody("parse_mode", sendVideo.getParseMode(), TEXT_PLAIN_CONTENT_TYPE);
                }
            }
            if (sendVideo.getSupportsStreaming() != null) {
                builder.addTextBody("supports_streaming", sendVideo.getSupportsStreaming().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getDuration() != null) {
                builder.addTextBody("duration", sendVideo.getDuration().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getWidth() != null) {
                builder.addTextBody("width", sendVideo.getWidth().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getHeight() != null) {
                builder.addTextBody("height", sendVideo.getHeight().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendVideo.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendVideo.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getThumb() != null) {
                this.addInputFile(builder, sendVideo.getThumb(), "thumb", false);
                builder.addTextBody("thumb", sendVideo.getThumb().getAttachName(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendVideo.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getCaptionEntities() != null) {
                builder.addTextBody("caption_entities", this.objectMapper.writeValueAsString((Object)sendVideo.getCaptionEntities()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendVideo.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send video", (Throwable)e);
        }
    }

    public final Message execute(SendVideoNote sendVideoNote) throws TelegramApiException {
        this.assertParamNotNull(sendVideoNote, "sendVideoNote");
        sendVideoNote.validate();
        try {
            String url = this.getBaseUrl() + "sendvideonote";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendVideoNote.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendVideoNote.getVideoNote(), "video_note", true);
            if (sendVideoNote.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendVideoNote.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendVideoNote.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendVideoNote.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getDuration() != null) {
                builder.addTextBody("duration", sendVideoNote.getDuration().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getLength() != null) {
                builder.addTextBody("length", sendVideoNote.getLength().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendVideoNote.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendVideoNote.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getThumb() != null) {
                this.addInputFile(builder, sendVideoNote.getThumb(), "thumb", false);
                builder.addTextBody("thumb", sendVideoNote.getThumb().getAttachName(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendVideoNote.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendVideoNote.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send video note", (Throwable)e);
        }
    }

    public final Message execute(SendSticker sendSticker) throws TelegramApiException {
        this.assertParamNotNull(sendSticker, "sendSticker");
        sendSticker.validate();
        try {
            String url = this.getBaseUrl() + "sendsticker";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendSticker.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendSticker.getSticker(), "sticker", true);
            if (sendSticker.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendSticker.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendSticker.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendSticker.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendSticker.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendSticker.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendSticker.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendSticker.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendSticker.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendSticker.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendSticker.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendSticker.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendSticker.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send sticker", (Throwable)e);
        }
    }

    public final Message execute(SendAudio sendAudio) throws TelegramApiException {
        this.assertParamNotNull(sendAudio, "sendAudio");
        sendAudio.validate();
        try {
            String url = this.getBaseUrl() + "sendaudio";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendAudio.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendAudio.getAudio(), "audio", true);
            if (sendAudio.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendAudio.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendAudio.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendAudio.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getPerformer() != null) {
                builder.addTextBody("performer", sendAudio.getPerformer(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getTitle() != null) {
                builder.addTextBody("title", sendAudio.getTitle(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getDuration() != null) {
                builder.addTextBody("duration", sendAudio.getDuration().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendAudio.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getCaption() != null) {
                builder.addTextBody("caption", sendAudio.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                if (sendAudio.getParseMode() != null) {
                    builder.addTextBody("parse_mode", sendAudio.getParseMode(), TEXT_PLAIN_CONTENT_TYPE);
                }
            }
            if (sendAudio.getThumb() != null) {
                this.addInputFile(builder, sendAudio.getThumb(), "thumb", false);
                builder.addTextBody("thumb", sendAudio.getThumb().getAttachName(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendAudio.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendAudio.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getCaptionEntities() != null) {
                builder.addTextBody("caption_entities", this.objectMapper.writeValueAsString((Object)sendAudio.getCaptionEntities()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendAudio.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send audio", (Throwable)e);
        }
    }

    public final Message execute(SendVoice sendVoice) throws TelegramApiException {
        this.assertParamNotNull(sendVoice, "sendVoice");
        sendVoice.validate();
        try {
            String url = this.getBaseUrl() + "sendvoice";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendVoice.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendVoice.getVoice(), "voice", true);
            if (sendVoice.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendVoice.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendVoice.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendVoice.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendVoice.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getDuration() != null) {
                builder.addTextBody("duration", sendVoice.getDuration().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getCaption() != null) {
                builder.addTextBody("caption", sendVoice.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                if (sendVoice.getParseMode() != null) {
                    builder.addTextBody("parse_mode", sendVoice.getParseMode(), TEXT_PLAIN_CONTENT_TYPE);
                }
            }
            if (sendVoice.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendVoice.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendVoice.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getCaptionEntities() != null) {
                builder.addTextBody("caption_entities", this.objectMapper.writeValueAsString((Object)sendVoice.getCaptionEntities()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendVoice.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send voice", (Throwable)e);
        }
    }

    public Boolean execute(SetChatPhoto setChatPhoto) throws TelegramApiException {
        this.assertParamNotNull(setChatPhoto, "setChatPhoto");
        setChatPhoto.validate();
        try {
            String url = this.getBaseUrl() + "setChatPhoto";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", setChatPhoto.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            if (setChatPhoto.getPhoto() != null) {
                InputFile photo = setChatPhoto.getPhoto();
                if (photo.getNewMediaFile() != null) {
                    builder.addBinaryBody("photo", photo.getNewMediaFile());
                } else if (photo.getNewMediaStream() != null) {
                    builder.addBinaryBody("photo", photo.getNewMediaStream(), ContentType.APPLICATION_OCTET_STREAM, photo.getMediaName());
                }
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return setChatPhoto.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to set chat photo", (Throwable)e);
        }
    }

    public List<Message> execute(SendMediaGroup sendMediaGroup) throws TelegramApiException {
        this.assertParamNotNull(sendMediaGroup, "sendMediaGroup");
        sendMediaGroup.validate();
        try {
            String url = this.getBaseUrl() + "sendMediaGroup";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendMediaGroup.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputData(builder, sendMediaGroup.getMedias(), "media");
            if (sendMediaGroup.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendMediaGroup.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendMediaGroup.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendMediaGroup.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendMediaGroup.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendMediaGroup.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendMediaGroup.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendMediaGroup.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendMediaGroup.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendMediaGroup.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendMediaGroup.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to set chat photo", (Throwable)e);
        }
    }

    public Boolean execute(AddStickerToSet addStickerToSet) throws TelegramApiException {
        this.assertParamNotNull(addStickerToSet, "addStickerToSet");
        addStickerToSet.validate();
        try {
            String url = this.getBaseUrl() + "addStickerToSet";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("user_id", addStickerToSet.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("name", addStickerToSet.getName(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("emojis", addStickerToSet.getEmojis(), TEXT_PLAIN_CONTENT_TYPE);
            if (addStickerToSet.getPngSticker() != null) {
                this.addInputFile(builder, addStickerToSet.getPngSticker(), "png_sticker", true);
            } else if (addStickerToSet.getTgsSticker() != null) {
                this.addInputFile(builder, addStickerToSet.getTgsSticker(), "tgs_sticker", true);
            } else {
                this.addInputFile(builder, addStickerToSet.getWebmSticker(), "webm_sticker", true);
            }
            if (addStickerToSet.getMaskPosition() != null) {
                builder.addTextBody("mask_position", this.objectMapper.writeValueAsString((Object)addStickerToSet.getMaskPosition()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return addStickerToSet.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to add sticker to set", (Throwable)e);
        }
    }

    public Boolean execute(SetStickerSetThumb setStickerSetThumb) throws TelegramApiException {
        this.assertParamNotNull(setStickerSetThumb, "setStickerSetThumb");
        setStickerSetThumb.validate();
        try {
            String url = this.getBaseUrl() + "setStickerSetThumb";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("user_id", setStickerSetThumb.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("name", setStickerSetThumb.getName(), TEXT_PLAIN_CONTENT_TYPE);
            if (setStickerSetThumb.getThumb() != null) {
                this.addInputFile(builder, setStickerSetThumb.getThumb(), "thumb", true);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return setStickerSetThumb.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to set sticker set thumb", (Throwable)e);
        }
    }

    public Boolean execute(CreateNewStickerSet createNewStickerSet) throws TelegramApiException {
        this.assertParamNotNull(createNewStickerSet, "createNewStickerSet");
        createNewStickerSet.validate();
        try {
            String url = this.getBaseUrl() + "createNewStickerSet";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("user_id", createNewStickerSet.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("name", createNewStickerSet.getName(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("title", createNewStickerSet.getTitle(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("emojis", createNewStickerSet.getEmojis(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("sticker_type", createNewStickerSet.getStickerType(), TEXT_PLAIN_CONTENT_TYPE);
            if (createNewStickerSet.getPngSticker() != null) {
                this.addInputFile(builder, createNewStickerSet.getPngSticker(), "png_sticker", true);
            } else if (createNewStickerSet.getTgsSticker() != null) {
                this.addInputFile(builder, createNewStickerSet.getTgsSticker(), "tgs_sticker", true);
            } else {
                this.addInputFile(builder, createNewStickerSet.getWebmSticker(), "webm_sticker", true);
            }
            if (createNewStickerSet.getMaskPosition() != null) {
                builder.addTextBody("mask_position", this.objectMapper.writeValueAsString((Object)createNewStickerSet.getMaskPosition()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return createNewStickerSet.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to create new sticker set", (Throwable)e);
        }
    }

    public org.telegram.telegrambots.meta.api.objects.File execute(UploadStickerFile uploadStickerFile) throws TelegramApiException {
        this.assertParamNotNull(uploadStickerFile, "uploadStickerFile");
        uploadStickerFile.validate();
        try {
            String url = this.getBaseUrl() + "uploadStickerFile";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("user_id", uploadStickerFile.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, uploadStickerFile.getPngSticker(), "png_sticker", true);
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return uploadStickerFile.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to upload new sticker file", (Throwable)e);
        }
    }

    public Serializable execute(EditMessageMedia editMessageMedia) throws TelegramApiException {
        this.assertParamNotNull(editMessageMedia, "editMessageMedia");
        editMessageMedia.validate();
        try {
            String url = this.getBaseUrl() + "editMessageMedia";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            if (editMessageMedia.getInlineMessageId() == null) {
                builder.addTextBody("chat_id", editMessageMedia.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
                builder.addTextBody("message_id", editMessageMedia.getMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            } else {
                builder.addTextBody("inline_message_id", editMessageMedia.getInlineMessageId(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (editMessageMedia.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)editMessageMedia.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            this.addInputData(builder, editMessageMedia.getMedia(), "media", true);
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return editMessageMedia.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to edit message media", (Throwable)e);
        }
    }

    public Message execute(SendAnimation sendAnimation) throws TelegramApiException {
        this.assertParamNotNull(sendAnimation, "sendAnimation");
        sendAnimation.validate();
        try {
            String url = this.getBaseUrl() + "sendAnimation";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addTextBody("chat_id", sendAnimation.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            this.addInputFile(builder, sendAnimation.getAnimation(), "animation", true);
            if (sendAnimation.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString((Object)sendAnimation.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendAnimation.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getMessageThreadId() != null) {
                builder.addTextBody("message_thread_id", sendAnimation.getMessageThreadId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendAnimation.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getDuration() != null) {
                builder.addTextBody("duration", sendAnimation.getDuration().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getWidth() != null) {
                builder.addTextBody("width", sendAnimation.getWidth().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getHeight() != null) {
                builder.addTextBody("height", sendAnimation.getHeight().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getThumb() != null) {
                this.addInputFile(builder, sendAnimation.getThumb(), "thumb", false);
                builder.addTextBody("thumb", sendAnimation.getThumb().getAttachName(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getCaption() != null) {
                builder.addTextBody("caption", sendAnimation.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                if (sendAnimation.getParseMode() != null) {
                    builder.addTextBody("parse_mode", sendAnimation.getParseMode(), TEXT_PLAIN_CONTENT_TYPE);
                }
            }
            if (sendAnimation.getAllowSendingWithoutReply() != null) {
                builder.addTextBody("allow_sending_without_reply", sendAnimation.getAllowSendingWithoutReply().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getProtectContent() != null) {
                builder.addTextBody("protect_content", sendAnimation.getProtectContent().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAnimation.getCaptionEntities() != null) {
                builder.addTextBody("caption_entities", this.objectMapper.writeValueAsString((Object)sendAnimation.getCaptionEntities()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendAnimation.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to edit message media", (Throwable)e);
        }
    }

    public CompletableFuture<Message> executeAsync(SendDocument sendDocument) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendDocument));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendPhoto sendPhoto) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendPhoto));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendVideo sendVideo) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendVideo));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendVideoNote sendVideoNote) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendVideoNote));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendSticker sendSticker) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendSticker));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendAudio sendAudio) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendAudio));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendVoice sendVoice) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendVoice));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<List<Message>> executeAsync(SendMediaGroup sendMediaGroup) {
        CompletableFuture<List<Message>> completableFuture = new CompletableFuture<List<Message>>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendMediaGroup));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> executeAsync(SetChatPhoto setChatPhoto) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(setChatPhoto));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> executeAsync(AddStickerToSet addStickerToSet) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(addStickerToSet));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> executeAsync(SetStickerSetThumb setStickerSetThumb) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(setStickerSetThumb));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> executeAsync(CreateNewStickerSet createNewStickerSet) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(createNewStickerSet));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<org.telegram.telegrambots.meta.api.objects.File> executeAsync(UploadStickerFile uploadStickerFile) {
        CompletableFuture<org.telegram.telegrambots.meta.api.objects.File> completableFuture = new CompletableFuture<org.telegram.telegrambots.meta.api.objects.File>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(uploadStickerFile));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Serializable> executeAsync(EditMessageMedia editMessageMedia) {
        CompletableFuture<Serializable> completableFuture = new CompletableFuture<Serializable>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(editMessageMedia));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Message> executeAsync(SendAnimation sendAnimation) {
        CompletableFuture<Message> completableFuture = new CompletableFuture<Message>();
        this.exe.submit(() -> {
            try {
                completableFuture.complete(this.execute(sendAnimation));
            }
            catch (TelegramApiException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    protected final <T extends Serializable, Method extends BotApiMethod<T>, Callback extends SentCallback<T>> void sendApiMethodAsync(final Method method, final Callback callback) {
        this.exe.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String responseContent = DefaultAbsSender.this.sendMethodRequest(method);
                    try {
                        callback.onResult(method, method.deserializeResponse(responseContent));
                    }
                    catch (TelegramApiRequestException e) {
                        callback.onError(method, e);
                    }
                }
                catch (IOException | TelegramApiValidationException e) {
                    callback.onException(method, (Exception)e);
                }
            }
        });
    }

    protected <T extends Serializable, Method extends BotApiMethod<T>> CompletableFuture<T> sendApiMethodAsync(Method method) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.exe.submit(() -> {
            try {
                String responseContent = this.sendMethodRequest(method);
                completableFuture.complete(method.deserializeResponse(responseContent));
            }
            catch (IOException | TelegramApiRequestException | TelegramApiValidationException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    protected final <T extends Serializable, Method extends BotApiMethod<T>> T sendApiMethod(Method method) throws TelegramApiException {
        try {
            String responseContent = this.sendMethodRequest(method);
            return (T)method.deserializeResponse(responseContent);
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to execute " + method.getMethod() + " method", (Throwable)e);
        }
    }

    private void configureHttpContext() {
        if (this.options.getProxyType() != DefaultBotOptions.ProxyType.NO_PROXY) {
            InetSocketAddress socksaddr = new InetSocketAddress(this.options.getProxyHost(), this.options.getProxyPort());
            this.options.getHttpContext().setAttribute("socketAddress", (Object)socksaddr);
        }
        if (this.options.getProxyType() == DefaultBotOptions.ProxyType.SOCKS4) {
            this.options.getHttpContext().setAttribute("socksVersion", (Object)4);
        }
        if (this.options.getProxyType() == DefaultBotOptions.ProxyType.SOCKS5) {
            this.options.getHttpContext().setAttribute("socksVersion", (Object)5);
        }
    }

    private <T extends Serializable, Method extends BotApiMethod<T>> String sendMethodRequest(Method method) throws TelegramApiValidationException, IOException {
        method.validate();
        String url = this.getBaseUrl() + method.getMethod();
        HttpPost httppost = this.configuredHttpPost(url);
        httppost.addHeader("charset", StandardCharsets.UTF_8.name());
        httppost.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString(method), ContentType.APPLICATION_JSON));
        return this.sendHttpPostRequest(httppost);
    }

    private String sendHttpPostRequest(HttpPost httppost) throws IOException {
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httppost, this.options.getHttpContext());){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private HttpPost configuredHttpPost(String url) {
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(this.requestConfig);
        return httppost;
    }

    private void addInputData(MultipartEntityBuilder builder, InputMedia media, String mediaField, boolean addField) throws JsonProcessingException {
        InputMediaAnimation animation;
        if (media.isNewMedia()) {
            if (media.getNewMediaFile() != null) {
                builder.addBinaryBody(media.getMediaName(), media.getNewMediaFile(), ContentType.APPLICATION_OCTET_STREAM, media.getMediaName());
            } else if (media.getNewMediaStream() != null) {
                builder.addBinaryBody(media.getMediaName(), media.getNewMediaStream(), ContentType.APPLICATION_OCTET_STREAM, media.getMediaName());
            }
        }
        if (media instanceof InputMediaAudio) {
            InputMediaAudio audio = (InputMediaAudio)media;
            if (audio.getThumb() != null) {
                this.addInputFile(builder, audio.getThumb(), "thumb", false);
            }
        } else if (media instanceof InputMediaDocument) {
            InputMediaDocument document = (InputMediaDocument)media;
            if (document.getThumb() != null) {
                this.addInputFile(builder, document.getThumb(), "thumb", false);
            }
        } else if (media instanceof InputMediaVideo) {
            InputMediaVideo video = (InputMediaVideo)media;
            if (video.getThumb() != null) {
                this.addInputFile(builder, video.getThumb(), "thumb", false);
            }
        } else if (media instanceof InputMediaAnimation && (animation = (InputMediaAnimation)media).getThumb() != null) {
            this.addInputFile(builder, animation.getThumb(), "thumb", false);
        }
        if (addField) {
            builder.addTextBody(mediaField, this.objectMapper.writeValueAsString((Object)media), TEXT_PLAIN_CONTENT_TYPE);
        }
    }

    private void addInputData(MultipartEntityBuilder builder, List<InputMedia> media, String mediaField) throws JsonProcessingException {
        for (InputMedia inputMedia : media) {
            this.addInputData(builder, inputMedia, null, false);
        }
        builder.addTextBody(mediaField, this.objectMapper.writeValueAsString(media), TEXT_PLAIN_CONTENT_TYPE);
    }

    private void addInputFile(MultipartEntityBuilder builder, InputFile file, String fileField, boolean addField) {
        if (file.isNew()) {
            if (file.getNewMediaFile() != null) {
                builder.addBinaryBody(file.getMediaName(), file.getNewMediaFile(), ContentType.APPLICATION_OCTET_STREAM, file.getMediaName());
            } else if (file.getNewMediaStream() != null) {
                builder.addBinaryBody(file.getMediaName(), file.getNewMediaStream(), ContentType.APPLICATION_OCTET_STREAM, file.getMediaName());
            }
        }
        if (addField) {
            builder.addTextBody(fileField, file.getAttachName(), TEXT_PLAIN_CONTENT_TYPE);
        }
    }

    private void assertParamNotNull(Object param, String paramName) throws TelegramApiException {
        if (param == null) {
            throw new TelegramApiException("Parameter " + paramName + " can not be null");
        }
    }
}

