/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.ChatLocation;
import org.telegram.telegrambots.meta.api.objects.ChatPermissions;
import org.telegram.telegrambots.meta.api.objects.ChatPhoto;
import org.telegram.telegrambots.meta.api.objects.Message;

public class Chat
implements BotApiObject {
    private static final String ID_FIELD = "id";
    private static final String TYPE_FIELD = "type";
    private static final String TITLE_FIELD = "title";
    private static final String USERNAME_FIELD = "username";
    private static final String FIRSTNAME_FIELD = "first_name";
    private static final String LASTNAME_FIELD = "last_name";
    private static final String BIO_FIELD = "bio";
    private static final String PHOTO_FIELD = "photo";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String INVITELINK_FIELD = "invite_link";
    private static final String PINNEDMESSAGE_FIELD = "pinned_message";
    private static final String STICKERSETNAME_FIELD = "sticker_set_name";
    private static final String CANSETSTICKERSET_FIELD = "can_set_sticker_set";
    private static final String PERMISSIONS_FIELD = "permissions";
    private static final String SLOWMODEDELAY_FIELD = "slow_mode_delay";
    private static final String LINKEDCHATID_FIELD = "linked_chat_id";
    private static final String LOCATION_FIELD = "location";
    private static final String MESSAGEAUTODELETETIME_FIELD = "message_auto_delete_time";
    private static final String HASPRIVATEFORWARDS_FIELD = "has_private_forwards";
    private static final String HASPROTECTEDCONTENT_FIELD = "has_protected_content";
    private static final String JOINTOSENDMESSAGES_FIELD = "join_to_send_messages";
    private static final String JOINBYREQUEST_FIELD = "join_by_request";
    private static final String HASRESTRICTEDVOICEANDVIDEOMESSAGES_FIELD = "has_restricted_voice_and_video_messages";
    private static final String ISFORUM_FIELD = "is_forum";
    private static final String ACTIVEUSERNAMES_FIELD = "active_usernames";
    private static final String EMOJISTATUSCUSTOMEMOJIID_FIELD = "emoji_status_custom_emoji_id";
    private static final String USERCHATTYPE = "private";
    private static final String GROUPCHATTYPE = "group";
    private static final String CHANNELCHATTYPE = "channel";
    private static final String SUPERGROUPCHATTYPE = "supergroup";
    @JsonProperty(value="id")
    @NonNull
    private Long id;
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="username")
    private String userName;
    @JsonProperty(value="photo")
    private ChatPhoto photo;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="invite_link")
    private String inviteLink;
    @JsonProperty(value="pinned_message")
    private Message pinnedMessage;
    @JsonProperty(value="sticker_set_name")
    private String stickerSetName;
    @JsonProperty(value="can_set_sticker_set")
    private Boolean canSetStickerSet;
    @JsonProperty(value="permissions")
    private ChatPermissions permissions;
    @JsonProperty(value="slow_mode_delay")
    private Integer slowModeDelay;
    @JsonProperty(value="bio")
    private String bio;
    @JsonProperty(value="linked_chat_id")
    private Long linkedChatId;
    @JsonProperty(value="location")
    private ChatLocation location;
    @JsonProperty(value="message_auto_delete_time")
    private Integer messageAutoDeleteTime;
    @JsonProperty(value="has_private_forwards")
    private Boolean hasPrivateForwards;
    @JsonProperty(value="has_protected_content")
    private Boolean HasProtectedContent;
    @JsonProperty(value="join_to_send_messages")
    private Boolean joinToSendMessages;
    @JsonProperty(value="join_by_request")
    private Boolean joinByRequest;
    @JsonProperty(value="has_restricted_voice_and_video_messages")
    private Boolean hasRestrictedVoiceAndVideoMessages;
    @JsonProperty(value="is_forum")
    private Boolean isForum;
    @JsonProperty(value="active_usernames")
    private List<String> activeUsernames;
    @JsonProperty(value="emoji_status_custom_emoji_id")
    private String emojiStatusCustomEmojiId;

    @JsonIgnore
    public Boolean isGroupChat() {
        return GROUPCHATTYPE.equals(this.type);
    }

    @JsonIgnore
    public Boolean isChannelChat() {
        return CHANNELCHATTYPE.equals(this.type);
    }

    @JsonIgnore
    public Boolean isUserChat() {
        return USERCHATTYPE.equals(this.type);
    }

    @JsonIgnore
    public Boolean isSuperGroupChat() {
        return SUPERGROUPCHATTYPE.equals(this.type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chat)) {
            return false;
        }
        Chat other = (Chat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$canSetStickerSet = this.getCanSetStickerSet();
        Boolean other$canSetStickerSet = other.getCanSetStickerSet();
        if (this$canSetStickerSet == null ? other$canSetStickerSet != null : !((Object)this$canSetStickerSet).equals(other$canSetStickerSet)) {
            return false;
        }
        Integer this$slowModeDelay = this.getSlowModeDelay();
        Integer other$slowModeDelay = other.getSlowModeDelay();
        if (this$slowModeDelay == null ? other$slowModeDelay != null : !((Object)this$slowModeDelay).equals(other$slowModeDelay)) {
            return false;
        }
        Long this$linkedChatId = this.getLinkedChatId();
        Long other$linkedChatId = other.getLinkedChatId();
        if (this$linkedChatId == null ? other$linkedChatId != null : !((Object)this$linkedChatId).equals(other$linkedChatId)) {
            return false;
        }
        Integer this$messageAutoDeleteTime = this.getMessageAutoDeleteTime();
        Integer other$messageAutoDeleteTime = other.getMessageAutoDeleteTime();
        if (this$messageAutoDeleteTime == null ? other$messageAutoDeleteTime != null : !((Object)this$messageAutoDeleteTime).equals(other$messageAutoDeleteTime)) {
            return false;
        }
        Boolean this$hasPrivateForwards = this.getHasPrivateForwards();
        Boolean other$hasPrivateForwards = other.getHasPrivateForwards();
        if (this$hasPrivateForwards == null ? other$hasPrivateForwards != null : !((Object)this$hasPrivateForwards).equals(other$hasPrivateForwards)) {
            return false;
        }
        Boolean this$HasProtectedContent = this.getHasProtectedContent();
        Boolean other$HasProtectedContent = other.getHasProtectedContent();
        if (this$HasProtectedContent == null ? other$HasProtectedContent != null : !((Object)this$HasProtectedContent).equals(other$HasProtectedContent)) {
            return false;
        }
        Boolean this$joinToSendMessages = this.getJoinToSendMessages();
        Boolean other$joinToSendMessages = other.getJoinToSendMessages();
        if (this$joinToSendMessages == null ? other$joinToSendMessages != null : !((Object)this$joinToSendMessages).equals(other$joinToSendMessages)) {
            return false;
        }
        Boolean this$joinByRequest = this.getJoinByRequest();
        Boolean other$joinByRequest = other.getJoinByRequest();
        if (this$joinByRequest == null ? other$joinByRequest != null : !((Object)this$joinByRequest).equals(other$joinByRequest)) {
            return false;
        }
        Boolean this$hasRestrictedVoiceAndVideoMessages = this.getHasRestrictedVoiceAndVideoMessages();
        Boolean other$hasRestrictedVoiceAndVideoMessages = other.getHasRestrictedVoiceAndVideoMessages();
        if (this$hasRestrictedVoiceAndVideoMessages == null ? other$hasRestrictedVoiceAndVideoMessages != null : !((Object)this$hasRestrictedVoiceAndVideoMessages).equals(other$hasRestrictedVoiceAndVideoMessages)) {
            return false;
        }
        Boolean this$isForum = this.getIsForum();
        Boolean other$isForum = other.getIsForum();
        if (this$isForum == null ? other$isForum != null : !((Object)this$isForum).equals(other$isForum)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        ChatPhoto this$photo = this.getPhoto();
        ChatPhoto other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$inviteLink = this.getInviteLink();
        String other$inviteLink = other.getInviteLink();
        if (this$inviteLink == null ? other$inviteLink != null : !this$inviteLink.equals(other$inviteLink)) {
            return false;
        }
        Message this$pinnedMessage = this.getPinnedMessage();
        Message other$pinnedMessage = other.getPinnedMessage();
        if (this$pinnedMessage == null ? other$pinnedMessage != null : !((Object)this$pinnedMessage).equals(other$pinnedMessage)) {
            return false;
        }
        String this$stickerSetName = this.getStickerSetName();
        String other$stickerSetName = other.getStickerSetName();
        if (this$stickerSetName == null ? other$stickerSetName != null : !this$stickerSetName.equals(other$stickerSetName)) {
            return false;
        }
        ChatPermissions this$permissions = this.getPermissions();
        ChatPermissions other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        String this$bio = this.getBio();
        String other$bio = other.getBio();
        if (this$bio == null ? other$bio != null : !this$bio.equals(other$bio)) {
            return false;
        }
        ChatLocation this$location = this.getLocation();
        ChatLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<String> this$activeUsernames = this.getActiveUsernames();
        List<String> other$activeUsernames = other.getActiveUsernames();
        if (this$activeUsernames == null ? other$activeUsernames != null : !((Object)this$activeUsernames).equals(other$activeUsernames)) {
            return false;
        }
        String this$emojiStatusCustomEmojiId = this.getEmojiStatusCustomEmojiId();
        String other$emojiStatusCustomEmojiId = other.getEmojiStatusCustomEmojiId();
        return !(this$emojiStatusCustomEmojiId == null ? other$emojiStatusCustomEmojiId != null : !this$emojiStatusCustomEmojiId.equals(other$emojiStatusCustomEmojiId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $canSetStickerSet = this.getCanSetStickerSet();
        result = result * 59 + ($canSetStickerSet == null ? 43 : ((Object)$canSetStickerSet).hashCode());
        Integer $slowModeDelay = this.getSlowModeDelay();
        result = result * 59 + ($slowModeDelay == null ? 43 : ((Object)$slowModeDelay).hashCode());
        Long $linkedChatId = this.getLinkedChatId();
        result = result * 59 + ($linkedChatId == null ? 43 : ((Object)$linkedChatId).hashCode());
        Integer $messageAutoDeleteTime = this.getMessageAutoDeleteTime();
        result = result * 59 + ($messageAutoDeleteTime == null ? 43 : ((Object)$messageAutoDeleteTime).hashCode());
        Boolean $hasPrivateForwards = this.getHasPrivateForwards();
        result = result * 59 + ($hasPrivateForwards == null ? 43 : ((Object)$hasPrivateForwards).hashCode());
        Boolean $HasProtectedContent = this.getHasProtectedContent();
        result = result * 59 + ($HasProtectedContent == null ? 43 : ((Object)$HasProtectedContent).hashCode());
        Boolean $joinToSendMessages = this.getJoinToSendMessages();
        result = result * 59 + ($joinToSendMessages == null ? 43 : ((Object)$joinToSendMessages).hashCode());
        Boolean $joinByRequest = this.getJoinByRequest();
        result = result * 59 + ($joinByRequest == null ? 43 : ((Object)$joinByRequest).hashCode());
        Boolean $hasRestrictedVoiceAndVideoMessages = this.getHasRestrictedVoiceAndVideoMessages();
        result = result * 59 + ($hasRestrictedVoiceAndVideoMessages == null ? 43 : ((Object)$hasRestrictedVoiceAndVideoMessages).hashCode());
        Boolean $isForum = this.getIsForum();
        result = result * 59 + ($isForum == null ? 43 : ((Object)$isForum).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        ChatPhoto $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $inviteLink = this.getInviteLink();
        result = result * 59 + ($inviteLink == null ? 43 : $inviteLink.hashCode());
        Message $pinnedMessage = this.getPinnedMessage();
        result = result * 59 + ($pinnedMessage == null ? 43 : ((Object)$pinnedMessage).hashCode());
        String $stickerSetName = this.getStickerSetName();
        result = result * 59 + ($stickerSetName == null ? 43 : $stickerSetName.hashCode());
        ChatPermissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        String $bio = this.getBio();
        result = result * 59 + ($bio == null ? 43 : $bio.hashCode());
        ChatLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<String> $activeUsernames = this.getActiveUsernames();
        result = result * 59 + ($activeUsernames == null ? 43 : ((Object)$activeUsernames).hashCode());
        String $emojiStatusCustomEmojiId = this.getEmojiStatusCustomEmojiId();
        result = result * 59 + ($emojiStatusCustomEmojiId == null ? 43 : $emojiStatusCustomEmojiId.hashCode());
        return result;
    }

    @NonNull
    public Long getId() {
        return this.id;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getUserName() {
        return this.userName;
    }

    public ChatPhoto getPhoto() {
        return this.photo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInviteLink() {
        return this.inviteLink;
    }

    public Message getPinnedMessage() {
        return this.pinnedMessage;
    }

    public String getStickerSetName() {
        return this.stickerSetName;
    }

    public Boolean getCanSetStickerSet() {
        return this.canSetStickerSet;
    }

    public ChatPermissions getPermissions() {
        return this.permissions;
    }

    public Integer getSlowModeDelay() {
        return this.slowModeDelay;
    }

    public String getBio() {
        return this.bio;
    }

    public Long getLinkedChatId() {
        return this.linkedChatId;
    }

    public ChatLocation getLocation() {
        return this.location;
    }

    public Integer getMessageAutoDeleteTime() {
        return this.messageAutoDeleteTime;
    }

    public Boolean getHasPrivateForwards() {
        return this.hasPrivateForwards;
    }

    public Boolean getHasProtectedContent() {
        return this.HasProtectedContent;
    }

    public Boolean getJoinToSendMessages() {
        return this.joinToSendMessages;
    }

    public Boolean getJoinByRequest() {
        return this.joinByRequest;
    }

    public Boolean getHasRestrictedVoiceAndVideoMessages() {
        return this.hasRestrictedVoiceAndVideoMessages;
    }

    public Boolean getIsForum() {
        return this.isForum;
    }

    public List<String> getActiveUsernames() {
        return this.activeUsernames;
    }

    public String getEmojiStatusCustomEmojiId() {
        return this.emojiStatusCustomEmojiId;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="first_name")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty(value="last_name")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="username")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty(value="photo")
    public void setPhoto(ChatPhoto photo) {
        this.photo = photo;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="invite_link")
    public void setInviteLink(String inviteLink) {
        this.inviteLink = inviteLink;
    }

    @JsonProperty(value="pinned_message")
    public void setPinnedMessage(Message pinnedMessage) {
        this.pinnedMessage = pinnedMessage;
    }

    @JsonProperty(value="sticker_set_name")
    public void setStickerSetName(String stickerSetName) {
        this.stickerSetName = stickerSetName;
    }

    @JsonProperty(value="can_set_sticker_set")
    public void setCanSetStickerSet(Boolean canSetStickerSet) {
        this.canSetStickerSet = canSetStickerSet;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(ChatPermissions permissions) {
        this.permissions = permissions;
    }

    @JsonProperty(value="slow_mode_delay")
    public void setSlowModeDelay(Integer slowModeDelay) {
        this.slowModeDelay = slowModeDelay;
    }

    @JsonProperty(value="bio")
    public void setBio(String bio) {
        this.bio = bio;
    }

    @JsonProperty(value="linked_chat_id")
    public void setLinkedChatId(Long linkedChatId) {
        this.linkedChatId = linkedChatId;
    }

    @JsonProperty(value="location")
    public void setLocation(ChatLocation location) {
        this.location = location;
    }

    @JsonProperty(value="message_auto_delete_time")
    public void setMessageAutoDeleteTime(Integer messageAutoDeleteTime) {
        this.messageAutoDeleteTime = messageAutoDeleteTime;
    }

    @JsonProperty(value="has_private_forwards")
    public void setHasPrivateForwards(Boolean hasPrivateForwards) {
        this.hasPrivateForwards = hasPrivateForwards;
    }

    @JsonProperty(value="has_protected_content")
    public void setHasProtectedContent(Boolean HasProtectedContent) {
        this.HasProtectedContent = HasProtectedContent;
    }

    @JsonProperty(value="join_to_send_messages")
    public void setJoinToSendMessages(Boolean joinToSendMessages) {
        this.joinToSendMessages = joinToSendMessages;
    }

    @JsonProperty(value="join_by_request")
    public void setJoinByRequest(Boolean joinByRequest) {
        this.joinByRequest = joinByRequest;
    }

    @JsonProperty(value="has_restricted_voice_and_video_messages")
    public void setHasRestrictedVoiceAndVideoMessages(Boolean hasRestrictedVoiceAndVideoMessages) {
        this.hasRestrictedVoiceAndVideoMessages = hasRestrictedVoiceAndVideoMessages;
    }

    @JsonProperty(value="is_forum")
    public void setIsForum(Boolean isForum) {
        this.isForum = isForum;
    }

    @JsonProperty(value="active_usernames")
    public void setActiveUsernames(List<String> activeUsernames) {
        this.activeUsernames = activeUsernames;
    }

    @JsonProperty(value="emoji_status_custom_emoji_id")
    public void setEmojiStatusCustomEmojiId(String emojiStatusCustomEmojiId) {
        this.emojiStatusCustomEmojiId = emojiStatusCustomEmojiId;
    }

    public String toString() {
        return "Chat(id=" + this.getId() + ", type=" + this.getType() + ", title=" + this.getTitle() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", userName=" + this.getUserName() + ", photo=" + this.getPhoto() + ", description=" + this.getDescription() + ", inviteLink=" + this.getInviteLink() + ", pinnedMessage=" + this.getPinnedMessage() + ", stickerSetName=" + this.getStickerSetName() + ", canSetStickerSet=" + this.getCanSetStickerSet() + ", permissions=" + this.getPermissions() + ", slowModeDelay=" + this.getSlowModeDelay() + ", bio=" + this.getBio() + ", linkedChatId=" + this.getLinkedChatId() + ", location=" + this.getLocation() + ", messageAutoDeleteTime=" + this.getMessageAutoDeleteTime() + ", hasPrivateForwards=" + this.getHasPrivateForwards() + ", HasProtectedContent=" + this.getHasProtectedContent() + ", joinToSendMessages=" + this.getJoinToSendMessages() + ", joinByRequest=" + this.getJoinByRequest() + ", hasRestrictedVoiceAndVideoMessages=" + this.getHasRestrictedVoiceAndVideoMessages() + ", isForum=" + this.getIsForum() + ", activeUsernames=" + this.getActiveUsernames() + ", emojiStatusCustomEmojiId=" + this.getEmojiStatusCustomEmojiId() + ")";
    }

    public Chat(@NonNull Long id, @NonNull String type) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
    }

    public Chat() {
    }

    public Chat(@NonNull Long id, @NonNull String type, String title, String firstName, String lastName, String userName, ChatPhoto photo, String description, String inviteLink, Message pinnedMessage, String stickerSetName, Boolean canSetStickerSet, ChatPermissions permissions, Integer slowModeDelay, String bio, Long linkedChatId, ChatLocation location, Integer messageAutoDeleteTime, Boolean hasPrivateForwards, Boolean HasProtectedContent, Boolean joinToSendMessages, Boolean joinByRequest, Boolean hasRestrictedVoiceAndVideoMessages, Boolean isForum, List<String> activeUsernames, String emojiStatusCustomEmojiId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
        this.title = title;
        this.firstName = firstName;
        this.lastName = lastName;
        this.userName = userName;
        this.photo = photo;
        this.description = description;
        this.inviteLink = inviteLink;
        this.pinnedMessage = pinnedMessage;
        this.stickerSetName = stickerSetName;
        this.canSetStickerSet = canSetStickerSet;
        this.permissions = permissions;
        this.slowModeDelay = slowModeDelay;
        this.bio = bio;
        this.linkedChatId = linkedChatId;
        this.location = location;
        this.messageAutoDeleteTime = messageAutoDeleteTime;
        this.hasPrivateForwards = hasPrivateForwards;
        this.HasProtectedContent = HasProtectedContent;
        this.joinToSendMessages = joinToSendMessages;
        this.joinByRequest = joinByRequest;
        this.hasRestrictedVoiceAndVideoMessages = hasRestrictedVoiceAndVideoMessages;
        this.isForum = isForum;
        this.activeUsernames = activeUsernames;
        this.emojiStatusCustomEmojiId = emojiStatusCustomEmojiId;
    }
}

