/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendDocument
extends PartialBotApiMethod<Message> {
    public static final String PATH = "senddocument";
    public static final String CHATID_FIELD = "chat_id";
    public static final String MESSAGETHREADID_FIELD = "message_thread_id";
    public static final String DOCUMENT_FIELD = "document";
    public static final String CAPTION_FIELD = "caption";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PARSEMODE_FIELD = "parse_mode";
    public static final String THUMB_FIELD = "thumb";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    public static final String DISABLECONTENTTYPEDETECTION_FIELD = "disable_content_type_detection";
    public static final String PROTECTCONTENT_FIELD = "protect_content";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    @NonNull
    private InputFile document;
    private String caption;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private InputFile thumb;
    private List<MessageEntity> captionEntities;
    private Boolean allowSendingWithoutReply;
    private Boolean disableContentTypeDetection;
    private Boolean protectContent;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        this.document.validate();
        if (this.thumb != null) {
            this.thumb.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static SendDocumentBuilder builder() {
        return new SendDocumentBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendDocument)) {
            return false;
        }
        SendDocument other = (SendDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$disableContentTypeDetection = this.getDisableContentTypeDetection();
        Boolean other$disableContentTypeDetection = other.getDisableContentTypeDetection();
        if (this$disableContentTypeDetection == null ? other$disableContentTypeDetection != null : !((Object)this$disableContentTypeDetection).equals(other$disableContentTypeDetection)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$document = this.getDocument();
        InputFile other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InputFile this$thumb = this.getThumb();
        InputFile other$thumb = other.getThumb();
        if (this$thumb == null ? other$thumb != null : !((Object)this$thumb).equals(other$thumb)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $disableContentTypeDetection = this.getDisableContentTypeDetection();
        result = result * 59 + ($disableContentTypeDetection == null ? 43 : ((Object)$disableContentTypeDetection).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InputFile $thumb = this.getThumb();
        result = result * 59 + ($thumb == null ? 43 : ((Object)$thumb).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public InputFile getDocument() {
        return this.document;
    }

    public String getCaption() {
        return this.caption;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public Boolean getDisableContentTypeDetection() {
        return this.disableContentTypeDetection;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    public void setDocument(@NonNull InputFile document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.document = document;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setThumb(InputFile thumb) {
        this.thumb = thumb;
    }

    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public void setDisableContentTypeDetection(Boolean disableContentTypeDetection) {
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public String toString() {
        return "SendDocument(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", document=" + this.getDocument() + ", caption=" + this.getCaption() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", thumb=" + this.getThumb() + ", captionEntities=" + this.getCaptionEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", disableContentTypeDetection=" + this.getDisableContentTypeDetection() + ", protectContent=" + this.getProtectContent() + ")";
    }

    public SendDocument(@NonNull String chatId, @NonNull InputFile document) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.chatId = chatId;
        this.document = document;
    }

    public SendDocument() {
    }

    public SendDocument(@NonNull String chatId, Integer messageThreadId, @NonNull InputFile document, String caption, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, String parseMode, InputFile thumb, List<MessageEntity> captionEntities, Boolean allowSendingWithoutReply, Boolean disableContentTypeDetection, Boolean protectContent) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.document = document;
        this.caption = caption;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.thumb = thumb;
        this.captionEntities = captionEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.disableContentTypeDetection = disableContentTypeDetection;
        this.protectContent = protectContent;
    }

    public static class SendDocumentBuilder {
        private String chatId;
        private Integer messageThreadId;
        private InputFile document;
        private String caption;
        private Boolean disableNotification;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private String parseMode;
        private InputFile thumb;
        private ArrayList<MessageEntity> captionEntities;
        private Boolean allowSendingWithoutReply;
        private Boolean disableContentTypeDetection;
        private Boolean protectContent;

        public SendDocumentBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        SendDocumentBuilder() {
        }

        public SendDocumentBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        public SendDocumentBuilder messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this;
        }

        public SendDocumentBuilder document(@NonNull InputFile document) {
            if (document == null) {
                throw new NullPointerException("document is marked non-null but is null");
            }
            this.document = document;
            return this;
        }

        public SendDocumentBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendDocumentBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendDocumentBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        public SendDocumentBuilder replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendDocumentBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public SendDocumentBuilder thumb(InputFile thumb) {
            this.thumb = thumb;
            return this;
        }

        public SendDocumentBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        public SendDocumentBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public SendDocumentBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public SendDocumentBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        public SendDocumentBuilder disableContentTypeDetection(Boolean disableContentTypeDetection) {
            this.disableContentTypeDetection = disableContentTypeDetection;
            return this;
        }

        public SendDocumentBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        public SendDocument build() {
            List<MessageEntity> captionEntities;
            switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0: {
                    captionEntities = Collections.emptyList();
                    break;
                }
                case 1: {
                    captionEntities = Collections.singletonList(this.captionEntities.get(0));
                    break;
                }
                default: {
                    captionEntities = Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
                }
            }
            return new SendDocument(this.chatId, this.messageThreadId, this.document, this.caption, this.disableNotification, this.replyToMessageId, this.replyMarkup, this.parseMode, this.thumb, captionEntities, this.allowSendingWithoutReply, this.disableContentTypeDetection, this.protectContent);
        }

        public String toString() {
            return "SendDocument.SendDocumentBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", document=" + this.document + ", caption=" + this.caption + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", thumb=" + this.thumb + ", captionEntities=" + this.captionEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", disableContentTypeDetection=" + this.disableContentTypeDetection + ", protectContent=" + this.protectContent + ")";
        }
    }
}

