/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.slack.dao;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.file.tmp.FileInfo;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class SlackProto {
    private static final Log log = Log.getLog();
    private static final String API_URL = "https://slack.com/api/";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String tokenHeader;

    public SlackProto(String token) {
        this.tokenHeader = "Bearer " + token;
    }

    public String channelCreate(String name, boolean isPrivate) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.create");
        url.addParameter("name", name);
        url.addParameter("is_private", String.valueOf(isPrivate));
        return this.sendRequest(url).get("channel").get("id").asText();
    }

    public void channelSetTopic(String channel, String topic) throws Exception {
        if (((String)topic).length() > 248) {
            topic = ((String)topic).substring(0, 248) + "..";
        }
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.setTopic");
        url.addParameter("channel", channel);
        url.addParameter("topic", (String)topic);
        this.sendRequest(url);
    }

    public void channelSetPurpose(String channel, String purpose) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.setPurpose");
        url.addParameter("channel", channel);
        url.addParameter("purpose", purpose);
        this.sendRequest(url);
    }

    public void channelArchive(String channel) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.archive");
        url.addParameter("channel", channel);
        this.sendRequest(url);
    }

    public void channelUnArchive(String channel) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.unarchive");
        url.addParameter("channel", channel);
        this.sendRequest(url);
    }

    public void channelInviteUsers(String channel, List<String> users) throws Exception {
        for (String user : users) {
            URIBuilder url = new URIBuilder("https://slack.com/api/conversations.invite");
            url.addParameter("channel", channel);
            url.addParameter("user", user);
            this.sendRequest(url);
        }
    }

    public JsonNode userList() throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/users.list");
        return this.sendRequest(url);
    }

    public JsonNode chatPostMessage(String channel, String text, String username, Map<Integer, FileInfo> attachments) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/chat.postMessage");
        url.addParameter("channel", channel);
        url.addParameter("text", text);
        if (Utils.notBlankString(username)) {
            url.addParameter("as_user", "false");
            url.addParameter("username", username);
        }
        if (attachments != null) {
            // empty if block
        }
        return this.sendRequest(url);
    }

    public JsonNode channelList(boolean excludeArchived) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.list");
        url.addParameter("exclude_archived", String.valueOf(excludeArchived));
        return this.sendRequest(url).get("channels");
    }

    public JsonNode channelHistory(String channel, String oldest) throws Exception {
        URIBuilder url = new URIBuilder("https://slack.com/api/conversations.history");
        url.addParameter("channel", channel);
        if (oldest != null) {
            url.addParameter("oldest", oldest);
        }
        return this.sendRequest(url);
    }

    private JsonNode sendRequest(URIBuilder url) throws Exception {
        Request req = Request.Post((URI)url.build()).setHeader("Authorization", this.tokenHeader).setHeader("Content-Type", "application/x-www-form-urlencoded").connectTimeout(10000).socketTimeout(10000);
        log.debug("Sending: {}", req);
        String result = req.execute().returnContent().asString(Charset.forName("UTF-8"));
        log.debug("Response: {}", result);
        JsonNode node = MAPPER.readTree(result);
        if (node.get("ok") == null || !node.get("ok").asBoolean()) {
            throw new BGException("Incorrect Slack response: " + String.valueOf(node.get("error")), new Object[0]);
        }
        return node;
    }
}

