/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.dispatch.exec;

import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exec.scheduler.Task;
import org.bgerp.util.Log;
import org.bgerp.util.mail.MailMsg;
import ru.bgcrm.plugin.dispatch.Plugin;
import ru.bgcrm.plugin.dispatch.dao.DispatchDAO;
import ru.bgcrm.plugin.dispatch.exec.Config;
import ru.bgcrm.plugin.dispatch.model.DispatchMessage;
import ru.bgcrm.util.sql.SQLUtils;

@Bean(oldClasses={"ru.bgcrm.plugin.dispatch.MessageSender"})
public class DispatchMessageSender
extends Task {
    private static final Log log = Log.getLog();

    public DispatchMessageSender(ConfigMap config) {
        super(null);
    }

    @Override
    public String getTitle() {
        return Plugin.INSTANCE.getLocalizer().l("Dispatch Message Sender", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Setup setup = Setup.getSetup();
            Config config = setup.getConfig(Config.class);
            if (!config.getMailConfig().check()) {
                log.error("Mail config is not configured!", new Object[0]);
                return;
            }
            List<Object> messageList = Collections.emptyList();
            Connection conSlave = setup.getConnectionPool().getDBSlaveConnectionFromPool();
            try {
                messageList = new DispatchDAO(conSlave).messageUnsentList();
            }
            finally {
                SQLUtils.closeConnection(conSlave);
            }
            for (DispatchMessage dispatchMessage : messageList) {
                List<Object> accountList = Collections.emptyList();
                conSlave = setup.getConnectionPool().getDBSlaveConnectionFromPool();
                try {
                    accountList = new DispatchDAO(conSlave).messageAccountList(dispatchMessage.getId());
                }
                finally {
                    SQLUtils.closeConnection(conSlave);
                }
                log.debug("Found message to send: {}; accounts count: {}", dispatchMessage, accountList.size());
                String encoding = MailMsg.getParamMailEncoding(Setup.getSetup());
                Session session = config.getMailConfig().getSmtpSession(Setup.getSetup());
                try (Transport transport = null;){
                    transport = session.getTransport();
                    transport.connect();
                    MimeMessage msg = new MimeMessage(session);
                    msg.setFrom((Address)new InternetAddress(config.getMailConfig().getFrom()));
                    msg.setSubject(dispatchMessage.getTitle(), encoding);
                    msg.setText(dispatchMessage.getText(), encoding);
                    for (String string : accountList) {
                        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string));
                        transport.sendMessage((Message)msg, msg.getAllRecipients());
                    }
                }
                dispatchMessage.setSentTime(new Date());
                Connection con = setup.getDBConnectionFromPool();
                try {
                    new DispatchDAO(con).messageUpdate(dispatchMessage);
                    con.commit();
                }
                finally {
                    SQLUtils.closeConnection(con);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}

