/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractNote;
import ru.bgcrm.plugin.bgbilling.proto.model.UserInfo;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ContractNoteDAO
extends ContractDAO {
    public ContractNoteDAO(User user, String billingId) {
        super(user, billingId);
    }

    public List<ContractNote> list(int contractId) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractNoteService", "contractNoteList");
            req.setParamContractId(contractId);
            req.setParam("customer", false);
            JsonNode res = this.transferData.postDataReturn(req, this.user);
            List result = (List)this.readJsonValue(res.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractNote.class));
            if (!result.isEmpty()) {
                Map<Integer, UserInfo> userMap = new DirectoryDAO(this.user, this.dbInfo).getUsersInfo();
                for (ContractNote note : result) {
                    UserInfo user = userMap.get(note.getUserId());
                    if (user == null) continue;
                    note.setUser(user.getName());
                }
            }
            return result;
        }
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractMemo");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        ArrayList<ContractNote> result = new ArrayList<ContractNote>();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            ContractNote memo = new ContractNote();
            memo.setId(Utils.parseInt(rowElement.getAttribute("f0")));
            memo.setTitle(rowElement.getAttribute("f1"));
            memo.setDateTime(TimeUtils.parse(rowElement.getAttribute("f3"), "dd.MM.yyyy HH:mm:ss"));
            memo.setComment(this.get(contractId, memo.getId()).getComment());
            result.add(memo);
        }
        return result;
    }

    public ContractNote get(int contractId, int id) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractNoteService", "contractNoteGet");
            req.setParam("contractId", contractId);
            req.setParam("id", id);
            JsonNode res = this.transferData.postDataReturn(req, this.user);
            return (ContractNote)this.jsonMapper.convertValue((Object)res, ContractNote.class);
        }
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractNoteService", "getContractNote");
            req.setParam("contractNoteId", id);
            JsonNode res = this.transferData.postDataReturn(req, this.user);
            return (ContractNote)this.jsonMapper.convertValue((Object)res, ContractNote.class);
        }
        ContractNote result = null;
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetContractMemo");
        request.setContractId(contractId);
        request.setAttribute("id", id);
        Document doc = this.transferData.postData(request, this.user);
        Element commentEl = XMLUtils.selectElement(doc, "/data/comment");
        if (commentEl != null) {
            result = new ContractNote();
            result.setTitle(commentEl.getAttribute("subject"));
            result.setComment(this.linesToString(commentEl));
            result.setVisible(Utils.parseBoolean(commentEl.getAttribute("visibled")));
        }
        return result;
    }

    public void update(int contractId, int id, String title, String text) {
        this.update(contractId, id, title, text, false);
    }

    public void update(int contractId, int id, String title, String text, boolean visible) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractNoteService", "contractNoteUpdate");
            req.setParamContractId(contractId);
            ContractNote note = new ContractNote();
            note.setId(id);
            note.setContractId(contractId);
            note.setTitle(title);
            note.setComment(text);
            note.setVisible(visible);
            note.setDateTime(new Date());
            note.setUserId(this.dbInfo.getBillingUserId(this.user));
            req.setParam("contractNote", note);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("UpdateContractMemo");
            request.setContractId(contractId);
            request.setAttribute("subject", title);
            request.setAttribute("comment", text);
            request.setAttribute("visibled", visible);
            if (id == 0) {
                request.setAttribute("id", "new");
            } else {
                request.setAttribute("id", id);
            }
            this.transferData.postData(request, this.user);
        }
    }

    public void delete(int contractId, int id) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractNoteService", "contractNoteDelete");
            req.setParamContractId(contractId);
            req.setParam("id", id);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("DeleteContractMemo");
            request.setContractId(contractId);
            request.setAttribute("id", id);
            this.transferData.postData(request, this.user);
        }
    }
}

