/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.message;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.message.MessageSearchDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.ProcessLinkSearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.file.FileData;
import org.bgerp.model.file.tmp.FileInfo;
import org.bgerp.model.file.tmp.SessionTemporaryFiles;
import org.bgerp.model.msg.Message;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.dao.process.StatusChangeDAO;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.proto.dao.HelpDeskDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdMessage;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdTopic;
import ru.bgcrm.struts.action.LinkAction;
import ru.bgcrm.struts.action.ProcessAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SingleConnectionSet;

@Bean
public class MessageTypeHelpDesk
extends MessageType {
    private static final Log log = Log.getLog();
    private final String billingId;
    private final int topicId;
    private final User user;
    private final int processTypeId;
    private final int costParamId;
    private final int statusParamId;
    private final int autoCloseParamId;
    private final int closeStatusId;
    private final int openStatusId;
    private final boolean addFirstMessageInDescription;
    private final boolean newMessageEvent;
    private final Set<Integer> markMessagesReadStatusIds;
    private final int pageSize;

    public MessageTypeHelpDesk(Setup setup, int id, ConfigMap config) {
        super(setup, id, config.get("title"), config);
        this.billingId = config.get("billingId");
        this.topicId = config.getInt("topicId");
        String userName = config.get("user", "");
        String userPassword = config.get("pswd", "");
        if (Utils.isBlankString(userName) || Utils.isBlankString(userPassword)) {
            throw new BGException("Billing user or password undefined.", new Object[0]);
        }
        this.user = new User();
        this.user.setLogin(userName);
        this.user.setPassword(userPassword);
        this.processTypeId = config.getInt("processTypeId", 0);
        if (this.processTypeId <= 0) {
            throw new BGException("processTypeId not defined", new Object[0]);
        }
        this.costParamId = config.getInt("costParamId", 0);
        this.statusParamId = config.getInt("statusParamId", 0);
        this.closeStatusId = config.getInt("closeStatusId", 0);
        this.openStatusId = config.getInt("openStatusId", 0);
        this.autoCloseParamId = config.getInt("autoCloseParamId", 0);
        this.pageSize = config.getInt("pageSize", 100000);
        this.newMessageEvent = config.getBoolean("newMessageEvent", false);
        this.markMessagesReadStatusIds = Utils.toIntegerSet(config.get("markMessagesReadStatusIds", ""));
        this.addFirstMessageInDescription = config.getBoolean("addFirstMessageInDescription", false);
    }

    @Override
    public String getHeaderJsp() {
        return "/WEB-INF/jspf/user/plugin/bgbilling/helpdesk/process_message_header.jsp";
    }

    public User getUser() {
        return this.user;
    }

    public String getBillingId() {
        return this.billingId;
    }

    public int getProcessTypeId() {
        return this.processTypeId;
    }

    public int getCostParamId() {
        return this.costParamId;
    }

    public int getStatusParamId() {
        return this.statusParamId;
    }

    public int getCloseStatusId() {
        return this.closeStatusId;
    }

    public int getAutoCloseParamId() {
        return this.autoCloseParamId;
    }

    public Set<Integer> getMarkMessagesReadStatusIds() {
        return this.markMessagesReadStatusIds;
    }

    public DBInfo getDbInfo() {
        return DBInfoManager.getDbInfo(this.billingId);
    }

    public String getObjectType() {
        return "bgbilling-helpdesk:" + this.billingId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process() {
        block21: {
            Iterator<Pair<HdTopic, List<HdMessage>>> iterator;
            HelpDeskDAO hdDao;
            ProcessDAO processDao;
            ProcessType processType;
            Connection con;
            log.info("Starting {}", MessageTypeHelpDesk.class);
            try {
                block18: {
                    block19: {
                        con = Setup.getSetup().getDBConnectionFromPool();
                        processType = ProcessTypeCache.getProcessType(this.processTypeId);
                        if (processType != null) break block18;
                        log.error("Not found process type with id: {}", this.processTypeId);
                        if (con == null) break block19;
                        con.close();
                    }
                    log.info("Finished {}", MessageTypeHelpDesk.class);
                    return;
                }
                DBInfo dbInfo = this.getDbInfo();
                processDao = new ProcessDAO(con);
                String objectType = this.getObjectType();
                TreeMap<Integer, Integer> openHdProcessTopicIds = new TreeMap<Integer, Integer>();
                String query = "SELECT p.id, pl.object_id FROM  process  AS p INNER JOIN  process_link  AS pl ON p.id=pl.process_id AND pl.object_type=? WHERE p.close_dt IS NULL ";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setString(1, objectType);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    openHdProcessTopicIds.put(rs.getInt(1), rs.getInt(2));
                }
                ps.close();
                DynActionForm form = new DynActionForm(this.user);
                hdDao = new HelpDeskDAO(this.user, dbInfo);
                Pageable<Pair<HdTopic, List<HdMessage>>> result = new Pageable<Pair<HdTopic, List<HdMessage>>>();
                result.getPage().setPageIndex(1);
                result.getPage().setPageSize(this.pageSize);
                log.info("topicId: {}", this.topicId);
                hdDao.searchTopicsWithMessages(result, this.topicId);
                for (Pair<HdTopic, List<HdMessage>> pair : result.getList()) {
                    HdTopic topic = pair.getFirst();
                    Process process = this.processTopic(con, openHdProcessTopicIds, processType, objectType, form, hdDao, topic);
                    this.updateProcessFromTopic(con, processType, process, topic, pair.getSecond());
                    con.commit();
                }
                iterator = openHdProcessTopicIds.keySet().iterator();
            }
            catch (Exception e) {
                try {
                    log.error(e);
                }
                catch (Throwable throwable) {
                    log.info("Finished {}", MessageTypeHelpDesk.class);
                    throw throwable;
                }
                log.info("Finished {}", MessageTypeHelpDesk.class);
                return;
            }
            while (iterator.hasNext()) {
                HdTopic topic;
                Integer processId = (Integer)((Object)iterator.next());
                log.info("Closing process: {}", processId);
                Process process = processDao.getProcess(processId);
                CommonObjectLink topicLink = Utils.getFirst(new ProcessLinkDAO(con).getObjectLinksWithType(processId, this.getObjectType()));
                if (topicLink == null) {
                    log.error("Not linked topic to process: {}", processId);
                    continue;
                }
                int topicId = topicLink.getLinkObjectId();
                Pair<HdTopic, List<HdMessage>> topicWithMessages = hdDao.getTopicWithMessages(topicId);
                HdTopic hdTopic = topic = topicWithMessages != null ? topicWithMessages.getFirst() : null;
                if (topic == null) {
                    log.warn("Topic not found: {}", topicId);
                } else {
                    this.updateProcessFromTopic(con, processType, process, topic, null);
                }
                StatusChange status = new StatusChange();
                status.setDate(new Date());
                status.setComment("\u0417\u0430\u043a\u0440\u044b\u0442\u043e \u0432\u0441\u043b\u0435\u0434 \u0437\u0430 \u0442\u0435\u043c\u043e\u0439 \u0432 HelpDesk.");
                status.setProcessId(processId);
                status.setStatusId(this.closeStatusId);
                new StatusChangeDAO(con).changeStatus(process, processType, status);
                con.commit();
            }
            break block21;
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        log.info("Finished {}", MessageTypeHelpDesk.class);
    }

    private Process processTopic(Connection con, Map<Integer, Integer> activeHdProcessTopicIds, ProcessType processType, String objectType, DynActionForm form, HelpDeskDAO hdDao, HdTopic topic) throws Exception {
        log.debug("Processing topic: {}", topic.getId());
        Pageable<Process> searchResult = new Pageable<Process>();
        new ProcessLinkSearchDAO(con, form).withLinkObjectType(objectType).withLinkObjectId(topic.getId()).search(searchResult);
        Process process = Utils.getFirst(searchResult.getList());
        if (process == null) {
            log.info("Creating process for topic: {}/{}", this.billingId, topic.getId());
            Object description = topic.getTitle();
            if (Utils.notBlankString(topic.getContact())) {
                description = (String)description + "\n\u041a\u043e\u043d\u0442\u0430\u043a\u0442: " + topic.getContact();
            }
            process = new Process();
            process.setDescription((String)description);
            process.setTypeId(this.processTypeId);
            ProcessAction.processCreate(form, con, process);
            LinkAction.addLink(form, con, new CommonObjectLink("process", process.getId(), objectType, topic.getId(), ""));
            LinkAction.addLink(form, con, new CommonObjectLink("process", process.getId(), "contract:" + this.billingId, topic.getContractId(), topic.getContractTitle()));
        } else {
            activeHdProcessTopicIds.remove(process.getId());
            if (process.getCloseTime() != null) {
                Pair<HdTopic, List<HdMessage>> pair = hdDao.getTopicWithMessages(topic.getId());
                if (pair != null && !pair.getFirst().isClosed()) {
                    log.info("Opening process: {} for topic: {}", process.getId(), topic.getId());
                    StatusChange status = new StatusChange();
                    status.setDate(new Date());
                    status.setComment("\u041e\u0442\u043a\u0440\u044b\u0442\u043e \u0432\u0441\u043b\u0435\u0434 \u0437\u0430 \u0442\u0435\u043c\u043e\u0439 \u0432 HelpDesk.");
                    status.setProcessId(process.getId());
                    status.setStatusId(this.openStatusId);
                    new StatusChangeDAO(con).changeStatus(process, processType, status);
                    con.commit();
                } else {
                    log.info("Topic is already closed or not found: {}", topic.getId());
                }
            }
        }
        return process;
    }

    private HdTopic updateProcessFromTopic(Connection con, ProcessType processType, Process process, HdTopic topic, List<HdMessage> hdMessages) throws Exception {
        Pair<HdTopic, List<HdMessage>> pair;
        DBInfo dbInfo = this.getDbInfo();
        ProcessDAO processDao = new ProcessDAO(con);
        MessageDAO messageDao = new MessageDAO(con);
        ParamValueDAO paramDao = new ParamValueDAO(con);
        HelpDeskDAO hdDao = new HelpDeskDAO(this.user, dbInfo);
        HashMap<Integer, Message> messageMap = new HashMap<Integer, Message>();
        Pageable<Message> messages = new Pageable<Message>();
        new MessageSearchDAO(con).withProcessIds(Set.of(process.getId())).withTypeId(this.id).search(messages);
        for (Message message : messages.getList()) {
            messageMap.put(Utils.parseInt(message.getSystemId()), message);
        }
        if (hdMessages == null && (pair = hdDao.getTopicWithMessages(topic.getId())) != null) {
            topic = pair.getFirst();
            hdMessages = pair.getSecond();
        }
        if (topic.getUserId() > 0) {
            int crmUserId = dbInfo.getCrmUserId(topic.getUserId());
            if (crmUserId > 0) {
                ProcessGroup group = process.getGroups().stream().filter(pg -> pg.getGroupId() == 0).findFirst().orElse(null);
                if (group == null) {
                    log.warn("Not found process group with role=0 for process: {}", process.getId());
                } else {
                    Set<ProcessExecutor> executors = process.getExecutors();
                    executors.add(new ProcessExecutor(crmUserId, group.getGroupId(), group.getRoleId()));
                    processDao.updateProcessExecutors(executors, process.getId());
                }
            }
        } else {
            processDao.updateProcessExecutors(Set.of(), process.getId());
        }
        if (topic.getStatusId() > 0) {
            paramDao.updateParamList((int)process.getId(), this.statusParamId, Collections.singleton(topic.getStatusId()));
        }
        Set<Integer> on = Collections.singleton(1);
        Set empty = Collections.emptySet();
        paramDao.updateParamList((int)process.getId(), this.autoCloseParamId, topic.isAutoClose() ? on : empty);
        paramDao.updateParamText(process.getId(), this.costParamId, Utils.format(topic.getCost()));
        boolean firstMessageAddInDescription = this.addFirstMessageInDescription && messageMap.size() == 0;
        for (HdMessage topicMessage : hdMessages) {
            int crmUserId;
            Message message = (Message)messageMap.get(topicMessage.getId());
            if (message == null) {
                int crmUserId2;
                message = new Message();
                message.setTypeId(this.id);
                message.setProcessId(process.getId());
                message.setSystemId(String.valueOf(topicMessage.getId()));
                message.setDirection(topicMessage.getDirection());
                if (message.getDirection() == 2 && (crmUserId2 = dbInfo.getCrmUserId(topicMessage.getUserIdFrom())) > 0) {
                    message.setUserId(crmUserId2);
                }
                topicMessage = hdDao.getMessage(topic.getId(), topicMessage.getId());
                if (firstMessageAddInDescription) {
                    process = processDao.getProcess(process.getId());
                    process.setDescription(process.getDescription() + "\n" + topicMessage.getText());
                    processDao.updateProcess(process);
                    firstMessageAddInDescription = false;
                }
                message.setText(topicMessage.getText());
                message.setFromTime(topicMessage.getTimeFrom());
                message.setFrom("");
                message.setTo("");
                for (FileData attach : topicMessage.getAttachList()) {
                    message.addAttach(attach);
                }
                messageDao.updateMessage(message);
                if (this.newMessageEvent && message.getDirection() == 1) {
                    EventProcessor.processEvent(new ProcessMessageAddedEvent(DynActionForm.SYSTEM_FORM, message, process), new SingleConnectionSet(con));
                }
            }
            if (topicMessage.getTimeTo() == null || message.getToTime() != null) continue;
            message.setToTime(topicMessage.getTimeTo());
            if (message.getDirection() == 1 && (crmUserId = dbInfo.getCrmUserId(topicMessage.getUserIdTo())) > 0) {
                message.setUserId(crmUserId);
            }
            messageDao.updateMessageProcess(message);
        }
        return topic;
    }

    @Override
    public boolean isAnswerSupport() {
        return true;
    }

    @Override
    public Message getAnswerMessage(Message original) {
        Message result = new Message();
        result.setTypeId(original.getTypeId());
        result.setProcessId(original.getProcessId());
        Object subject = Utils.maskNull(original.getSubject());
        subject = ((String)subject).startsWith("Re:") ? subject : "Re: " + (String)subject;
        result.setSubject((String)subject);
        Object text = original.getText();
        text = ">" + ((String)text).replace("\r", "").replace("\n", "\n>");
        result.setText((String)text);
        result.setTo(original.getFrom());
        return result;
    }

    @Override
    public boolean isEditable(Message message) {
        return message.getDirection() == 2 && message.getToTime() == null;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public void updateMessage(Connection con, DynActionForm form, Message message) throws Exception {
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        int processId = message.getProcessId();
        CommonObjectLink topicLink = Utils.getFirst(linkDao.getObjectLinksWithType(processId, this.getObjectType()));
        if (topicLink == null) {
            throw new BGException("\u041a \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u0442\u043e\u043f\u0438\u043a HelpDesk.", new Object[0]);
        }
        int topicId = topicLink.getLinkObjectId();
        HelpDeskDAO hdDao = new HelpDeskDAO(form.getUser(), this.getDbInfo());
        HdMessage msg = new HdMessage();
        msg.setId(Utils.parseInt(message.getSystemId()));
        msg.setDirection(2);
        msg.setText(message.getText());
        hdDao.updateMessage(topicId, msg);
        message.setSystemId(String.valueOf(msg.getId()));
        Map<Integer, FileInfo> tmpFiles = SessionTemporaryFiles.getFiles(form, "tmpFileId");
        for (FileInfo fileInfo : tmpFiles.values()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000000);
            try (InputStream inputStream = fileInfo.getInputStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
            hdDao.putAttach(msg.getId(), fileInfo.getTitle(), out.toByteArray());
        }
        message.getAttachList().clear();
        msg = hdDao.getMessage(topicId, msg.getId());
        for (FileData attach : msg.getAttachList()) {
            message.addAttach(attach);
        }
        message.setFrom("");
        message.setTo("");
        new MessageDAO(con).updateMessage(message);
        SessionTemporaryFiles.deleteFiles(form, tmpFiles.keySet());
    }
}

