/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.util.Dynamic;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.event.user.UserChangedEvent;
import ru.bgcrm.plugin.Endpoint;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.ExpressionObject;
import ru.bgcrm.plugin.bgbilling.event.listener.HelpDeskListener;
import ru.bgcrm.plugin.bgbilling.event.listener.LinkChangedListener;
import ru.bgcrm.plugin.bgbilling.event.listener.LinkChangingListener;
import ru.bgcrm.plugin.bgbilling.event.listener.ProcessDoActionListener;

public class Plugin
extends ru.bgcrm.plugin.Plugin {
    public static final String ID = "bgbilling";
    public static final Plugin INSTANCE = new Plugin();
    public static final String PATH_JSP_USER = "/WEB-INF/jspf/user/plugin/bgbilling";
    public static final String ENDPOINT_MESSAGE_HEADER = "/WEB-INF/jspf/user/plugin/bgbilling/helpdesk/process_message_header.jsp";

    private Plugin() {
        super(ID);
    }

    @Override
    public String getTitle() {
        return "BGBilling";
    }

    @Dynamic
    public DBInfoManager getDbInfoManager() {
        return DBInfoManager.getInstance();
    }

    @Override
    public Set<String> getObjectTypes() {
        return Set.of("contract");
    }

    @Override
    public void init(Connection con) throws Exception {
        super.init(con);
        EventProcessor.subscribe((e, conSet) -> DBInfoManager.flush(), SetupChangedEvent.class);
        EventProcessor.subscribe((e, conSet) -> DBInfoManager.flush(), UserChangedEvent.class);
        new LinkChangingListener();
        new LinkChangedListener();
        new HelpDeskListener();
        new ProcessDoActionListener();
        EventProcessor.subscribe((e, conSet) -> new ExpressionObject().toContext(e.getContext()), Expression.ContextInitEvent.class);
    }

    @Override
    protected Map<String, List<String>> endpoints() {
        return Map.ofEntries(Map.entry("js", List.of(Endpoint.getPathPluginJS(ID), "/js/pl.bgbilling.inet.js")), Map.entry("css.jsp", List.of(Endpoint.getPathPluginCSS(ID))), Map.entry("user.customer.tabs.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/customer_tabs.jsp")), Map.entry("user.search.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/search.jsp")), Map.entry("user.url.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/url.jsp")), Map.entry("user.process.link.list.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/process_link_list.jsp")), Map.entry("user.process.linked.list.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/process_linked_list.jsp")), Map.entry("user.process.linkForAdd.list.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/process_link_for_add_list.jsp")), Map.entry("user.process.linkForAddCustom.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/process_link_for_add_custom_list.jsp")), Map.entry("js.init", List.of("/WEB-INF/jspf/user/plugin/bgbilling/js_init.jsp")), Map.entry("user.process.message.attachments.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/helpdesk/process_message_attachments.jsp")), Map.entry("user.message.search.result.jsp", List.of("/WEB-INF/jspf/user/plugin/bgbilling/message_search_result.jsp")), Map.entry(ENDPOINT_MESSAGE_HEADER, List.of(ENDPOINT_MESSAGE_HEADER)));
    }
}

