/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.event.base.UserEvent;
import org.bgerp.util.Log;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.ParamChangingEvent;
import ru.bgcrm.event.link.LinkAddedEvent;
import ru.bgcrm.event.link.LinkAddingEvent;
import ru.bgcrm.event.link.LinkRemovedEvent;
import ru.bgcrm.event.link.LinkRemovingEvent;
import ru.bgcrm.event.process.ProcessChangedEvent;
import ru.bgcrm.event.process.ProcessChangingEvent;
import ru.bgcrm.event.process.ProcessCreatedAsLinkEvent;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.event.process.ProcessRemovedEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.struts.action.ProcessCommandExecutor;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class DefaultProcessChangeListener {
    private static final Log log = Log.getLog();

    public DefaultProcessChangeListener() {
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getProcess()), ProcessChangingEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getProcess()), ProcessChangedEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getProcess()), ProcessCreatedAsLinkEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getProcess()), ProcessMessageAddedEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getProcess()), ProcessRemovedEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getParameter().getObjectType(), e.getObjectId()), ParamChangingEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getParameter().getObjectType(), e.getObjectId()), ParamChangedEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getLink().getObjectType(), e.getLink().getObjectId()), LinkAddingEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getLink().getObjectType(), e.getLink().getObjectId()), LinkAddedEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getLink().getObjectType(), e.getLink().getObjectId()), LinkRemovingEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.processEvent(conSet, (UserEvent)e, e.getLink().getObjectType(), e.getLink().getObjectId()), LinkRemovedEvent.class);
    }

    private void processEvent(ConnectionSet conSet, UserEvent event, String objectType, int objectId) throws Exception {
        if ("process".equals(objectType)) {
            Process process = new ProcessDAO(conSet.getConnection()).getProcess(objectId);
            this.processEvent(conSet, event, process);
        }
    }

    private void processEvent(ConnectionSet conSet, UserEvent event, Process process) throws Exception {
        int typeId = process.getTypeId();
        ProcessType type = ProcessTypeCache.getProcessType(typeId);
        if (type == null) {
            log.error("Not found process type: " + typeId, new Object[0]);
            return;
        }
        DefaultProcessChangingListenerConfig config = type.getProperties().getConfigMap().getConfig(DefaultProcessChangingListenerConfig.class);
        for (ConfigRule rule : config.getRuleList()) {
            rule.processEvent(conSet, event, process);
        }
    }

    private static class DefaultProcessChangingListenerConfig
    extends Config {
        private static final Log log = Log.getLog();
        private final List<ConfigRule> ruleList = new ArrayList<ConfigRule>();

        public DefaultProcessChangingListenerConfig(ConfigMap config) {
            super(null);
            for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("onProcessEvent.").entrySet()) {
                try {
                    this.ruleList.add(new ConfigRule(me.getValue()));
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            log.debug("Rules parsed: {}", this.ruleList);
        }

        public List<ConfigRule> getRuleList() {
            return this.ruleList;
        }
    }

    private static class ConfigRule {
        private static final String EVENT_STATUS_CHANGED = "statusChanged";
        private static final String EVENT_CLOSED = "closed";
        private static final String EVENT_CREATED = "created";
        private static final String EVENT_REMOVED = "removed";
        private static final String EVENT_CREATED_AS_LINK = "createdAsLink";
        private static final String EVENT_STATUS_CHANGING = "statusChanging";
        private static final String EVENT_ALL = "*";
        private static final String EVENT_DESCRIPTION_ADDING = "descriptionAdding";
        private static final String EVENT_DESCRIPTION_ADDED = "descriptionAdded";
        private static final String EVENT_DESCRIPTION_CHANGING = "descriptionChanging";
        private static final String EVENT_DESCRIPTION_CHANGED = "descriptionChanged";
        private static final String EVENT_PARAM_CHANGING = "paramChanging";
        private static final String EVENT_PARAM_CHANGED = "paramChanged";
        private static final String EVENT_LINK_ADDING = "linkAdding";
        private static final String EVENT_LINK_ADDED = "linkAdded";
        private static final String EVENT_LINK_REMOVING = "linkRemoving";
        private static final String EVENT_LINK_REMOVED = "linkRemoved";
        private static final String EVENT_MESSAGE_ADDED = "messageAdded";
        private static final String EVENT_EXECUTORS_CHANGING = "executorsChanging";
        private static final String EVENT_EXECUTORS_CHANGED = "executorsChanged";
        private static final String EVENT_CREATE_FINISHED = "createFinished";
        private final Map<String, Object> eventMap = new HashMap<String, Object>();
        private final Map<String, Object> eventExcludeMap = new HashMap<String, Object>();
        private final String className;
        private final String ifExpression;
        private final Rule checkRule;
        private final String doExpression;
        private final List<String> commands;

        public ConfigRule(ConfigMap config) {
            this.extractEvents(config, Utils.toList(config.get("events", EVENT_ALL), ";"), this.eventMap);
            this.extractEvents(config, Utils.toList(config.get("eventsExclude", ""), ";"), this.eventExcludeMap);
            this.className = config.get("class");
            this.ifExpression = config.get("ifExpression");
            this.checkRule = this.extractCheckRule(config);
            this.doExpression = config.get("doExpression");
            String commands = config.get("commands", "");
            this.commands = Utils.toList(commands, ";");
            if (Utils.notBlankString(commands)) {
                log.warn("Used process type expression commands: {}, qty: {}", commands, this.commands.size());
            }
        }

        private void extractEvents(ConfigMap config, List<String> eventList, Map<String, Object> eventMap) {
            for (String token : eventList) {
                if (token.startsWith(EVENT_STATUS_CHANGED)) {
                    eventMap.put(EVENT_STATUS_CHANGED, Utils.toIntegerSet(StringUtils.substringAfter((String)token, (String)":")));
                    continue;
                }
                if (token.startsWith(EVENT_STATUS_CHANGING)) {
                    eventMap.put(EVENT_STATUS_CHANGING, Utils.toIntegerSet(StringUtils.substringAfter((String)token, (String)":")));
                    continue;
                }
                if (token.startsWith(EVENT_CLOSED)) {
                    eventMap.put(EVENT_CLOSED, Utils.toIntegerSet(StringUtils.substringAfter((String)token, (String)":")));
                    continue;
                }
                if (token.equals(EVENT_CREATED)) {
                    eventMap.put(EVENT_CREATED, "");
                    continue;
                }
                if (token.equals(EVENT_REMOVED)) {
                    eventMap.put(EVENT_REMOVED, "");
                    continue;
                }
                if (token.equals(EVENT_CREATED_AS_LINK)) {
                    eventMap.put(EVENT_CREATED_AS_LINK, "");
                    continue;
                }
                if (token.equals(EVENT_CREATE_FINISHED)) {
                    eventMap.put(EVENT_CREATE_FINISHED, "");
                    continue;
                }
                if (token.equals(EVENT_DESCRIPTION_ADDING)) {
                    eventMap.put(EVENT_DESCRIPTION_ADDING, "");
                    continue;
                }
                if (token.equals(EVENT_DESCRIPTION_ADDED)) {
                    eventMap.put(EVENT_DESCRIPTION_ADDED, "");
                    continue;
                }
                if (token.equals(EVENT_DESCRIPTION_CHANGING)) {
                    eventMap.put(EVENT_DESCRIPTION_CHANGING, "");
                    continue;
                }
                if (token.equals(EVENT_DESCRIPTION_CHANGED)) {
                    eventMap.put(EVENT_DESCRIPTION_CHANGED, "");
                    continue;
                }
                if (token.startsWith(EVENT_LINK_ADDING)) {
                    eventMap.put(EVENT_LINK_ADDING, "");
                    continue;
                }
                if (token.startsWith(EVENT_LINK_ADDED)) {
                    eventMap.put(EVENT_LINK_ADDED, "");
                    continue;
                }
                if (token.startsWith(EVENT_PARAM_CHANGING)) {
                    eventMap.put(EVENT_PARAM_CHANGING, Utils.toIntegerSet(StringUtils.substringAfter((String)token, (String)":")));
                    continue;
                }
                if (token.startsWith(EVENT_PARAM_CHANGED)) {
                    eventMap.put(EVENT_PARAM_CHANGED, Utils.toIntegerSet(StringUtils.substringAfter((String)token, (String)":")));
                    continue;
                }
                if (token.startsWith(EVENT_LINK_REMOVING)) {
                    eventMap.put(EVENT_LINK_REMOVING, "");
                    continue;
                }
                if (token.startsWith(EVENT_LINK_REMOVED)) {
                    eventMap.put(EVENT_LINK_REMOVED, "");
                    continue;
                }
                if (token.equals(EVENT_MESSAGE_ADDED)) {
                    eventMap.put(EVENT_MESSAGE_ADDED, "");
                    continue;
                }
                if (token.equals(EVENT_EXECUTORS_CHANGING)) {
                    eventMap.put(EVENT_EXECUTORS_CHANGING, "");
                    continue;
                }
                if (token.equals(EVENT_EXECUTORS_CHANGED)) {
                    eventMap.put(EVENT_EXECUTORS_CHANGED, "");
                    continue;
                }
                if (!token.equals(EVENT_ALL)) continue;
                eventMap.put(EVENT_ALL, "");
            }
        }

        private Rule extractCheckRule(ConfigMap config) {
            try {
                return new Rule(config);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void processEvent(ConnectionSet conSet, UserEvent e, Process process) throws Exception {
            if (!this.checkEvent(e, process, this.eventMap)) {
                return;
            }
            if (this.checkEvent(e, process, this.eventExcludeMap)) {
                return;
            }
            if (Utils.notBlankString(this.className)) {
                log.debug("Processing rule with class: {}", this.className);
                Class<?> listenerClass = Bean.getClass(this.className);
                ((EventListener)listenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).notify(e, conSet);
            } else {
                if (Utils.notBlankString(this.ifExpression) && !Expression.init(conSet, e, process).executeCheck(this.ifExpression)) {
                    log.debug("Skipping rule by ifExpression.", new Object[0]);
                    return;
                }
                if (this.checkRule != null) {
                    this.checkRule.check(Expression.init(conSet, e, process), e);
                }
                if (Utils.notBlankString(this.doExpression)) {
                    log.debug("Do expression: {}", this.doExpression);
                    try {
                        Expression.init(conSet, e, process).execute(this.doExpression);
                    }
                    catch (Exception ex) {
                        if (ex.getCause() instanceof BGMessageException) {
                            throw (BGMessageException)ex.getCause();
                        }
                        throw new BGException(ex);
                    }
                }
                if (!this.commands.isEmpty()) {
                    log.warn("Processing commands: {}", this.commands);
                    ProcessCommandExecutor.processDoCommands(conSet.getConnection(), e.getForm(), process, e, this.commands);
                }
            }
        }

        private boolean checkEvent(UserEvent e, Process process, Map<String, Object> eventMap) {
            if (eventMap.containsKey(EVENT_ALL)) {
                return true;
            }
            Class<?> eventClass = e.getClass();
            if (eventClass == ProcessChangingEvent.class) {
                ProcessChangingEvent event = (ProcessChangingEvent)e;
                if (event.isStatus()) {
                    Set statusIds = (Set)eventMap.get(EVENT_STATUS_CHANGING);
                    return statusIds != null && (statusIds.size() == 0 || statusIds.contains(event.getStatusChange().getStatusId()));
                }
                if (event.isDescriptionAdd()) {
                    return eventMap.containsKey(EVENT_DESCRIPTION_ADDING);
                }
                if (event.isDescription()) {
                    return eventMap.containsKey(EVENT_DESCRIPTION_CHANGING);
                }
                if (event.isExecutors()) {
                    return eventMap.containsKey(EVENT_EXECUTORS_CHANGING);
                }
                return false;
            }
            if (eventClass == ProcessChangedEvent.class) {
                ProcessChangedEvent event = (ProcessChangedEvent)e;
                if (event.isStatus()) {
                    Set statusIds = (Set)eventMap.get(EVENT_STATUS_CHANGED);
                    return statusIds != null && (statusIds.size() == 0 || statusIds.contains(process.getStatusId()));
                }
                if (event.isDescriptionAdd()) {
                    return eventMap.containsKey(EVENT_DESCRIPTION_ADDED);
                }
                if (event.isDescription()) {
                    return eventMap.containsKey(EVENT_DESCRIPTION_CHANGED);
                }
                if (event.isExecutors()) {
                    return eventMap.containsKey(EVENT_EXECUTORS_CHANGED);
                }
                if (event.isCreated()) {
                    return eventMap.containsKey(EVENT_CREATED);
                }
                if (event.isCreateFinished()) {
                    return eventMap.containsKey(EVENT_CREATE_FINISHED);
                }
                return false;
            }
            if (eventClass == ProcessMessageAddedEvent.class) {
                return eventMap.containsKey(EVENT_MESSAGE_ADDED);
            }
            if (eventClass == ProcessRemovedEvent.class) {
                return eventMap.containsKey(EVENT_REMOVED);
            }
            if (eventClass == ParamChangingEvent.class) {
                ParamChangingEvent event = (ParamChangingEvent)e;
                Set typeIds = (Set)eventMap.get(EVENT_PARAM_CHANGING);
                return typeIds != null && (typeIds.size() == 0 || typeIds.contains(event.getParameter().getId()));
            }
            if (eventClass == ParamChangedEvent.class) {
                ParamChangedEvent event = (ParamChangedEvent)e;
                Set typeIds = (Set)eventMap.get(EVENT_PARAM_CHANGED);
                return typeIds != null && (typeIds.size() == 0 || typeIds.contains(event.getParameter().getId()));
            }
            if (eventClass == ProcessCreatedAsLinkEvent.class) {
                return eventMap.containsKey(EVENT_CREATED_AS_LINK);
            }
            if (eventClass == LinkRemovingEvent.class) {
                return eventMap.containsKey(EVENT_LINK_REMOVING);
            }
            if (eventClass == LinkRemovedEvent.class) {
                return eventMap.containsKey(EVENT_LINK_REMOVED);
            }
            if (eventClass == LinkAddingEvent.class) {
                return eventMap.containsKey(EVENT_LINK_ADDING);
            }
            if (eventClass == LinkAddedEvent.class) {
                return eventMap.containsKey(EVENT_LINK_ADDED);
            }
            return false;
        }
    }

    private static class Rule {
        private final String expression;
        private final String checkErrorMessage;
        private final boolean showEvent;

        private Rule(ConfigMap rule) {
            this.expression = rule.get("checkExpression");
            this.checkErrorMessage = rule.get("checkErrorMessage");
            this.showEvent = rule.getBoolean("checkErrorShowEvent", false);
            if (Utils.isBlankString(this.expression) || Utils.isBlankString(this.checkErrorMessage)) {
                throw new BGException("Expression incorrect: " + this.expression + "; checkErrorMessage: " + this.checkErrorMessage, new Object[0]);
            }
        }

        private void check(Expression expr, UserEvent e) throws BGMessageException {
            if (!expr.executeCheck(this.expression)) {
                if (this.showEvent) {
                    throw new BGMessageExceptionWithoutL10n(this.checkErrorMessage + "\n (" + String.valueOf(e) + ")", new Object[0]);
                }
                throw new BGMessageExceptionWithoutL10n(this.checkErrorMessage, new Object[0]);
            }
        }
    }
}

