/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.expression;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import ru.bgcrm.dao.expression.ExpressionObject;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public abstract class ParamExpressionObject
implements ExpressionObject {
    private static final Log log = Log.getLog();
    private final ParamValueDAO paramDao;
    private final int objectId;

    protected ParamExpressionObject(Connection con, int objectId) {
        this.paramDao = new ParamValueDAO(con);
        this.objectId = objectId;
    }

    public List<String> addressValues(int paramId, String formatName) {
        ArrayList<String> result = new ArrayList<String>();
        Collection<ParameterAddressValue> value = this.getParamAddressValues(paramId, formatName);
        for (ParameterAddressValue addr : value) {
            result.add(addr.getValue());
        }
        return result;
    }

    public Set<Integer> addressCityIds(int paramId) {
        Collection<ParameterAddressValue> value = this.getParamAddressValues(paramId, null);
        HashSet<Integer> result = new HashSet<Integer>(value.size());
        for (ParameterAddressValue addr : value) {
            result.add(addr.getHouse().getAddressStreet().getCityId());
        }
        return result;
    }

    public Set<Integer> addressStreetIds(int paramId) {
        Collection<ParameterAddressValue> value = this.getParamAddressValues(paramId, null);
        HashSet<Integer> result = new HashSet<Integer>(value.size());
        for (ParameterAddressValue addr : value) {
            result.add(addr.getHouse().getStreetId());
        }
        return result;
    }

    public Set<Integer> addressQuarterIds(int paramId) {
        Collection<ParameterAddressValue> value = this.getParamAddressValues(paramId, null);
        HashSet<Integer> result = new HashSet<Integer>(value.size());
        for (ParameterAddressValue addr : value) {
            result.add(addr.getHouse().getQuarterId());
        }
        return result;
    }

    public Set<Integer> addressAreaIds(int paramId) {
        Collection<ParameterAddressValue> value = this.getParamAddressValues(paramId, null);
        HashSet<Integer> result = new HashSet<Integer>(value.size());
        for (ParameterAddressValue addr : value) {
            result.add(addr.getHouse().getAreaId());
        }
        return result;
    }

    protected Collection<ParameterAddressValue> getParamAddressValues(int paramId, String formatName) {
        Collection<ParameterAddressValue> value = Collections.emptyList();
        try {
            Parameter param = ParameterCache.getParameter(paramId);
            if (param == null || !"address".equals(param.getType())) {
                log.error("Param not found {} or not address in expression", paramId);
                return Collections.emptySet();
            }
            value = this.paramDao.getParamAddress(this.objectId, param.getId(), true, formatName).values();
        }
        catch (SQLException e) {
            log.error(e);
        }
        return value;
    }

    public Set<Integer> listValueIds(int paramId) {
        Set<Integer> result = Set.of();
        try {
            Parameter param = ParameterCache.getParameter(paramId);
            if (param == null || !"list".equals(param.getType()) && !"listcount".equals(param.getType())) {
                log.error("Param not found with ID: " + paramId + " or has no 'list'/'listcount' type", new Object[0]);
                return result;
            }
            result = "list".equals(param.getType()) ? this.paramDao.getParamList(this.objectId, paramId) : this.paramDao.getParamListCount(this.objectId, paramId).keySet();
        }
        catch (SQLException e) {
            log.error(e);
        }
        return result;
    }

    public Object val(int paramId, String format) {
        try {
            Parameter param = ParameterCache.getParameter(paramId);
            switch (Parameter.Type.of(param.getType())) {
                case ADDRESS: {
                    return this.paramDao.getParamAddress(this.objectId, paramId).values().stream().map(ParameterAddressValue::getValue).collect(Collectors.joining("; "));
                }
                case BLOB: {
                    return Utils.maskNull(this.paramDao.getParamBlob(this.objectId, paramId));
                }
                case DATE: {
                    return TimeUtils.format(this.paramDao.getParamDate(this.objectId, paramId), param.getDateParamFormat());
                }
                case DATETIME: {
                    return TimeUtils.format(this.paramDao.getParamDateTime(this.objectId, paramId), param.getDateParamFormat());
                }
                case PHONE: {
                    ParameterPhoneValue value = this.paramDao.getParamPhone(this.objectId, paramId);
                    if ("nf".equals(format)) {
                        return value;
                    }
                    return value != null ? value.toString() : "";
                }
                case TEXT: {
                    return Utils.maskNull(this.paramDao.getParamText(this.objectId, paramId));
                }
                case FILE: {
                    return Utils.toString(this.paramDao.getParamFile(this.objectId, paramId).values().stream().map(IdTitle::getTitle).toList());
                }
                case EMAIL: {
                    return Parameter.Type.emailToString(this.paramDao.getParamEmail(this.objectId, paramId).values());
                }
                case LIST: {
                    return Parameter.Type.listToString(paramId, this.paramDao.getParamListWithComments(this.objectId, paramId));
                }
                case LISTCOUNT: {
                    return Parameter.Type.listCountToString(paramId, this.paramDao.getParamListCount(this.objectId, paramId));
                }
                case MONEY: {
                    return Utils.format(this.paramDao.getParamMoney(this.objectId, paramId));
                }
                case TREE: {
                    return Parameter.Type.treeToString(paramId, this.paramDao.getParamTree(this.objectId, paramId));
                }
                case TREECOUNT: {
                    return Parameter.Type.treeCountToString(paramId, this.paramDao.getParamTreeCount(this.objectId, paramId));
                }
            }
        }
        catch (SQLException e) {
            log.error(e);
            return e.getMessage();
        }
        return "";
    }

    public String val(int paramId) {
        return (String)this.val(paramId, null);
    }

    public String getValue(int paramId) {
        return this.val(paramId);
    }

    @Deprecated
    public List<String> addressValues(int paramId) {
        log.warndMethod("addressValues", "getValue");
        return this.addressValues(paramId, null);
    }

    @Deprecated
    public Set<String> listValueTitles(int paramId) {
        log.warndMethod("listValueTitles", "getValue");
        Set<String> result = Collections.emptySet();
        try {
            Parameter param = ParameterCache.getParameter(paramId);
            if (param == null || !"list".equals(param.getType())) {
                log.error("Param not found: " + paramId + " or not list in expression", new Object[0]);
                return Collections.emptySet();
            }
            result = new HashSet<String>();
            for (IdTitle value : this.paramDao.getParamListWithTitles(this.objectId, paramId)) {
                result.add(value.getTitle());
            }
        }
        catch (SQLException e) {
            log.error(e);
        }
        return result;
    }

    @Deprecated
    public String getParamText(int paramId) throws SQLException {
        log.warndMethod("getParamText", "getValue");
        return this.paramDao.getParamText(this.objectId, paramId);
    }

    @Deprecated
    public Date getParamDate(int paramId) throws SQLException {
        log.warndMethod("getParamDate", "getValue");
        return this.paramDao.getParamDate(this.objectId, paramId);
    }

    @Deprecated
    public Date getParamDateTime(int paramId) throws SQLException {
        log.warndMethod("getParamDateTime", "getValue");
        return this.paramDao.getParamDateTime(this.objectId, paramId);
    }

    @Deprecated
    public String getParamPhoneNoFormat(int paramId) throws SQLException {
        log.warndMethod("getParamPhoneNoFormat", "ParamValueDAO.getParamPhone");
        ParameterPhoneValue value = this.paramDao.getParamPhone(this.objectId, paramId);
        if (!value.getItemList().isEmpty()) {
            return value.getItemList().get(0).getPhone();
        }
        return null;
    }
}

