/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.LastModifyDAO;
import ru.bgcrm.model.Config;
import ru.bgcrm.model.ConfigRecord;
import ru.bgcrm.model.Page;
import ru.bgcrm.util.Utils;

public class ConfigDAO
extends CommonDAO {
    public static final String TABLE_CONFIG_GLOBAL = " config_global ";
    @Deprecated
    private String tableName;

    public ConfigDAO(Connection con) {
        super(con);
    }

    public ConfigDAO(Connection con, String tableName) {
        super(con);
        this.tableName = tableName;
    }

    public void searchGlobalConfigList(Pageable<Config> searchResult, Set<Integer> allowedConfigIds, String filterLike) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Config> list = searchResult.getList();
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append("*");
            query.append(" FROM ");
            query.append(TABLE_CONFIG_GLOBAL);
            query.append(" WHERE ");
            query.append("1>0");
            if (CollectionUtils.isNotEmpty(allowedConfigIds)) {
                query.append(" AND ");
                query.append("id IN (");
                query.append(Utils.toString(allowedConfigIds));
                query.append(")");
            }
            if (Utils.notBlankString(filterLike)) {
                query.append(" AND ");
                query.append("data LIKE '");
                query.append(filterLike);
                query.append("' ");
            }
            query.append(" ORDER BY ");
            query.append("title");
            query.append(page.getLimitSql());
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getGlobalConfigFromRs(rs));
            }
            page.setRecordCount(ps);
            ps.close();
        }
    }

    public Config getGlobalConfig(int id) throws SQLException {
        Config config = null;
        int index = 1;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("*");
        query.append(" FROM ");
        query.append(TABLE_CONFIG_GLOBAL);
        query.append(" WHERE ");
        query.append("id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(index++, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            config = this.getGlobalConfigFromRs(rs);
            LastModifyDAO.setLastModify(config, rs);
        }
        ps.close();
        return config;
    }

    public Config getActiveGlobalConfig() throws SQLException {
        Config config = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("*");
        query.append(" FROM ");
        query.append(TABLE_CONFIG_GLOBAL);
        query.append(" WHERE ");
        query.append("active=true");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            config = this.getGlobalConfigFromRs(rs);
        }
        ps.close();
        return config;
    }

    public void setActiveGlobalConfig(int id) throws SQLException {
        int index = 1;
        boolean needUpdate = false;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("active");
        query.append(" FROM ");
        query.append(TABLE_CONFIG_GLOBAL);
        query.append(" WHERE ");
        query.append("id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(index++, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            needUpdate = !rs.getBoolean(1);
        }
        ps.close();
        if (needUpdate) {
            query = new StringBuilder();
            query.append("UPDATE ");
            query.append(TABLE_CONFIG_GLOBAL);
            query.append(" SET ");
            query.append("active=false");
            ps = this.con.prepareStatement(query.toString());
            ps.executeUpdate();
            ps.close();
            index = 1;
            query = new StringBuilder();
            query.append("UPDATE ");
            query.append(TABLE_CONFIG_GLOBAL);
            query.append(" SET ");
            query.append("active=true");
            query.append(" WHERE ");
            query.append("id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, id);
            ps.executeUpdate();
            ps.close();
        }
    }

    public void updateGlobalConfig(Config config) throws SQLException {
        if (config == null) {
            return;
        }
        int index = 1;
        if (config.getId() <= 0) {
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO ");
            query.append(TABLE_CONFIG_GLOBAL);
            query.append(" SET ");
            query.append("title=?, data=?, parent_id=?, last_modify_user_id=?, last_modify_dt=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            ps.setString(index++, config.getTitle());
            ps.setString(index++, config.getData());
            ps.setInt(index++, config.getParentId());
            LastModifyDAO.setLastModifyFields(ps, index++, index++, config.getLastModify());
            ps.executeUpdate();
            config.setId(this.lastInsertId(ps));
            ps.close();
        } else {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(TABLE_CONFIG_GLOBAL);
            query.append(" SET ");
            query.append("title=?, data=?, parent_id=?, last_modify_user_id=?, last_modify_dt=?");
            query.append(" WHERE ");
            query.append("id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(index++, config.getTitle());
            ps.setString(index++, config.getData());
            ps.setInt(index++, config.getParentId());
            LastModifyDAO.setLastModifyFields(ps, index++, index++, config.getLastModify());
            ps.setInt(index++, config.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    public Map<Integer, String> getIncludes(int parentId) throws SQLException {
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        String query = "SELECT * FROM  config_global  WHERE parent_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, parentId);
        try (ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Config config = this.getGlobalConfigFromRs(rs);
                result.put(config.getId(), config.getData());
            }
        }
        return result;
    }

    public void deleteGlobalConfig(int id) throws SQLException {
        if (id > 0) {
            int index = 1;
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append(TABLE_CONFIG_GLOBAL);
            query.append(" WHERE ");
            query.append("active=false AND id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, id);
            ps.executeUpdate();
            ps.close();
        }
    }

    @Deprecated
    public List<ConfigRecord> getConfigRecordList(String tableId, int recordId) throws SQLException {
        ArrayList<ConfigRecord> result = new ArrayList<ConfigRecord>();
        PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE table_id=? AND record_id=? ORDER BY `key`");
        ps.setString(1, tableId);
        ps.setInt(2, recordId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ConfigRecord configRecord = new ConfigRecord();
            this.setConfigRecordData(configRecord, rs);
            result.add(configRecord);
        }
        ps.close();
        return result;
    }

    @Deprecated
    public Map<String, String> getConfigRecordMap(String tableId, int recordId) throws SQLException {
        tableId = tableId.trim();
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (ConfigRecord configRecord : this.getConfigRecordList(tableId, recordId)) {
            configMap.put(configRecord.getKey(), configRecord.getValue());
        }
        return configMap;
    }

    @Deprecated
    public void updateConfigForRecord(String tableId, int recordId, Map<String, String> config) throws SQLException {
        tableId = tableId.trim();
        if (config != null) {
            ArrayList<ConfigRecord> configList = new ArrayList<ConfigRecord>();
            for (String key : config.keySet()) {
                ConfigRecord configRecord = new ConfigRecord();
                configRecord.setKey(key);
                configRecord.setValue(config.get(key));
                configList.add(configRecord);
            }
            this.updateConfigForRecord(tableId, recordId, configList);
        }
    }

    @Deprecated
    public void updateConfigForRecord(String tableId, int recordId, List<ConfigRecord> config) throws SQLException {
        tableId = tableId.trim();
        PreparedStatement ps = null;
        ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE table_id=? AND record_id=?");
        ps.setString(1, tableId);
        ps.setInt(2, recordId);
        ps.executeUpdate();
        ps.close();
        ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET table_id=?, record_id=?, `key`=?, value=?");
        ps.setString(1, tableId);
        ps.setInt(2, recordId);
        for (ConfigRecord configRecord : config) {
            ps.setString(3, configRecord.getKey());
            ps.setString(4, configRecord.getValue());
            ps.executeUpdate();
        }
        ps.close();
    }

    private Config getGlobalConfigFromRs(ResultSet rs) throws SQLException {
        Config config = new Config();
        config.setId(rs.getInt("id"));
        config.setParentId(rs.getInt("parent_id"));
        config.setTitle(rs.getString("title"));
        config.setData(rs.getString("data"));
        config.setActive(rs.getBoolean("active"));
        return config;
    }

    private void setConfigRecordData(ConfigRecord configRecord, ResultSet rs) throws SQLException {
        configRecord.setTableId(rs.getString("table_id"));
        configRecord.setRecordId(rs.getInt("record_id"));
        configRecord.setKey(rs.getString("key"));
        configRecord.setValue(rs.getString("value"));
    }
}

