/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util;

import java.time.Duration;
import ru.bgcrm.util.Utils;

public class AntiSpam {
    private final long timeout;
    private volatile String lastIp;
    private volatile long lastTime;

    public AntiSpam(long timeout) {
        this.timeout = timeout;
    }

    public AntiSpam(Duration timeout) {
        this(timeout.toMillis());
    }

    public long getWaitTimeout(String ip) {
        if (Utils.isBlankString(ip)) {
            return this.timeout;
        }
        if (!ip.equals(this.lastIp)) {
            return this.reset(ip);
        }
        long wentTime = System.currentTimeMillis() - this.lastTime;
        if (wentTime > this.timeout) {
            return this.reset(ip);
        }
        return this.timeout - wentTime;
    }

    private long reset(String ip) {
        this.lastIp = ip;
        this.lastTime = System.currentTimeMillis();
        return 0L;
    }
}

