/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.telegram;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.telegram.Bot;
import org.bgerp.plugin.telegram.Config;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.Utils;

public class ExpressionObject
implements ru.bgcrm.dao.expression.ExpressionObject {
    private static final Log log = Log.getLog();
    private static final Set<Character> SPECIAL_CHARACTERS_MD = Set.of(Character.valueOf('('), Character.valueOf(')'));

    ExpressionObject() {
    }

    public void sendMessage(String chatId, String text) {
        if (chatId != null && !chatId.trim().isEmpty()) {
            Bot bot = Bot.getInstance();
            if (bot == null) {
                return;
            }
            log.debug("Send message: {}, chatId: {}", text, chatId);
            bot.sendMessage(chatId, text);
        }
    }

    public void sendMessage(String chatId, String text, String parseMode) {
        if (chatId != null && !chatId.trim().isEmpty() && !parseMode.trim().isEmpty()) {
            Bot bot = Bot.getInstance();
            if (bot == null) {
                return;
            }
            log.debug("Send message: {}, chatId: {}", text, chatId);
            bot.sendMessage(chatId, text, parseMode);
        }
    }

    public void sendMessage(Collection<Integer> userIds, String text) {
        Config config = Setup.getSetup().getConfig(Config.class);
        Collection activeUserIds = userIds.stream().map(UserCache::getUser).filter(user -> user != null && user.getStatus() == 0).map(Id::getId).collect(Collectors.toList());
        if (userIds.isEmpty()) {
            return;
        }
        this.sendMessageForObject(activeUserIds, config.getParamId(), text);
    }

    public void sendMessage(Process process, String text) {
        this.sendMessage(process.getExecutorIds(), text);
    }

    public void sendMessageForProcess(Process process, String text) {
        Config config = Setup.getSetup().getConfig(Config.class);
        this.sendMessageForObject(Collections.singletonList(process.getId()), config.getProcessParamId(), text);
    }

    private void sendMessageForObject(Collection<Integer> objectIds, int paramId, String text) {
        Bot bot = Bot.getInstance();
        if (bot == null) {
            return;
        }
        try (Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();){
            ParamValueDAO paramDAO = new ParamValueDAO(con);
            for (int objectId : objectIds) {
                String chatId = paramDAO.getParamText(objectId, paramId);
                if (!Utils.notBlankString(chatId)) continue;
                bot.sendMessage(chatId, text);
            }
        }
        catch (Exception ex) {
            log.error("Error send message in telegram", ex);
        }
    }

    public static String escapeMarkdown(String text) {
        StringBuilder result = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (SPECIAL_CHARACTERS_MD.contains(Character.valueOf(c))) {
                result.append("\\");
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public void toContext(Map<String, Object> context) {
        context.put("telegram", this);
    }
}

