/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.feedback.action.open;

import java.util.Date;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.action.open.ProcessAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGSecurityException;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.model.process.link.ProcessLink;
import org.bgerp.plugin.msg.email.message.MessageTypeEmail;
import ru.bgcrm.dao.CustomerDAO;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/open/plugin/feedback/message")
public class MessageAction
extends BaseAction {
    public ActionForward edit(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.html(conSet, null, "/WEB-INF/jspf/open/plugin/feedback/editor.jsp");
    }

    public ActionForward add(DynActionForm form, ConnectionSet conSet) throws Exception {
        ProcessAction.Config configProcessOpen = this.setup.getConfig(ProcessAction.Config.class);
        int processId = form.getParamInt("processId");
        Process process = new ProcessDAO(conSet.getSlaveConnection()).getProcess(processId);
        if (configProcessOpen == null || !configProcessOpen.isOpen(process, form)) {
            throw new BGSecurityException("Process is not open", form);
        }
        Config config = this.setup.getConfig(Config.class);
        if (config == null) {
            throw new BGSecurityException("Feedback is not enabled", form);
        }
        String subject = form.getParam("subject", Utils::notBlankString);
        String email = form.getParam("email", Utils::isValidEmail);
        String text = form.getParam("text", Utils::notBlankString);
        MessageTypeEmail messageType = config.getMessageTypeEmail();
        Message message = new Message().withUserId(form.getUserId()).withTypeId(messageType.getId()).withDirection(1).withFrom(email).withFromTime(new Date()).withTo(messageType.getEmail()).withProcessId(processId).withSubject(subject).withText(text);
        new MessageDAO(conSet.getConnection()).updateMessage(message);
        EventProcessor.processEvent(new ProcessMessageAddedEvent(form, message, process), conSet);
        this.linkCustomers(conSet, email, processId);
        form.getResponse().setMessage(this.l.l("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e, \u0436\u0434\u0438\u0442\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 Email", new Object[0]));
        return this.json(conSet, form);
    }

    private void linkCustomers(ConnectionSet conSet, String email, int processId) {
        Pageable<ParameterSearchedObject<Customer>> searchResult = new Pageable<ParameterSearchedObject<Customer>>();
        new CustomerDAO(conSet.getSlaveConnection()).searchCustomerListByEmail(searchResult, null, email);
        if (!searchResult.getList().isEmpty()) {
            ProcessLinkDAO linkDao = new ProcessLinkDAO(conSet.getConnection());
            for (ParameterSearchedObject<Customer> link : searchResult.getList()) {
                linkDao.addLinkIfNotExist(new ProcessLink(processId, "customer", link.getObject().getId(), link.getObject().getTitle()));
            }
        }
    }

    public static class Config
    extends org.bgerp.app.cfg.Config {
        private final MessageTypeEmail messageTypeEmail;

        protected Config(ConfigMap setup, boolean validate) throws Exception {
            super(null, validate);
            this.messageTypeEmail = this.loadMessageTypeEmail(setup);
        }

        private MessageTypeEmail loadMessageTypeEmail(ConfigMap config) throws Exception {
            MessageTypeConfig messageTypeConfig = config.getConfig(MessageTypeConfig.class);
            int messageTypeEmailId = (config = config.sub("feedback:")).getInt("messageTypeEmailId");
            this.initWhen(messageTypeEmailId > 0);
            MessageType messageTypeEmail = (MessageType)messageTypeConfig.getTypeMap().get(messageTypeEmailId);
            if (messageTypeEmail == null) {
                throw new BGMessageException("No message type with ID: {} found", messageTypeEmailId);
            }
            if (!(messageTypeEmail instanceof MessageTypeEmail)) {
                throw new BGMessageException("Wrong class instead of MessageTypeEmail: {}", messageTypeEmail.getClass());
            }
            return (MessageTypeEmail)messageTypeEmail;
        }

        public MessageTypeEmail getMessageTypeEmail() {
            return this.messageTypeEmail;
        }
    }
}

