/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription.event.listener;

import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.file.FileData;
import org.bgerp.model.msg.Message;
import org.bgerp.plugin.bil.invoice.event.InvoicePaidEvent;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.plugin.bil.subscription.Config;
import org.bgerp.plugin.bil.subscription.model.Subscription;
import org.bgerp.plugin.bil.subscription.model.config.PaidInvoiceConfig;
import org.bgerp.plugin.msg.email.message.MessageTypeEmail;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class PaidInvoiceListener {
    private static final Log log = Log.getLog();

    public PaidInvoiceListener() {
        EventProcessor.subscribe(this::invoicePaid, InvoicePaidEvent.class);
    }

    private void invoicePaid(InvoicePaidEvent e, ConnectionSet conSet) throws Exception {
        Config config = Setup.getSetup().getConfig(Config.class);
        Invoice invoice = e.getInvoice();
        log.debug("Invoice paid: {}, process: {}", invoice.getNumber(), invoice.getProcessId());
        ParamValueDAO dao = new ParamValueDAO(conSet.getSlaveConnection());
        Integer subscriptionId = Utils.getFirst(dao.getParamList(invoice.getProcessId(), config.getParamSubscriptionId()));
        if (subscriptionId == null) {
            log.debug("No subscription param value defined.", new Object[0]);
            return;
        }
        Subscription subscription = config.getSubscriptionOrThrow(subscriptionId);
        PaidInvoiceConfig onPaidConfig = subscription.getPaidInvoiceConfig();
        if (onPaidConfig == null) {
            log.debug("No onPaidInvoiceConfig defined.", new Object[0]);
            return;
        }
        FileData fd = this.updateLic(e.getForm(), conSet, invoice, config, onPaidConfig);
        if (fd != null) {
            this.createEmail(e.getForm(), conSet, invoice, config, onPaidConfig, fd);
        }
    }

    private FileData updateLic(DynActionForm form, ConnectionSet conSet, Invoice invoice, Config config, PaidInvoiceConfig onPaidConfig) throws Exception {
        LocalDate dateTo = (LocalDate)new Expression(Map.of("invoice", invoice)).execute(onPaidConfig.getDateToExpression());
        log.debug("dateTo: {}", dateTo);
        new ParamValueDAO(conSet.getConnection(), true, form.getUserId()).updateParamDate(invoice.getProcessId(), config.getParamDateToId(), TimeConvert.toDate(dateTo));
        return config.updateLic(invoice.getProcessId(), conSet);
    }

    private void createEmail(DynActionForm form, ConnectionSet conSet, Invoice invoice, Config config, PaidInvoiceConfig onPaidConfig, FileData fd) throws Exception {
        ParameterEmailValue email = Utils.getFirst(new ParamValueDAO(conSet.getSlaveConnection()).getParamEmail(invoice.getProcessId(), config.getParamEmailId()).values());
        if (email == null) {
            log.debug("No email param value defined.", new Object[0]);
            return;
        }
        MessageTypeEmail messageType = onPaidConfig.getEmailMessageType();
        if (messageType == null) {
            log.debug("No email message type defined.", new Object[0]);
            return;
        }
        Message message = new Message();
        message.setSystemId("");
        message.setProcessId(invoice.getProcessId());
        message.setTypeId(messageType.getId());
        message.setDirection(2);
        message.setUserId(form.getUserId());
        message.setFrom(messageType.getEmail());
        message.setFromTime(new Date());
        message.setTo(email.getValue());
        message.setSubject(onPaidConfig.getEmailSubject());
        message.setText((String)new Expression(Map.of("invoice", invoice)).execute(onPaidConfig.getEmailTextExpression()));
        message.addAttach(fd);
        new MessageDAO(conSet.getConnection()).updateMessage(message);
    }
}

