/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.cache;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.action.MessageAction;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.Cache;
import org.bgerp.cache.CacheHolder;
import org.bgerp.cache.UserCache;
import org.bgerp.event.client.NewsInfoEvent;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.config.MessageTypeConfig;
import ru.bgcrm.dao.NewsDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.model.News;
import ru.bgcrm.model.user.User;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SQLUtils;

public class UserNewsCache
extends Cache<UserNewsCache> {
    private static CacheHolder<UserNewsCache> HOLDER = new CacheHolder<UserNewsCache>(new UserNewsCache());
    private final Map<Integer, NewsInfoEvent> userInfoMap = new ConcurrentHashMap<Integer, NewsInfoEvent>();

    public static NewsInfoEvent getUserEvent(ConnectionSet conSet, int userId) throws Exception {
        NewsInfoEvent result = UserNewsCache.HOLDER.getInstance().userInfoMap.get(userId);
        if (result == null) {
            boolean blinkMessages;
            String lastNonpopupUnread;
            NewsDAO newsDao = new NewsDAO(conSet.getConnection());
            ArrayList<Integer> notPopupNews = new ArrayList<Integer>();
            Pageable<News> searchResult = new Pageable<News>();
            newsDao.searchNewsList(searchResult, userId, false, null);
            ArrayList<Integer> popupNews = new ArrayList<Integer>();
            for (News news : searchResult.getList()) {
                if (news.isPopup()) {
                    popupNews.add(news.getId());
                    continue;
                }
                notPopupNews.add(news.getId());
            }
            User user = UserCache.getUser(userId);
            String currentNonpopupUnread = Utils.toString(notPopupNews);
            boolean blinkNews = !currentNonpopupUnread.equals(lastNonpopupUnread = user.getPersonalizationMap().get("unreadNews", ""));
            int currentUnprocessedMessages = 0;
            if (UserCache.getUser(userId).checkPerm(MessageAction.class.getAnnotation(ActionServlet.Action.class).path() + ":messageList")) {
                MessageTypeConfig mtConfig = Setup.getSetup().getConfig(MessageTypeConfig.class);
                for (MessageType type : mtConfig.getTypeMap().values()) {
                    if (type.getUnprocessedMessagesCount() == null) continue;
                    currentUnprocessedMessages += type.getUnprocessedMessagesCount().intValue();
                }
            }
            int lastUnprocessedMessages = user.getPersonalizationMap().getInt("unprocessedMessages", 0);
            boolean bl = blinkMessages = currentUnprocessedMessages > 0 && currentUnprocessedMessages != lastUnprocessedMessages;
            if (currentUnprocessedMessages == 0) {
                Preferences prefs = new Preferences();
                prefs.put("unprocessedMessages", "0");
                new UserDAO(conSet.getConnection()).updatePersonalization(user, prefs);
            }
            Localizer l = Localization.getLocalizer();
            result = new NewsInfoEvent(searchResult.getList().size(), currentUnprocessedMessages, popupNews, blinkNews, blinkMessages);
            result.message(l, "News");
            result.message(l, "Unprocessed messages");
            UserNewsCache.HOLDER.getInstance().userInfoMap.put(userId, result);
        }
        return result;
    }

    public static void flushCache(Connection con, Set<Integer> userIds) {
        SQLUtils.commitConnection(con);
        for (Integer userId : userIds) {
            UserNewsCache.HOLDER.getInstance().userInfoMap.remove(userId);
        }
    }

    public static void flush(Connection con) {
        HOLDER.flush(con);
    }

    @Override
    protected UserNewsCache newInstance() {
        return new UserNewsCache();
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

