/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.cache;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.cfg.Setup;
import org.bgerp.cache.Cache;
import org.bgerp.cache.CacheHolder;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.dao.user.UserGroupDAO;
import ru.bgcrm.dao.user.UserPermsetDAO;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.model.user.Permset;
import ru.bgcrm.model.user.User;
import ru.bgcrm.model.user.UserGroup;
import ru.bgcrm.util.TimeUtils;

public class UserCache
extends Cache<UserCache> {
    private static final Log log = Log.getLog();
    public static final CacheHolder<UserCache> HOLDER = new CacheHolder<UserCache>(new UserCache());
    public static final ConfigMap EMPTY_PERMISSION = new Preferences();
    private List<User> userList;
    private Map<Integer, User> userMapById;
    private Map<String, User> activeUserMapByLogin;
    private List<Permset> userPermsetList;
    private Map<Integer, Permset> userPermsetMap;
    private List<Group> userGroupList;
    private Map<Integer, Group> userGroupMap;
    private List<Group> userGroupFullTitledList;
    private Map<Integer, Group> userGroupFullTitledMap;
    private Map<Integer, Map<String, ConfigMap>> userPermMap;
    private Map<Integer, List<UserGroup>> userGroupListsMap;

    public static User getUser(int id) {
        return UserCache.HOLDER.getInstance().userMapById.get(id);
    }

    public static Map<Integer, User> getUserMap() {
        return UserCache.HOLDER.getInstance().userMapById;
    }

    public static User getUser(String login) {
        return UserCache.HOLDER.getInstance().activeUserMapByLogin.get(login);
    }

    public static List<User> getUserList() {
        return UserCache.HOLDER.getInstance().userList;
    }

    public static Collection<User> getActiveUsers() {
        return UserCache.HOLDER.getInstance().activeUserMapByLogin.values();
    }

    public static Group getUserGroup(int groupId) {
        return UserCache.HOLDER.getInstance().userGroupMap.get(groupId);
    }

    @Deprecated
    public static int getUserGroupChildCount(int groupId) {
        int result = 0;
        for (Group group : UserCache.HOLDER.getInstance().userGroupList) {
            if (group.getParentId() != groupId) continue;
            ++result;
        }
        return result;
    }

    public static ConfigMap getPerm(int userId, String action) {
        User user = UserCache.getUser(userId);
        String key = "user.permission.check";
        boolean permCheck = Setup.getSetup().getBoolean("user.permission.check", false);
        boolean userPermCheck = user.getConfigMap().getBoolean("user.permission.check", true);
        if (permCheck && userPermCheck && !user.isAdmin()) {
            Map<String, ConfigMap> userPerm = UserCache.HOLDER.getInstance().userPermMap.get(userId);
            if (userPerm != null) {
                ConfigMap map;
                PermissionNode node = PermissionNode.getPermissionNode(action);
                if (node != null) {
                    if (node.isAllowAll()) {
                        return EMPTY_PERMISSION;
                    }
                    action = node.getAction();
                }
                if ((map = userPerm.get(action)) != null) {
                    return map;
                }
            }
            return null;
        }
        return EMPTY_PERMISSION;
    }

    public static List<User> getUserList(Set<Integer> groupIds) {
        ArrayList<User> result = new ArrayList<User>();
        for (User user : UserCache.HOLDER.getInstance().userList) {
            if (CollectionUtils.intersection(groupIds, user.getGroupIds()).size() <= 0) continue;
            result.add(user);
        }
        return result;
    }

    public static Set<Group> getUserGroupChildSet(int groupId) {
        HashSet<Group> resultSet = new HashSet<Group>();
        for (Group group : UserCache.HOLDER.getInstance().userGroupList) {
            if (group.getParentId() != groupId) continue;
            resultSet.add(group);
        }
        return resultSet;
    }

    public static Set<Group> getUserGroupChildFullSet(int groupId) {
        HashSet<Group> resultSet = new HashSet<Group>();
        resultSet.addAll(UserCache.getUserGroupChildSet(groupId));
        if (resultSet.size() > 0) {
            ArrayList<Group> groupList = new ArrayList<Group>(resultSet);
            for (int i = 0; i < groupList.size(); ++i) {
                if (((Group)groupList.get(i)).getChildCount() <= 0) continue;
                resultSet.addAll(UserCache.getUserGroupChildFullSet(((Group)groupList.get(i)).getId()));
            }
        }
        return resultSet;
    }

    public static List<Group> getUserGroupList() {
        return UserCache.HOLDER.getInstance().userGroupList;
    }

    public static List<Group> getUserGroupFullTitledList() {
        return UserCache.HOLDER.getInstance().userGroupFullTitledList;
    }

    @Dynamic
    public static List<IdStringTitle> getUserGroupRoleFullTitledList(int roleId) {
        return UserCache.getUserGroupFullTitledList().stream().map(group -> new IdStringTitle(group.getId() + ":" + roleId, group.getTitle())).collect(Collectors.toList());
    }

    public static Map<Integer, Group> getUserGroupMap() {
        return UserCache.HOLDER.getInstance().userGroupMap;
    }

    public static Map<Integer, Group> getUserGroupFullTitledMap() {
        return UserCache.HOLDER.getInstance().userGroupFullTitledMap;
    }

    public static List<Permset> getUserPermsetList() {
        return UserCache.HOLDER.getInstance().userPermsetList;
    }

    public static Map<Integer, Permset> getUserPermsetMap() {
        return UserCache.HOLDER.getInstance().userPermsetMap;
    }

    public static void flush(Connection con) {
        HOLDER.flush(con);
    }

    public static List<Group> getGroupPath(int id) {
        ArrayList<Group> result = new ArrayList<Group>();
        Group group = new Group();
        group.setParentId(id);
        while (group.getParentId() != 0) {
            group = UserCache.HOLDER.getInstance().userGroupMap.get(group.getParentId());
            result.add(0, group);
        }
        return result;
    }

    public static String getUserGroupWithPath(Map<Integer, Group> groupMap, int id, boolean withId) {
        Group group = groupMap.get(id);
        Object titleWithPath = group.getTitle();
        if (withId) {
            titleWithPath = (String)titleWithPath + " (" + group.getId() + ")";
        }
        while (group.getParentId() > 0) {
            int parentId = group.getParentId();
            if ((group = groupMap.get(parentId)) == null) {
                log.warn("Not found parent group with ID: {}", parentId);
                break;
            }
            if (withId) {
                titleWithPath = group.getTitle() + " (" + group.getId() + ")  / " + (String)titleWithPath;
                continue;
            }
            titleWithPath = group.getTitle() + " / " + (String)titleWithPath;
        }
        return titleWithPath;
    }

    public static List<UserGroup> getUserGroupList(int id) {
        return UserCache.HOLDER.getInstance().userGroupListsMap.get(id) == null ? new ArrayList<UserGroup>() : UserCache.HOLDER.getInstance().userGroupListsMap.get(id);
    }

    public static List<UserGroup> getUserGroupList(int id, Date actualDate) {
        return UserCache.getUserGroupList(id, -1, actualDate);
    }

    public static List<UserGroup> getUserGroupList(int id, int parentId, Date actualDate) {
        ArrayList<UserGroup> resultList = new ArrayList<UserGroup>();
        List<UserGroup> groupList = UserCache.HOLDER.getInstance().userGroupListsMap.get(id);
        if (groupList != null) {
            for (UserGroup item : groupList) {
                Group group = UserCache.HOLDER.getInstance().userGroupMap.get(item.getGroupId());
                if (group == null || parentId >= 0 && group.getParentId() != parentId || actualDate != null && (item.getDateFrom() == null || actualDate.compareTo(item.getDateFrom()) < 0 || item.getDateTo() != null && item.getDateTo().compareTo(actualDate) < 0)) continue;
                resultList.add(item);
            }
        }
        return resultList;
    }

    @Override
    protected UserCache newInstance() {
        UserCache result = new UserCache();
        Setup setup = Setup.getSetup();
        try (Connection con = setup.getDBConnectionFromPool();){
            UserDAO userDAO = new UserDAO(con);
            UserPermsetDAO permsetDAO = new UserPermsetDAO(con);
            UserGroupDAO groupDAO = new UserGroupDAO(con);
            result.userList = userDAO.getUserList();
            result.userMapById = new HashMap<Integer, User>(){

                @Override
                public User get(Object key) {
                    Integer id = (Integer)key;
                    User result = (User)super.get(id);
                    if (result == null) {
                        result = new User();
                        result.setId(id);
                        result.setTitle("??? (" + id + ")");
                    }
                    return result;
                }
            };
            for (User user : result.userList) {
                result.userMapById.put(user.getId(), user);
            }
            result.activeUserMapByLogin = new TreeMap<String, User>();
            for (User user : result.userList) {
                if (user.getStatus() == 1) continue;
                result.activeUserMapByLogin.put(user.getLogin(), user);
            }
            result.userGroupList = groupDAO.getGroupList();
            result.userGroupMap = new HashMap<Integer, Group>(result.userGroupList.size());
            for (Group group : result.userGroupList) {
                result.userGroupMap.put(group.getId(), group);
            }
            result.userGroupFullTitledList = new ArrayList<Group>();
            for (Group group : result.userGroupList) {
                Group fullTitled = group.clone();
                fullTitled.setTitle(UserCache.getUserGroupWithPath(result.userGroupMap, group.getId(), false));
                result.userGroupFullTitledList.add(fullTitled);
            }
            result.userGroupFullTitledMap = new HashMap<Integer, Group>(result.userGroupFullTitledList.size());
            for (Group group : result.userGroupFullTitledList) {
                result.userGroupFullTitledMap.put(group.getId(), group);
            }
            result.userGroupListsMap = userDAO.getAllUserGroups();
            result.userPermsetList = permsetDAO.getPermsetList();
            result.userPermsetMap = new HashMap<Integer, Permset>(result.userPermsetList.size());
            for (Permset permset : result.userPermsetList) {
                result.userPermsetMap.put(permset.getId(), permset);
            }
            Map<Integer, List<Integer>> allUserPermsetIds = userDAO.getAllUserPermsetIds();
            Map<Integer, Set<Integer>> allUserQueueIds = userDAO.getAllUserQueueIds();
            Map<Integer, List<Integer>> allGroupPermsetIds = groupDAO.getAllGroupPermsetIds();
            Map<Integer, Set<Integer>> allGroupQueueIds = groupDAO.getAllGroupQueueIds();
            Map<Integer, Map<String, ConfigMap>> allUserPermById = this.primaryActions(userDAO.getAllUserPerm());
            Map<Integer, Map<String, ConfigMap>> allPermsetPermById = this.primaryActions(permsetDAO.getAllPermsets());
            result.userPermMap = new HashMap<Integer, Map<String, ConfigMap>>();
            for (User user : result.userList) {
                Object group32;
                HashMap<String, ConfigMap> perm = new HashMap<String, ConfigMap>();
                result.userPermMap.put(user.getId(), perm);
                user.setPermsetIds(allUserPermsetIds.get(user.getId()));
                user.setQueueIds(allUserQueueIds.get(user.getId()));
                List<UserGroup> ugList = result.userGroupListsMap.get(user.getId());
                if (ugList != null) {
                    user.setGroupIds(this.getActualUserGroupIdSet(new Date(), ugList));
                }
                ArrayList<Group> userGroupList = new ArrayList<Group>();
                for (Group group : result.userGroupList) {
                    if (!user.getGroupIds().contains(group.getId())) continue;
                    userGroupList.add(group);
                }
                ArrayList<Integer> userPermsetIds = new ArrayList<Integer>();
                for (Object group32 : userGroupList) {
                    List<Integer> list = allGroupPermsetIds.get(((Id)group32).getId());
                    if (list == null) continue;
                    userPermsetIds.addAll(list);
                }
                userPermsetIds.addAll(user.getPermsetIds());
                StringBuilder stringBuilder = new StringBuilder(500);
                group32 = userPermsetIds.iterator();
                while (group32.hasNext()) {
                    Permset permset;
                    Integer n = (Integer)group32.next();
                    Map<String, ConfigMap> permsetPermMap = allPermsetPermById.get(n);
                    if (permsetPermMap != null) {
                        perm.putAll(permsetPermMap);
                    }
                    if ((permset = result.userPermsetMap.get(n)) != null) {
                        stringBuilder.append(permset.getConfig());
                        stringBuilder.append("\n");
                        continue;
                    }
                    log.warn("Not existing permset '{}' is set for a user.", n);
                }
                StringBuilder groupConfig = new StringBuilder(500);
                for (Group group4 : userGroupList) {
                    this.addGroupConfig(result.userGroupMap, group4.getId(), groupConfig);
                }
                user.setConfig(stringBuilder.toString() + groupConfig.toString() + user.getConfig());
                Map<String, ConfigMap> map = allUserPermById.get(user.getId());
                if (map != null) {
                    perm.putAll(map);
                }
                for (Integer groupId : user.getGroupIds()) {
                    Set<Integer> groupQueueIds = allGroupQueueIds.get(groupId);
                    if (groupQueueIds == null) continue;
                    user.getQueueIds().addAll(groupQueueIds);
                }
                log.debug("User id: {}; login: {}; queueIds: {}; config: \n{}; groups: {}; permsetIds: ", user.getId(), user.getLogin(), user.getQueueIds(), user.getConfig(), userGroupList, userPermsetIds);
            }
            User user = new User();
            user.setId(-1);
            user.setTitle("Customer");
            result.userMapById.put(user.getId(), user);
            user = new User();
            user.setId(0);
            user.setTitle("System");
            user.setLogin(setup.get("user.system.login"));
            user.setPassword(setup.get("user.system.pswd"));
            result.userMapById.put(user.getId(), user);
        }
        catch (Exception e) {
            log.error(e);
        }
        return result;
    }

    private Map<Integer, Map<String, ConfigMap>> primaryActions(Map<Integer, Map<String, ConfigMap>> permMapById) {
        for (Map.Entry<Integer, Map<String, ConfigMap>> me : permMapById.entrySet()) {
            me.setValue(PermissionNode.primaryActions(me.getValue()));
        }
        return permMapById;
    }

    private Set<Integer> getActualUserGroupIdSet(Date actualDate, List<UserGroup> ugList) {
        HashSet<Integer> activeGroupSet = new HashSet<Integer>();
        for (UserGroup ug : ugList) {
            if (!TimeUtils.dateInRange(actualDate, ug.getDateFrom(), ug.getDateTo())) continue;
            activeGroupSet.add(ug.getGroupId());
        }
        return activeGroupSet;
    }

    private void addGroupConfig(Map<Integer, Group> userGroupMap, Integer groupId, StringBuilder config) {
        Group group = userGroupMap.get(groupId);
        if (group != null) {
            Integer parentId = group.getParentId();
            if (parentId > 0) {
                this.addGroupConfig(userGroupMap, parentId, config);
            }
            config.append(group.getConfig());
            config.append("\n");
        }
    }
}

