/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.GenericElementXmlHandler;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterContext;

public class IconLabelElementXmlHandler
implements GenericElementXmlHandler {
    private static final IconLabelElementXmlHandler INSTANCE = new IconLabelElementXmlHandler();

    public static IconLabelElementXmlHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void exportElement(JRXmlExporterContext exporterContext, JRGenericPrintElement element) {
        JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
        if (labelPrintText == null) {
            return;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(element.getDefaultStyleProvider());
        frame.setX(element.getX());
        frame.setY(element.getY());
        frame.setWidth(element.getWidth());
        frame.setHeight(element.getHeight());
        frame.setStyle(element.getStyle());
        frame.setBackcolor(element.getBackcolor());
        frame.setForecolor(element.getForecolor());
        frame.setMode(element.getModeValue());
        JRLineBox lineBox = (JRLineBox)element.getParameterValue("lineBox");
        if (lineBox != null) {
            frame.copyBox(lineBox);
        }
        frame.addElement(labelPrintText);
        JRPrintText iconPrintText = (JRPrintText)element.getParameterValue("iconTextElement");
        if (iconPrintText != null) {
            frame.addElement(iconPrintText);
        }
        JRXmlExporter exporter = (JRXmlExporter)exporterContext.getExporterRef();
        try {
            exporter.exportElement(frame);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

