/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Objects;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResource;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;

public class SFTPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private final SFTPEngine engine;
    private volatile LocalFileFilter uploadFilter;
    private volatile RemoteResourceFilter downloadFilter;
    private volatile boolean preserveAttributes = true;

    public SFTPFileTransfer(SFTPEngine engine) {
        super(engine.getLoggerFactory());
        this.engine = engine;
    }

    public boolean getPreserveAttributes() {
        return this.preserveAttributes;
    }

    public void setPreserveAttributes(boolean preserveAttributes) {
        this.preserveAttributes = preserveAttributes;
    }

    @Override
    public void upload(String source, String dest) throws IOException {
        this.upload(new FileSystemFile(source), dest);
    }

    @Override
    public void download(String source, String dest) throws IOException {
        this.download(source, new FileSystemFile(dest));
    }

    @Override
    public void upload(LocalSourceFile localFile, String remotePath) throws IOException {
        new Uploader(localFile, remotePath).upload(this.getTransferListener());
    }

    @Override
    public void download(String source, LocalDestFile dest) throws IOException {
        PathComponents pathComponents = this.engine.getPathHelper().getComponents(source);
        FileAttributes attributes = this.engine.stat(source);
        new Downloader().download(this.getTransferListener(), new RemoteResourceInfo(pathComponents, attributes), dest);
    }

    public void setUploadFilter(LocalFileFilter uploadFilter) {
        this.uploadFilter = uploadFilter;
    }

    public void setDownloadFilter(RemoteResourceFilter downloadFilter) {
        this.downloadFilter = downloadFilter;
    }

    public LocalFileFilter getUploadFilter() {
        return this.uploadFilter;
    }

    public RemoteResourceFilter getDownloadFilter() {
        return this.downloadFilter;
    }

    private class Uploader {
        private final LocalSourceFile source;
        private final String remote;

        private Uploader(LocalSourceFile source, String remote) {
            this.source = source;
            this.remote = remote;
        }

        private void upload(TransferListener listener) throws IOException {
            if (this.source.isDirectory()) {
                this.makeDirIfNotExists(this.remote);
                this.uploadDir(listener.directory(this.source.getName()), this.source, this.remote);
                this.setAttributes(this.source, this.remote);
            } else if (this.source.isFile() && this.isDirectory(this.remote)) {
                String adjustedRemote = SFTPFileTransfer.this.engine.getPathHelper().adjustForParent(this.remote, this.source.getName());
                this.uploadFile(listener.file(this.source.getName(), this.source.getLength()), this.source, adjustedRemote);
                this.setAttributes(this.source, adjustedRemote);
            } else if (this.source.isFile()) {
                this.uploadFile(listener.file(this.source.getName(), this.source.getLength()), this.source, this.remote);
                this.setAttributes(this.source, this.remote);
            } else {
                throw new IOException(this.source + " is not a file or directory");
            }
        }

        private void upload(TransferListener listener, LocalSourceFile local, String remote) throws IOException {
            String adjustedPath;
            if (local.isDirectory()) {
                adjustedPath = this.uploadDir(listener.directory(local.getName()), local, remote);
            } else if (local.isFile()) {
                adjustedPath = this.uploadFile(listener.file(local.getName(), local.getLength()), local, remote);
            } else {
                throw new IOException(local + " is not a file or directory");
            }
            this.setAttributes(local, adjustedPath);
        }

        private void setAttributes(LocalSourceFile local, String remotePath) throws IOException {
            if (SFTPFileTransfer.this.getPreserveAttributes()) {
                SFTPFileTransfer.this.engine.setAttributes(remotePath, this.getAttributes(local));
            }
        }

        private String uploadDir(TransferListener listener, LocalSourceFile local, String remote) throws IOException {
            this.makeDirIfNotExists(remote);
            for (LocalSourceFile localSourceFile : local.getChildren(SFTPFileTransfer.this.getUploadFilter())) {
                this.upload(listener, localSourceFile, SFTPFileTransfer.this.engine.getPathHelper().adjustForParent(remote, localSourceFile.getName()));
            }
            return remote;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String uploadFile(StreamCopier.Listener listener, LocalSourceFile local, String remote) throws IOException {
            String adjusted = this.prepareFile(local, remote);
            RemoteResource rf = null;
            InputStream fis = null;
            RemoteFile.RemoteFileOutputStream rfos = null;
            try {
                rf = SFTPFileTransfer.this.engine.open(adjusted, EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC));
                fis = local.getInputStream();
                RemoteResource remoteResource = rf;
                Objects.requireNonNull(remoteResource);
                rfos = new RemoteFile.RemoteFileOutputStream((RemoteFile)remoteResource, 0L, 16);
                new StreamCopier(fis, rfos, SFTPFileTransfer.this.engine.getLoggerFactory()).bufSize(SFTPFileTransfer.this.engine.getSubsystem().getRemoteMaxPacketSize() - ((RemoteFile)rf).getOutgoingPacketOverhead()).keepFlushing(false).listener(listener).copy();
            }
            finally {
                if (rf != null) {
                    try {
                        rf.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (rfos != null) {
                    try {
                        rfos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return adjusted;
        }

        private boolean makeDirIfNotExists(String remote) throws IOException {
            try {
                FileAttributes attrs = SFTPFileTransfer.this.engine.stat(remote);
                if (attrs.getMode().getType() != FileMode.Type.DIRECTORY) {
                    throw new IOException(remote + " exists and should be a directory, but was a " + (Object)((Object)attrs.getMode().getType()));
                }
                return false;
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("makeDir: {} does not exist, creating", (Object)remote);
                    SFTPFileTransfer.this.engine.makeDir(remote);
                    return true;
                }
                throw e;
            }
        }

        private boolean isDirectory(String remote) throws IOException {
            try {
                FileAttributes attrs = SFTPFileTransfer.this.engine.stat(remote);
                return attrs.getMode().getType() == FileMode.Type.DIRECTORY;
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("isDir: {} does not exist", (Object)remote);
                    return false;
                }
                throw e;
            }
        }

        private String prepareFile(LocalSourceFile local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.engine.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeFile: {} does not exist", (Object)remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                throw new IOException("Trying to upload file " + local.getName() + " to path " + remote + " but that is a directory");
            }
            SFTPFileTransfer.this.log.debug("probeFile: {} is a {} file that will be replaced", (Object)remote, (Object)attrs.getMode().getType());
            return remote;
        }

        private FileAttributes getAttributes(LocalSourceFile local) throws IOException {
            FileAttributes.Builder builder = new FileAttributes.Builder().withPermissions(local.getPermissions());
            if (local.providesAtimeMtime()) {
                builder.withAtimeMtime(local.getLastAccessTime(), local.getLastModifiedTime());
            }
            return builder.build();
        }
    }

    private class Downloader {
        private Downloader() {
        }

        private void download(TransferListener listener, RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjustedFile;
            switch (remote.getAttributes().getType()) {
                case DIRECTORY: {
                    adjustedFile = this.downloadDir(listener.directory(remote.getName()), remote, local);
                    break;
                }
                case UNKNOWN: {
                    SFTPFileTransfer.this.log.warn("Server did not supply information about the type of file at `{}` -- assuming it is a regular file!", (Object)remote.getPath());
                }
                case REGULAR: {
                    adjustedFile = this.downloadFile(listener.file(remote.getName(), remote.getAttributes().getSize()), remote, local);
                    break;
                }
                default: {
                    throw new IOException(remote + " is not a regular file or directory");
                }
            }
            if (SFTPFileTransfer.this.getPreserveAttributes()) {
                this.copyAttributes(remote, adjustedFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDestFile downloadDir(TransferListener listener, RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjusted = local.getTargetDirectory(remote.getName());
            try (RemoteDirectory rd = SFTPFileTransfer.this.engine.openDir(remote.getPath());){
                for (RemoteResourceInfo rri : rd.scan(SFTPFileTransfer.this.getDownloadFilter())) {
                    this.download(listener, rri, adjusted.getChild(rri.getName()));
                }
            }
            return adjusted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDestFile downloadFile(StreamCopier.Listener listener, RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjusted = local.getTargetFile(remote.getName());
            try (RemoteFile rf = SFTPFileTransfer.this.engine.open(remote.getPath());){
                RemoteFile remoteFile = rf;
                Objects.requireNonNull(remoteFile);
                RemoteFile.ReadAheadRemoteFileInputStream rfis = new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile, 16);
                OutputStream os = adjusted.getOutputStream();
                try {
                    new StreamCopier(rfis, os, SFTPFileTransfer.this.engine.getLoggerFactory()).bufSize(SFTPFileTransfer.this.engine.getSubsystem().getLocalMaxPacketSize()).keepFlushing(false).listener(listener).copy();
                }
                finally {
                    rfis.close();
                    os.close();
                }
            }
            return adjusted;
        }

        private void copyAttributes(RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            FileAttributes attrs = remote.getAttributes();
            local.setPermissions(attrs.getMode().getPermissionsMask());
            if (attrs.has(FileAttributes.Flag.ACMODTIME)) {
                local.setLastAccessedTime(attrs.getAtime());
                local.setLastModifiedTime(attrs.getMtime());
            }
        }
    }
}

