/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.model.PeriodSet;
import ru.bgcrm.util.Utils;

public class TimeUtils {
    public static final String CONF_KEY_FORMAT_YMD = "format.ymd";
    public static final String CONF_KEY_FORMAT_YMDH = "format.ymdh";
    public static final String CONF_KEY_FORMAT_YMDHM = "format.ymdhm";
    public static final String CONF_KEY_FORMAT_YMDHMS = "format.ymdhms";
    public static final String PATTERN_DDMMYYYY = "dd.MM.yyyy";
    public static final String PATTERN_YYYYMMDD = "yyyy-MM-dd";
    public static final String PATTERN_YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DDMMYYYYHHMMSS = "dd.MM.yyyy HH:mm:ss";
    public static final String FORMAT_TYPE_YMD = "ymd";
    public static final String FORMAT_TYPE_YMDH = "ymdh";
    public static final String FORMAT_TYPE_YMDHM = "ymdhm";
    public static final String FORMAT_TYPE_YMDHMS = "ymdhms";

    public static String getTypeFormat(String type) {
        switch (type) {
            case "ymd": {
                return Utils.getSystemProperty(CONF_KEY_FORMAT_YMD, PATTERN_DDMMYYYY);
            }
            case "ymdh": {
                return Utils.getSystemProperty(CONF_KEY_FORMAT_YMDH, "dd.MM.yyyy HH");
            }
            case "ymdhm": {
                return Utils.getSystemProperty(CONF_KEY_FORMAT_YMDHM, "dd.MM.yyyy HH:mm");
            }
            case "ymdhms": {
                return Utils.getSystemProperty(CONF_KEY_FORMAT_YMDHMS, PATTERN_DDMMYYYYHHMMSS);
            }
        }
        return type;
    }

    public static final String format(Date date, String patternType) {
        SimpleDateFormat format = new SimpleDateFormat(TimeUtils.getTypeFormat(patternType));
        return date == null ? "" : format.format(date);
    }

    public static final String formatSqlDate(Date date) {
        return new SimpleDateFormat("''yyyy-MM-dd''").format(date);
    }

    public static final String format(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public static final String formatPeriod(Date dateFrom, Date dateTo, String patternType) {
        return TimeUtils.format(dateFrom, patternType) + "-" + TimeUtils.format(dateTo, patternType);
    }

    public static final String formatPeriod(Date date1, Date date2) {
        return TimeUtils.format(date1, FORMAT_TYPE_YMD) + "-" + TimeUtils.format(date2, FORMAT_TYPE_YMD);
    }

    public static final Date parse(String date, String patternType) {
        SimpleDateFormat format = new SimpleDateFormat(TimeUtils.getTypeFormat(patternType));
        try {
            return format.parse(date);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Date parse(String date, String patternType, Date defaultValue) {
        SimpleDateFormat format = new SimpleDateFormat(TimeUtils.getTypeFormat(patternType));
        try {
            return format.parse(date);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static final void parsePeriod(String period, PeriodSet periodSet) {
        TimeUtils.parsePeriod(period, FORMAT_TYPE_YMD, periodSet);
    }

    public static final void parsePeriod(String period, String patternType, PeriodSet periodSet) {
        String[] tokens = period.split("-");
        if (tokens.length >= 1) {
            periodSet.setDateFrom(TimeUtils.parse(tokens[0].trim(), patternType));
        }
        if (tokens.length > 1) {
            periodSet.setDateTo(TimeUtils.parse(tokens[1].trim(), patternType));
        }
    }

    public static final Date convertCalendarToDate(Calendar calendar) {
        Date result = null;
        if (calendar != null) {
            result = calendar.getTime();
        }
        return result;
    }

    public static final Date convertSqlDateToDate(java.sql.Date date) {
        Date outDate = null;
        if (date != null) {
            outDate = new Date(date.getTime());
        }
        return outDate;
    }

    public static final Calendar convertDateToCalendar(Date date) {
        GregorianCalendar result = null;
        if (date != null) {
            result = new GregorianCalendar();
            result.setTime(date);
        }
        return result;
    }

    public static final Calendar convertTimestampToCalendar(Timestamp time) {
        GregorianCalendar result = null;
        if (time != null) {
            result = new GregorianCalendar();
            result.setTimeInMillis(time.getTime());
        }
        return result;
    }

    public static final java.sql.Date convertDateToSqlDate(Date date) {
        return date != null ? new java.sql.Date(date.getTime()) : null;
    }

    public static final Timestamp convertCalendarToTimestamp(Calendar calendar) {
        Timestamp result = null;
        if (calendar != null) {
            result = new Timestamp(calendar.getTimeInMillis());
        }
        return result;
    }

    public static final Timestamp convertLongToTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static final int daysDelta(Date dayFrom, Date dayTo) {
        long time1 = dayFrom.getTime();
        long time2 = dayTo.getTime();
        int days1 = (int)(time1 / 86400000L);
        int days2 = (int)(time2 / 86400000L);
        return days2 - days1;
    }

    public static final int getDayOfWeekPosition(Date date) {
        Calendar calendar = TimeUtils.convertDateToCalendar(date);
        return (calendar.get(7) - 2 + 7) % 7 + 1;
    }

    public static boolean dateBefore(Date date1, Date date2) {
        return TimeUtils.dateBefore(TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    private static boolean dateBefore(Calendar date1, Calendar date2) {
        if (date1.get(1) == date2.get(1)) {
            return date1.get(6) < date2.get(6);
        }
        return date1.get(1) < date2.get(1);
    }

    public static boolean dateEqual(Date date1, Date date2) {
        return TimeUtils.dateEqual(TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    private static boolean dateEqual(Calendar date1, Calendar date2) {
        return date1 == date2 || date1 != null && date2 != null && date1.get(6) == date2.get(6) && date1.get(1) == date2.get(1);
    }

    public static boolean dateBeforeOrEq(Calendar date1, Calendar date2) {
        return TimeUtils.dateBefore(date1, date2) || TimeUtils.dateEqual(date1, date2);
    }

    public static boolean dateBeforeOrEq(Date date1, Date date2) {
        return TimeUtils.dateBeforeOrEq(TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    public static final boolean dateInRange(Calendar checking, Calendar date1, Calendar date2) {
        return !(checking == null || date1 != null && !TimeUtils.dateBeforeOrEq(date1, checking) || date2 != null && !TimeUtils.dateBeforeOrEq(checking, date2));
    }

    public static final boolean dateInRange(Date checking, Date date1, Date date2) {
        return TimeUtils.dateInRange(TimeUtils.convertDateToCalendar(checking), TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    public static final boolean periodInRange(Calendar checkingDate1, Calendar checkingDate2, Calendar date1, Calendar date2) {
        boolean result;
        boolean bl = result = date1 == null || checkingDate1 != null && TimeUtils.dateBeforeOrEq(date1, checkingDate1);
        if (result) {
            result = date2 == null || checkingDate2 != null && TimeUtils.dateBeforeOrEq(checkingDate2, date2);
        }
        return result;
    }

    public static boolean checkDateIntervalsIntersection(Calendar date1, Calendar date2, Calendar dateFrom, Calendar dateTo) {
        if (date1 == null && date2 == null || dateFrom == null && dateTo == null) {
            return true;
        }
        return !(date1 != null && dateTo != null && !TimeUtils.dateBefore(date1, dateTo) || dateFrom != null && date2 != null && !TimeUtils.dateBefore(dateFrom, date2));
    }

    public static final void moveToEndOfMonth(Calendar date) {
        if (date != null) {
            date.add(2, 1);
            date.set(5, 1);
            date.add(11, -1);
        }
    }

    public static final void moveToStartNextDay(Calendar date) {
        if (date != null) {
            date.add(6, 1);
            date.set(11, 0);
            date.set(12, 0);
            date.set(13, 0);
            date.set(14, 0);
        }
    }

    @Deprecated
    public static final Calendar clear_HOUR_MIN_MIL_SEC(Calendar time) {
        TimeUtils.clear_MIN_MIL_SEC(time);
        time.set(11, 0);
        return time;
    }

    private static final Calendar clear_MIN_MIL_SEC(Calendar time) {
        time.set(14, 0);
        time.set(13, 0);
        time.set(12, 0);
        return time;
    }

    @Deprecated
    public static final Date clear_HOUR_MIN_MIL_SEC(Date time) {
        if (time != null) {
            return TimeUtils.clear_HOUR_MIN_MIL_SEC(TimeUtils.convertDateToCalendar(time)).getTime();
        }
        return time;
    }

    public static final Date getEndMonth(Date date) {
        if (date == null) {
            return null;
        }
        return TimeConvert.toDate(TimeConvert.toYearMonth(date).atEndOfMonth());
    }

    public static final Calendar getNextDay(Calendar date) {
        date = (Calendar)date.clone();
        TimeUtils.moveToStartNextDay(date);
        return date;
    }

    public static final Calendar getPrevDay(Calendar date) {
        date = (Calendar)date.clone();
        date.add(6, -1);
        return date;
    }

    public static final Date getNextDay(Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getNextDay(TimeUtils.convertDateToCalendar(date)));
    }

    public static final Date getPrevDay(Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getPrevDay(TimeUtils.convertDateToCalendar(date)));
    }

    public static final Date getPrevMonth() {
        return Date.from(YearMonth.now().minusMonths(1L).atDay(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    @Deprecated
    public static String getShortDateName(Date date) {
        String[] shortDayNames = new String[]{"\u043f\u043d", "\u0432\u0442", "\u0441\u0440", "\u0447\u0442", "\u043f\u0442", "\u0441\u0431", "\u0432\u0441"};
        return shortDayNames[TimeUtils.getDayOfWeekPosition(date) - 1];
    }

    public static Date timezoneChange(Date time, TimeZone fromTz, TimeZone toTz) {
        if (time == null) {
            return null;
        }
        return new Date(time.getTime() - (long)toTz.getRawOffset() + (long)fromTz.getRawOffset());
    }
}

