/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;
import org.bgerp.action.FileAction;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.dao.customer.CustomerLogDAO;
import org.bgerp.dao.param.ParamLogDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.ProcessLogDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.file.FileData;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValue;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.dao.EntityLogDAO;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.event.DateChangingEvent;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.ParamChangingEvent;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.param.ParameterLogItem;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.param.config.ListParamConfig;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.struts.form.Response;
import ru.bgcrm.util.AddressUtils;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/parameter")
public class ParameterAction
extends BaseAction {
    protected static final String PATH_JSP = "/WEB-INF/jspf/user/parameter";

    public ActionForward parameterLog(DynActionForm form, ConnectionSet conSet) throws Exception {
        int id = form.getId();
        String objectType = form.getParam("objectType");
        List<Parameter> paramList = ParameterCache.getObjectTypeParameterList(objectType);
        boolean offEncrypt = form.getPermission().getBoolean("offEncrypt", false);
        form.setResponseData("log", new ParamLogDAO(conSet.getSlaveConnection()).getHistory(id, paramList, offEncrypt, new Pageable<ParameterLogItem>(form)));
        return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/log.jsp");
    }

    public ActionForward entityLog(DynActionForm form, ConnectionSet con) throws Exception {
        int id = form.getId();
        String type = form.getParam("type");
        EntityLogDAO dao = null;
        if (type.equals("process")) {
            dao = new ProcessLogDAO(con.getSlaveConnection());
        } else if (type.equals("customer")) {
            dao = new CustomerLogDAO(con.getSlaveConnection());
        }
        form.setResponseData("log", dao.getHistory(id));
        return this.html(con, form, "/WEB-INF/jspf/entity_log.jsp");
    }

    public ActionForward parameterList(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.parameterListInternal(form, conSet);
        return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/list.jsp");
    }

    protected void parameterListInternal(DynActionForm form, ConnectionSet conSet) throws Exception {
        int id = form.getId();
        String objectType = form.getParam("objectType");
        int parameterGroupId = form.getParamInt("parameterGroup", -1);
        List<Integer> pids = form.getParamValuesList("paramId");
        List<Parameter> paramList = null;
        paramList = pids.size() > 0 ? ParameterCache.getParameterList(pids) : ParameterCache.getObjectTypeParameterList(objectType, parameterGroupId);
        Set<Object> hideParamIds = Collections.emptySet();
        if ("process".equals(objectType)) {
            Process process = new ProcessDAO(conSet.getConnection()).getProcessOrThrow(id);
            ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
            hideParamIds = Utils.toIntegerSet(type.getProperties().getConfigMap().get("hideParamIdsInStatus." + process.getStatusId(), ""));
            if (pids.size() == 0) {
                paramList = Utils.getObjectList(ParameterCache.getParameterMap(), type.getProperties().getParameterIds());
            }
            for (Map.Entry<Integer, ConfigMap> entry : type.getProperties().getConfigMap().subIndexed("showParam.").entrySet()) {
                String expression = entry.getValue().get("checkExpression");
                Map<String, Object> context = Expression.context(conSet, form, null, process);
                if (!Utils.notBlankString(expression) || new Expression(context).executeCheck(expression)) continue;
                hideParamIds.add(entry.getKey());
            }
        }
        Set<Integer> restrictedParamIds = Utils.toIntegerSet(form.getPermission().get("restrictedParameterIds"));
        Set<Integer> allowedParamIds = Utils.toIntegerSet(form.getPermission().get("parameterIds"));
        Set<String> allowedTags = Utils.toSet(form.getPermission().get("tags"));
        for (int i = 0; i < paramList.size(); ++i) {
            Parameter param = paramList.get(i);
            Set<String> tags = Utils.toSet(param.getConfigMap().get("tagsShow", param.getConfigMap().get("tags")));
            int paramId = param.getId();
            if (!(hideParamIds.contains(paramId) || !restrictedParamIds.isEmpty() && restrictedParamIds.contains(paramId) || !allowedParamIds.isEmpty() && !allowedParamIds.contains(paramId)) && (tags.size() <= 0 || CollectionUtils.intersection(tags, allowedTags).size() != 0)) continue;
            paramList.remove(i);
            --i;
        }
        boolean offEncryption = form.getPermission().getBoolean("offEncrypt", false);
        List<ParameterValue> parameterValuePairList = new ParamValueDAO(conSet.getConnection()).loadParameters(paramList, id, offEncryption);
        form.setResponseData("list", parameterValuePairList);
    }

    public ActionForward parameterGet(DynActionForm form, ConnectionSet conSet) throws Exception {
        int id = form.getId();
        int paramId = Utils.parseInt(form.getParam("paramId"));
        HttpServletRequest request = form.getHttpRequest();
        HttpServletResponse response = form.getHttpResponse();
        ParamValueDAO paramDAO = new ParamValueDAO(conSet.getConnection());
        AddressDAO addressDAO = new AddressDAO(conSet.getConnection());
        Parameter parameter = ParameterCache.getParameter(paramId);
        if (parameter == null) {
            throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.", new Object[0]);
        }
        Response resp = form.getResponse();
        request.setAttribute("parameter", (Object)parameter);
        boolean offEncryption = form.getPermission().getBoolean("offEncrypt", false);
        if ("encrypted".equals(parameter.getConfigMap().get("encrypt")) && !offEncryption && ("text".equals(parameter.getType()) || "blob".equals(parameter.getType()))) {
            resp.setData("value", this.l.l("<\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415 \u0417\u0410\u0428\u0418\u0424\u0420\u041e\u0412\u0410\u041d\u041e>", new Object[0]));
            return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/edit.jsp");
        }
        switch (Parameter.Type.of(parameter.getType())) {
            case ADDRESS: {
                int houseId;
                AddressHouse house;
                ParameterAddressValue addressValue = paramDAO.getParamAddress(id, paramId, Utils.parseInt(form.getParam("position")));
                if (addressValue != null && (house = addressDAO.getAddressHouse(houseId = addressValue.getHouseId(), true, true, true)) != null) {
                    resp.setData("house", house);
                }
                resp.setData("address", addressValue);
                break;
            }
            case BLOB: {
                resp.setData("value", paramDAO.getParamBlob(id, paramId));
                break;
            }
            case DATE: 
            case DATETIME: {
                if (Utils.notBlankString(form.getParam("newDate"))) {
                    EventProcessor.processEvent(new DateChangingEvent(form, id, parameter, TimeUtils.parse(form.getParam("newDate"), "ymd")), conSet);
                    EventProcessor.processEvent(new DateChangingEvent(form, id, parameter, TimeUtils.parse(form.getParam("newDate"), "ymd")), conSet);
                }
                if ("date".equals(parameter.getType())) {
                    resp.setData("value", paramDAO.getParamDate(id, paramId));
                    break;
                }
                if (!"datetime".equals(parameter.getType())) break;
                resp.setData("value", paramDAO.getParamDateTime(id, paramId));
                break;
            }
            case EMAIL: {
                resp.setData("values", paramDAO.getParamEmail(id, paramId).values());
                break;
            }
            case FILE: {
                response.setContentType("image/jpeg");
                FileData fileData = paramDAO.getParamFile(id, paramId, 1);
                File file = new FileDataDAO(conSet.getConnection()).getFile(fileData);
                FileInputStream in = new FileInputStream(file);
                ServletOutputStream out = response.getOutputStream();
                byte[] outputByte = new byte[4096];
                while (in.read(outputByte, 0, 4096) != -1) {
                    out.write(outputByte, 0, 4096);
                }
                in.close();
                return null;
            }
            case LIST: {
                resp.setData("values", paramDAO.getParamListWithComments(id, paramId));
                this.listValues(form, parameter);
                request.setAttribute("listParamConfig", (Object)parameter.getConfigMap().getConfig(ListParamConfig.class));
                break;
            }
            case LISTCOUNT: {
                resp.setData("values", paramDAO.getParamListCount(id, paramId));
                this.listValues(form, parameter);
                break;
            }
            case MONEY: {
                resp.setData("value", paramDAO.getParamMoney(id, paramId));
                break;
            }
            case PHONE: {
                resp.setData("value", paramDAO.getParamPhone(id, paramId));
                break;
            }
            case TEXT: {
                resp.setData("value", paramDAO.getParamText(id, paramId));
                break;
            }
            case TREE: {
                resp.setData("values", paramDAO.getParamTree(id, paramId));
                resp.setData("treeRootNode", ParameterCache.getTreeParamRootNode(parameter));
                break;
            }
            case TREECOUNT: {
                resp.setData("values", paramDAO.getParamTreeCount(id, paramId));
                resp.setData("treeValues", ParameterCache.getTreeParamValues(paramId));
                resp.setData("treeRootNode", ParameterCache.getTreeParamRootNode(parameter));
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/edit.jsp");
    }

    private void listValues(DynActionForm form, Parameter param) {
        List listValues = ParameterCache.getListParamValues(param).stream().filter(item -> !item.getTitle().startsWith("@")).collect(Collectors.toList());
        String valuesSortMode = param.getConfigMap().get("sort.mode", "");
        if (valuesSortMode.equals("byTitle")) {
            Collections.sort(listValues, new Comparator<IdTitle>(this){

                @Override
                public int compare(IdTitle first, IdTitle second) {
                    return first.getTitle().compareTo(second.getTitle());
                }
            });
        }
        form.setResponseData("listValues", listValues);
    }

    public ActionForward parameterUpdate(DynActionForm form, Connection con) throws Exception {
        Object requireParam;
        Set<String> allowedTags;
        int id = form.getId();
        int paramId = Utils.parseInt(form.getParam("paramId"));
        int userId = form.getUserId();
        Set<Integer> restrictedParamIds = Utils.toIntegerSet(form.getPermission().get("restrictedParameterIds"));
        Set<Integer> allowedParamIds = Utils.toIntegerSet(form.getPermission().get("parameterIds"));
        if (!restrictedParamIds.isEmpty() && restrictedParamIds.contains(paramId)) {
            throw new BGMessageException("Parameter with ID {} is disallowed to edit", paramId);
        }
        if (!allowedParamIds.isEmpty() && !allowedParamIds.contains(paramId)) {
            throw new BGMessageException("Parameter with ID {} is disallowed to edit", paramId);
        }
        ParamValueDAO paramValueDAO = new ParamValueDAO(con, true, userId);
        Parameter parameter = ParameterCache.getParameter(paramId);
        if (parameter == null) {
            throw new BGMessageException("Parameter not found", new Object[0]);
        }
        Set<String> tags = Utils.toSet(parameter.getConfigMap().get("tags"));
        if (tags.size() > 0 && CollectionUtils.intersection(tags, allowedTags = Utils.toSet(form.getPermission().get("tags"))).size() == 0) {
            throw new BGMessageException("The tagged parameter is disallowed to edit", new Object[0]);
        }
        String requireParamName = "requireBeforeFillParamIds";
        Set<Integer> requireBeforeParams = Utils.toIntegerSet(parameter.getConfigMap().get("requireBeforeFillParamIds", ""));
        for (int requireParamId : requireBeforeParams) {
            requireParam = ParameterCache.getParameter(requireParamId);
            if (requireParam == null) {
                throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + requireParamId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0423\u043a\u0430\u0437\u0430\u043d \u0432 requireBeforeFillParamIds \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430.", new Object[0]);
            }
            if (paramValueDAO.isParameterFilled(id, (Parameter)requireParam)) continue;
            throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + ((IdTitle)requireParam).getTitle() + "' \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d.", new Object[0]);
        }
        String requireEmptyParamName = "requireBeforeEmptyParamIds";
        Set<Integer> requireEmptyBeforeParams = Utils.toIntegerSet(parameter.getConfigMap().get("requireBeforeEmptyParamIds", ""));
        requireParam = requireEmptyBeforeParams.iterator();
        while (requireParam.hasNext()) {
            int requireParamId = (Integer)requireParam.next();
            Parameter requireParam2 = ParameterCache.getParameter(requireParamId);
            if (requireParam2 == null) {
                throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + requireParamId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0423\u043a\u0430\u0437\u0430\u043d \u0432 requireBeforeEmptyParamIds \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430.", new Object[0]);
            }
            if (!paramValueDAO.isParameterFilled(id, requireParam2)) continue;
            throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + requireParam2.getTitle() + "' \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d.", new Object[0]);
        }
        Object paramValue = null;
        switch (Parameter.Type.of(parameter.getType())) {
            case ADDRESS: {
                ParameterAddressValue addressValue = null;
                int houseId = form.getParamInt("houseId", -1);
                int streetId = form.getParamInt("streetId", -1);
                String house = form.getParam("house");
                int position = Utils.parseInt(form.getParam("position"));
                if (houseId <= 0 && house != null) {
                    AddressDAO addressDAO = new AddressDAO(con);
                    List<Integer> houses = addressDAO.getHouseIdsByStreetAndHouse(streetId, house, null);
                    if (houses.size() == 1) {
                        houseId = houses.get(0);
                    } else {
                        throw new BGMessageException("house.not.found", new Object[0]);
                    }
                }
                if (houseId > 0) {
                    addressValue = new ParameterAddressValue();
                    addressValue.setHouseId(houseId);
                    if (addressValue.getHouseId() <= 0) {
                        throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u043c.", new Object[0]);
                    }
                    addressValue.setFlat(form.getParam("flat", ""));
                    addressValue.setRoom(form.getParam("room", ""));
                    addressValue.setPod(Utils.parseInt(form.getParam("pod"), -1));
                    String floor = form.getParam("floor");
                    addressValue.setFloor(Utils.notBlankString(floor) ? Integer.valueOf(Integer.parseInt(floor)) : null);
                    addressValue.setComment(form.getParam("comment", ""));
                    addressValue.setValue(AddressUtils.buildAddressValue(addressValue, con));
                }
                paramValue = addressValue;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamAddress(id, paramId, position, addressValue);
                break;
            }
            case BLOB: {
                paramValue = form.getParam("value");
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamBlob(id, paramId, (String)paramValue);
                break;
            }
            case DATE: {
                String value = form.getParam("value");
                paramValue = TimeUtils.parse(value, "ymd");
                if (Utils.notBlankString(value) && (paramValue == null || TimeUtils.convertDateToCalendar((Date)paramValue).get(1) >= 10000)) {
                    throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442.", new Object[0]);
                }
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamDate(id, paramId, (Date)paramValue);
                break;
            }
            case DATETIME: {
                String value = form.getParam("value");
                paramValue = TimeUtils.parse(value, parameter.getConfigMap().get("type", "ymd"));
                if (Utils.notBlankString(value) && (paramValue == null || TimeUtils.convertDateToCalendar((Date)paramValue).get(1) >= 10000)) {
                    throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442.", new Object[0]);
                }
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamDateTime(id, paramId, (Date)paramValue);
                break;
            }
            case EMAIL: {
                ArrayList<ParameterEmailValue> values = new ArrayList<ParameterEmailValue>();
                Iterator<String> emails = form.getParamValuesListStr("address").iterator();
                Iterator<String> comments = form.getParamValuesListStr("name").iterator();
                while (emails.hasNext()) {
                    values.add(new ParameterEmailValue(emails.next(), comments.hasNext() ? comments.next() : ""));
                }
                paramValue = values;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamEmail(id, paramId, values);
                break;
            }
            case FILE: {
                FormFile file = form.getFile();
                FileAction.uploadFileCheck(file);
                int position = form.getParamInt("position", 0);
                FileData fileData = null;
                if (file != null) {
                    this.log.debug("Uploading file: {}, type: {}", file.getFileName(), file.getContentType());
                    fileData = new FileData();
                    FileDataDAO fileDataDAO = new FileDataDAO(con);
                    fileData.setTitle(file.getFileName());
                    try (FileOutputStream fos = fileDataDAO.add(fileData);){
                        fos.write(file.getFileData());
                    }
                }
                paramValue = fileData;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamFile(id, paramId, position, fileData);
                break;
            }
            case LIST: {
                ListParamConfig config = parameter.getConfigMap().getConfig(ListParamConfig.class);
                HashMap<Integer, String> values = new HashMap<Integer, String>();
                for (String value : form.getParamValuesStr("value")) {
                    int val = Utils.parseInt(StringUtils.substringBefore((String)value, (String)":"));
                    String comment = Utils.maskNull(StringUtils.substringAfter((String)value, (String)":"));
                    if (val <= 0) continue;
                    if (config.getCommentValues().get(val) == null) {
                        comment = "";
                    } else if (config.getNeedCommentValues().get(val) != null && Utils.isBlankString(comment)) {
                        throw new BGMessageException("Not defined mandatory comment for a value", new Object[0]);
                    }
                    values.put(val, comment);
                }
                paramValue = values.keySet();
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamListWithComments(id, paramId, values);
                break;
            }
            case LISTCOUNT: {
                List<String> emptyValues = List.of("");
                List<String> itemIds = form.getParamValuesListStr("itemId");
                List<String> itemCounts = form.getParamValuesListStr("itemCount");
                TreeMap<Integer, BigDecimal> values = new TreeMap<Integer, BigDecimal>();
                if (!itemIds.equals(emptyValues) || !itemCounts.equals(emptyValues)) {
                    for (int i = 0; i < itemIds.size() && i < itemCounts.size(); ++i) {
                        Integer itemId = Utils.parseInt(itemIds.get(i));
                        BigDecimal itemCount = Utils.parseBigDecimal(itemCounts.get(i));
                        if (itemId <= 0 || BigDecimal.ZERO.equals(itemCount)) {
                            throw new BGIllegalArgumentException("itemCount");
                        }
                        values.put(itemId, itemCount);
                    }
                }
                paramValue = values;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamListCount(id, paramId, values);
                break;
            }
            case MONEY: {
                paramValue = Utils.parseBigDecimal(form.getParam("value"));
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamMoney(id, paramId, (BigDecimal)paramValue);
                break;
            }
            case PHONE: {
                ParameterPhoneValue phoneValue = new ParameterPhoneValue();
                Iterator<String> phones = form.getParamValuesListStr("phone").iterator();
                Iterator<String> comments = form.getParamValuesListStr("comment").iterator();
                while (phones.hasNext()) {
                    phoneValue.addItem(new ParameterPhoneValueItem(phones.next(), comments.hasNext() ? comments.next() : ""));
                }
                paramValue = phoneValue;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamPhone(id, paramId, phoneValue);
                break;
            }
            case TEXT: {
                paramValue = form.getParam("value");
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamText(id, paramId, (String)paramValue);
                break;
            }
            case TREE: {
                Set<String> values = form.getParamValuesStr("value");
                values.removeAll(Arrays.asList("0", "-1"));
                paramValue = values;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamTree(id, paramId, values);
                break;
            }
            case TREECOUNT: {
                TreeMap<String, BigDecimal> values = new TreeMap<String, BigDecimal>();
                List<String> itemIds = form.getParamValuesListStr("itemId");
                List<String> itemCounts = form.getParamValuesListStr("itemCount");
                for (int i = 0; i < itemIds.size() && i < itemCounts.size(); ++i) {
                    String itemId = itemIds.get(i);
                    BigDecimal itemCount = Utils.parseBigDecimal(itemCounts.get(i));
                    if (Utils.isBlankString(itemId) || BigDecimal.ZERO.equals(itemCount)) {
                        throw new BGIllegalArgumentException("itemCount");
                    }
                    values.put(itemId, itemCount);
                }
                paramValue = values;
                this.paramChangingProcess(con, new ParamChangingEvent(form, parameter, id, paramValue));
                paramValueDAO.updateParamTreeCount(id, paramId, values);
            }
        }
        ParamChangedEvent changedEvent = new ParamChangedEvent(form, parameter, id, paramValue);
        EventProcessor.processEvent(changedEvent, new SingleConnectionSet(con));
        return this.json(con, form);
    }

    public ActionForward parameterListCountAddValue(DynActionForm form, ConnectionSet conSet) {
        return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/edit/listcount/value_row.jsp");
    }

    public ActionForward parameterPhoneAddValue(DynActionForm form, ConnectionSet conSet) {
        return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/edit/phone/value_row.jsp");
    }

    public ActionForward parameterTreeCountAddValue(DynActionForm form, ConnectionSet conSet) {
        return this.html(conSet, form, "/WEB-INF/jspf/user/parameter/edit/treecount/value_row.jsp");
    }

    private void paramChangingProcess(Connection con, ParamChangingEvent event) throws Exception {
        EventProcessor.processEvent(event, new SingleConnectionSet(con));
    }
}

