/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.mobile;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.util.Log;
import ru.bgcrm.dao.expression.ExpressionContextAccessingObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.mobile.GMS;
import ru.bgcrm.plugin.mobile.dao.MobileDAO;
import ru.bgcrm.plugin.mobile.model.Account;
import ru.bgcrm.struts.form.DynActionForm;

public class ExpressionObject
extends ExpressionContextAccessingObject {
    private static final Log log = Log.getLog();

    ExpressionObject() {
    }

    @Override
    public void toContext(Map<String, Object> context) {
        super.toContext(context);
        context.put("mobile", this);
    }

    public void sendMessageToExecutors(String subject, String text) throws SQLException {
        Process process = (Process)this.context.get("process");
        DynActionForm form = (DynActionForm)((Object)this.context.get("form"));
        Collection userIds = process.getExecutorIds().stream().filter(userId -> userId.intValue() != form.getUserId()).collect(Collectors.toList());
        this.sendMessageToUsers(subject, text, userIds);
    }

    public void sendMessageToUsers(String subject, String text, Iterable<Integer> userIds) throws SQLException {
        try (Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();){
            GMS gms = Setup.getSetup().getConfig(GMS.class);
            for (int userId : userIds) {
                Account account = new MobileDAO(con).findAccount("user", userId);
                if (account == null) {
                    log.debug("User {} isn't logged in.", userId);
                    continue;
                }
                gms.sendMessage(account.getKey(), subject, text);
            }
        }
    }
}

