/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.fulltext.model;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.util.Utils;

public class Config
extends org.bgerp.app.cfg.Config {
    private static Set<String> PARAM_TYPES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"text", "blob", "list", "listcount", "tree", "address", "phone"}));
    private final int indexDelay;
    private final Map<String, ObjectType> objectTypeMap = new HashMap<String, ObjectType>();
    private final List<IdStringTitle> objectTypeList = new ArrayList<IdStringTitle>();
    private final Set<Integer> paramIds = new HashSet<Integer>();

    public Config(ConfigMap config) {
        super(null);
        this.indexDelay = config.getInt("fulltext:index.delay", 60);
        for (Map.Entry<String, ConfigMap> me : config.subKeyed("fulltext:entry.").entrySet()) {
            ObjectType type = new ObjectType(me.getKey(), me.getValue());
            this.objectTypeMap.put(type.getObjectType(), type);
            this.paramIds.addAll(type.paramIds);
        }
        if (this.objectTypeMap.containsKey("customer")) {
            this.objectTypeList.add(new IdStringTitle("customer", "\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442"));
        }
        if (this.objectTypeMap.containsKey("process")) {
            this.objectTypeList.add(new IdStringTitle("process", "\u041f\u0440\u043e\u0446\u0435\u0441\u0441"));
        }
        if (this.objectTypeMap.containsKey("message")) {
            this.objectTypeList.add(new IdStringTitle("message", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"));
        }
    }

    public int getIndexDelay() {
        return this.indexDelay;
    }

    public Map<String, ObjectType> getObjectTypeMap() {
        return this.objectTypeMap;
    }

    public List<IdStringTitle> getObjectTypeList() {
        return this.objectTypeList;
    }

    public boolean isParamConfigured(Parameter p) {
        return PARAM_TYPES.contains(p.getType()) && (this.paramIds.isEmpty() || this.paramIds.contains(p.getId()));
    }

    public static final class ObjectType {
        private final String objectType;
        private final Set<Integer> paramIds;

        private ObjectType(String objectType, ConfigMap params) {
            this.objectType = objectType;
            this.paramIds = Utils.toIntegerSet(params.get("paramIds"));
        }

        public String getObjectType() {
            return this.objectType;
        }

        public Set<Integer> getParamIds() {
            return this.paramIds;
        }
    }
}

