/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.dispatch.exec;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exec.scheduler.Task;
import org.bgerp.model.base.Id;
import org.bgerp.util.Log;
import org.bgerp.util.mail.MailConfig;
import org.bgerp.util.mail.MailMsg;
import ru.bgcrm.plugin.dispatch.Plugin;
import ru.bgcrm.plugin.dispatch.dao.DispatchDAO;
import ru.bgcrm.plugin.dispatch.exec.Config;
import ru.bgcrm.plugin.dispatch.model.Dispatch;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

@Bean(oldClasses={"ru.bgcrm.plugin.dispatch.CommandProcessor"})
public class DispatchCommandProcessor
extends Task {
    private static final Log log = Log.getLog();
    private static final FetchProfile FETCH_PROFILE = new FetchProfile();

    public DispatchCommandProcessor() {
        super(null);
    }

    @Override
    public String getTitle() {
        return Plugin.INSTANCE.getLocalizer().l("Dispatch Email Command Processor", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Setup setup = Setup.getSetup();
            Config config = setup.getConfig(Config.class);
            MailConfig mailConfig = config.getMailConfig();
            if (!mailConfig.check()) {
                log.error("Mail config is not configured!", new Object[0]);
                return;
            }
            Session session = mailConfig.getSmtpSession(Setup.getSetup());
            try (Store store = mailConfig.getImapStore();){
                Folder incomingFolder = store.getFolder("INBOX");
                incomingFolder.open(2);
                Message[] messages = incomingFolder.getMessages();
                incomingFolder.fetch(messages, FETCH_PROFILE);
                for (Message message : messages) {
                    block18: {
                        try {
                            if (!message.getContentType().startsWith("text/plain")) continue;
                            String from = ((InternetAddress)message.getFrom()[0]).getAddress();
                            String subject = message.getSubject();
                            String text = (String)message.getContent();
                            log.info("Processing: {}; from: {}", message.getSubject(), from);
                            if ("STATE".equals(subject)) {
                                Connection conSlave = setup.getConnectionPool().getDBSlaveConnectionFromPool();
                                try {
                                    DispatchCommandProcessor.sendDispatchStateList(conSlave, config, session, from);
                                    break block18;
                                }
                                finally {
                                    SQLUtils.closeConnection(conSlave);
                                }
                            }
                            if (!subject.endsWith("SUBSCRIBE")) break block18;
                            Set<Integer> deltaIds = Utils.toIntegerSet(StringUtils.substringBefore((String)text, (String)"\n").trim());
                            Connection con = setup.getDBConnectionFromPool();
                            try {
                                DispatchDAO dispatchDao = new DispatchDAO(con);
                                Set<Integer> dispatchIds = dispatchDao.accountSubscriptions(from).stream().map(Id::getId).collect(Collectors.toSet());
                                if (subject.startsWith("UN")) {
                                    dispatchIds.removeAll(deltaIds);
                                } else {
                                    dispatchIds.addAll(deltaIds);
                                }
                                dispatchDao.accountSubscriptionUpdate(from, dispatchIds);
                                DispatchCommandProcessor.sendDispatchStateList(con, config, session, from);
                                con.commit();
                            }
                            finally {
                                SQLUtils.closeConnection(con);
                            }
                        }
                        catch (Exception e) {
                            log.error(e);
                        }
                    }
                    message.setFlag(Flags.Flag.DELETED, true);
                }
                incomingFolder.close(true);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDispatchStateList(Connection con, Config config, Session session, String email) throws Exception {
        DispatchDAO dispatchDao = new DispatchDAO(con);
        List<Dispatch> dispatchList = dispatchDao.dispatchList(null);
        Set subscriptions = dispatchDao.accountSubscriptions(email).stream().map(Id::getId).collect(Collectors.toSet());
        String encoding = MailMsg.getParamMailEncoding(Setup.getSetup());
        try (Transport transport = null;){
            transport = session.getTransport();
            transport.connect();
            StringBuilder body = new StringBuilder(200);
            for (Dispatch dispatch : dispatchList) {
                body.append("<html><body><div>");
                body.append(dispatch.getTitle());
                body.append(" ");
                if (subscriptions.contains(dispatch.getId())) {
                    body.append("<b><a href=\"mailto:" + config.getMailConfig().getFrom() + "?subject=UNSUBSCRIBE&body=" + dispatch.getId() + "\">\u043e\u0442\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f</a></b>");
                } else {
                    body.append("<a href=\"mailto:" + config.getMailConfig().getFrom() + "?subject=SUBSCRIBE&body=" + dispatch.getId() + "\">\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f</a>");
                }
                body.append("</div></body></html>");
            }
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(config.getMailConfig().getFrom()));
            msg.setSubject("\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a", encoding);
            msg.setContent((Object)body.toString(), "text/html;charset=" + encoding);
            msg.setRecipients(Message.RecipientType.TO, email);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
        }
    }

    static {
        FETCH_PROFILE.add(FetchProfile.Item.ENVELOPE);
        FETCH_PROFILE.add("To");
        FETCH_PROFILE.add("CC");
        FETCH_PROFILE.add("Message-ID");
        FETCH_PROFILE.add("Received");
    }
}

