/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.tree.IdTitleTreeItem;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractObjectModuleInfo;
import ru.bgcrm.plugin.bgbilling.proto.model.UserInfo;
import ru.bgcrm.util.Utils;

public class DirectoryDAO
extends BillingDAO {
    private static final String CONTRACT_STATUS_MODULE_ID = "ru.bitel.bgbilling.kernel.contract.status";
    private static final String TARIFF_MODULE_ID = "tariff";
    private static final String ADMIN_MODULE_ID = "admin";
    private static final String SERVICE_MODULE_ID = "service";
    private static final String CONTRACT_MODULE_ID = "contract";
    private static final String CONTRACT_OBJECT_MODULE_ID = "contract.object";
    private static final List<IdTitle> FIXED_OLD_STATUS_LIST = new ArrayList<IdTitle>();
    private static final String TITLE_PARAM = "title";

    public DirectoryDAO(User user, String billingId) {
        super(user, billingId);
    }

    public DirectoryDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public List<IdTitle> getContractStatusList(boolean onlyManual) {
        List result = null;
        if (this.dbInfo.versionCompare("5.2") < 0) {
            result = FIXED_OLD_STATUS_LIST;
        } else if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractStatusService", "getStatusList");
            req.setParam("onlyManual", onlyManual);
            result = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        } else {
            RequestJsonRpc req = new RequestJsonRpc(CONTRACT_STATUS_MODULE_ID, "ContractStatusMonitorService", "getStatusList");
            req.setParam("onlyManual", onlyManual);
            result = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        }
        return result;
    }

    public List<IdTitle> scriptTypeList() {
        Request request = new Request();
        request.setModule(ADMIN_MODULE_ID);
        request.setAction("ListDirectory");
        request.setAttribute("mode", "15");
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        ArrayList<IdTitle> scriptTypeList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle type = new IdTitle();
            type.setId(Utils.parseInt(rowElement.getAttribute("id")));
            type.setTitle(rowElement.getAttribute(TITLE_PARAM));
            scriptTypeList.add(type);
        }
        return scriptTypeList;
    }

    public IdTitleTreeItem getContractPaymentTypes(Set<Integer> allowedTypeIds) {
        IdTitleTreeItem contractPaymentTypes = new IdTitleTreeItem();
        contractPaymentTypes.setTitle("\u0412\u0441\u0435 \u0442\u0438\u043f\u044b");
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.balance", "PaymentService", "paymentTypeTree");
            req.setParam("editable", 0);
            req.setParam("showEmptyRoot", false);
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            try {
                contractPaymentTypes = (IdTitleTreeItem)this.jsonMapper.convertValue((Object)result, IdTitleTreeItem.class);
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        } else {
            Request request = new Request();
            request.setModule(CONTRACT_MODULE_ID);
            request.setAction("ContractPayment");
            request.setAttribute("id", "new");
            Document document = this.transferData.postData(request, this.user);
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("item");
            IdTitleTreeItem typeClass = new IdTitleTreeItem();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element itemElement = (Element)nodeList.item(index);
                int typeId = Utils.parseInt(itemElement.getAttribute("id"));
                if (!allowedTypeIds.isEmpty() && !allowedTypeIds.contains(typeId)) continue;
                if ("1".equals(itemElement.getAttribute("type"))) {
                    if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                        contractPaymentTypes.addChild(typeClass);
                    }
                    typeClass = new IdTitleTreeItem();
                    typeClass.setId(typeId);
                    typeClass.setTitle(itemElement.getAttribute(TITLE_PARAM));
                    continue;
                }
                IdTitleTreeItem type = new IdTitleTreeItem();
                type.setId(typeId);
                type.setTitle(itemElement.getAttribute(TITLE_PARAM));
                typeClass.addChild(type);
            }
            if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                contractPaymentTypes.addChild(typeClass);
            }
        }
        return contractPaymentTypes;
    }

    public IdTitleTreeItem getContractChargeTypes(Set<Integer> allowedTypeIds) {
        IdTitleTreeItem contractChargeTypes = new IdTitleTreeItem();
        contractChargeTypes.setTitle("\u0412\u0441\u0435 \u0442\u0438\u043f\u044b");
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.balance", "ChargeService", "chargeTypeTree");
            req.setParam("editable", 0);
            req.setParam("isPayback", false);
            req.setParam("showEmptyRoot", false);
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            try {
                contractChargeTypes = (IdTitleTreeItem)this.jsonMapper.convertValue((Object)result, IdTitleTreeItem.class);
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        } else {
            Request request = new Request();
            request.setModule(CONTRACT_MODULE_ID);
            request.setAction("ContractCharge");
            request.setAttribute("id", "new");
            Document document = this.transferData.postData(request, this.user);
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("item");
            IdTitleTreeItem typeClass = new IdTitleTreeItem();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element itemElement = (Element)nodeList.item(index);
                int typeId = Utils.parseInt(itemElement.getAttribute("id"));
                if (!allowedTypeIds.isEmpty() && !allowedTypeIds.contains(typeId)) continue;
                if ("1".equals(itemElement.getAttribute("type"))) {
                    if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                        contractChargeTypes.addChild(typeClass);
                    }
                    typeClass = new IdTitleTreeItem();
                    typeClass.setId(typeId);
                    typeClass.setTitle(itemElement.getAttribute(TITLE_PARAM));
                    continue;
                }
                IdTitleTreeItem type = new IdTitleTreeItem();
                type.setId(typeId);
                type.setTitle(itemElement.getAttribute(TITLE_PARAM));
                typeClass.addChild(type);
            }
            if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                contractChargeTypes.addChild(typeClass);
            }
        }
        return contractChargeTypes;
    }

    public List<IdTitle> getServiceTypeList(int moduleId) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.module", moduleId, "ModuleService", "moduleServiceList");
            req.setParam("moduleId", moduleId);
            return (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        }
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        Request req = new Request();
        req.setModule(SERVICE_MODULE_ID);
        req.setAction("GetServiceList");
        req.setModuleID(moduleId);
        Document doc = this.transferData.postData(req, this.user);
        for (Element e : XMLUtils.selectElements(doc, "/data/services/service")) {
            list.add(new IdTitle(Utils.parseInt(e.getAttribute("id")), e.getAttribute(TITLE_PARAM)));
        }
        return list;
    }

    public List<IdTitle> getRegistredTariffGroupList(int selectedTariffGroupId) {
        Request request = new Request();
        request.setModule(TARIFF_MODULE_ID);
        request.setAction("ListTariffGroups");
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        ArrayList<IdTitle> registerGroupTariffList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle type = new IdTitle();
            type.setId(Utils.parseInt(rowElement.getAttribute("id")));
            type.setTitle(rowElement.getAttribute(TITLE_PARAM));
            if (selectedTariffGroupId == type.getId()) {
                registerGroupTariffList.add(0, type);
                continue;
            }
            registerGroupTariffList.add(type);
        }
        return registerGroupTariffList;
    }

    public List<IdTitle> getBillingModuleList() {
        Request request = new Request();
        request.setModule(SERVICE_MODULE_ID);
        request.setAction("Modules");
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("module");
        ArrayList<IdTitle> moduleList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle module = new IdTitle();
            module.setId(Utils.parseInt(rowElement.getAttribute("id")));
            module.setTitle(rowElement.getAttribute(TITLE_PARAM));
            moduleList.add(module);
        }
        return moduleList;
    }

    public List<IdTitle> getContractGroups() {
        Request request = new Request();
        request.setModule(ADMIN_MODULE_ID);
        request.setAction("GetContractGroupList");
        Document doc = this.transferData.postData(request, this.user);
        Element dataElement = doc.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        ArrayList<IdTitle> groupList = new ArrayList<IdTitle>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element rowElement = (Element)nodeList.item(i);
            IdTitle group = new IdTitle();
            group.setId(Utils.parseInt(rowElement.getAttribute("f0")));
            group.setTitle(rowElement.getAttribute("f2"));
            groupList.add(group);
        }
        return groupList;
    }

    public List<IdTitle> contractObjectTypeList() {
        Request request = new Request();
        request.setModule(CONTRACT_OBJECT_MODULE_ID);
        request.setAction("TypeList");
        request.setAttribute("onlyVisible", "1");
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        ArrayList<IdTitle> objectTypeList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle type = new IdTitle();
            type.setId(Utils.parseInt(rowElement.getAttribute("id")));
            type.setTitle(rowElement.getAttribute(TITLE_PARAM));
            objectTypeList.add(type);
        }
        return objectTypeList;
    }

    public ContractObjectModuleInfo contractObjectModuleList(int objectId) {
        Object data;
        Element rowElement;
        int index;
        Request request = new Request();
        request.setModule(CONTRACT_OBJECT_MODULE_ID);
        request.setAction("ObjectModuleTable");
        request.setAttribute("object_id", objectId);
        Document document = this.transferData.postData(request, this.user);
        ContractObjectModuleInfo moduleInfo = new ContractObjectModuleInfo();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        for (index = 0; index < nodeList.getLength(); ++index) {
            rowElement = (Element)nodeList.item(index);
            data = new ContractObjectModuleInfo.ContractObjectModuleData(moduleInfo);
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setComment(rowElement.getAttribute("comment"));
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setData(rowElement.getAttribute("data"));
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setModule(rowElement.getAttribute("module"));
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setPeriod(rowElement.getAttribute("period"));
            moduleInfo.getModuleDataList().add((ContractObjectModuleInfo.ContractObjectModuleData)data);
        }
        nodeList = dataElement.getElementsByTagName("module");
        for (index = 0; index < nodeList.getLength(); ++index) {
            rowElement = (Element)nodeList.item(index);
            data = new ContractObjectModuleInfo.ContractObjectModule(moduleInfo);
            ((ContractObjectModuleInfo.ContractObjectModule)data).setId(objectId);
            ((ContractObjectModuleInfo.ContractObjectModule)data).setName(rowElement.getAttribute("name"));
            ((ContractObjectModuleInfo.ContractObjectModule)data).setPackClient(rowElement.getAttribute("pack_client"));
            ((ContractObjectModuleInfo.ContractObjectModule)data).setTitle(rowElement.getAttribute(TITLE_PARAM));
            moduleInfo.getModuleList().add((ContractObjectModuleInfo.ContractObjectModule)data);
        }
        return moduleInfo;
    }

    public Map<Integer, UserInfo> getUsersInfo() {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.bgsecure", "UserService", "userInfoList");
        JsonNode res = this.transferData.postDataReturn(req, this.user);
        List userList = (List)this.readJsonValue(res.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, UserInfo.class));
        return userList.stream().collect(Collectors.toMap(i -> {
            if (i.getId() == -1 && !i.getName().equals("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c")) {
                return -1 * i.getId() * i.getName().codePointAt(0);
            }
            return i.getId();
        }, Function.identity()));
    }

    static {
        FIXED_OLD_STATUS_LIST.add(new IdTitle(0, "\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
        FIXED_OLD_STATUS_LIST.add(new IdTitle(4, "\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"));
        FIXED_OLD_STATUS_LIST.add(new IdTitle(3, "\u0437\u0430\u043a\u0440\u044b\u0442"));
        FIXED_OLD_STATUS_LIST.add(new IdTitle(2, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
    }
}

