/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.message;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageTypeSearchCall;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.message.MessageTypeSearchBilling;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@Bean(oldClasses={"ru.bgcrm.plugin.bgbilling.dao.MessageTypeSearchCall"})
public class BGBillingMessageTypeSearchCall
extends MessageTypeSearchBilling {
    private static final Log log = Log.getLog();
    private final List<String> commands;
    private final String phonePreprocessJexl;

    public BGBillingMessageTypeSearchCall(ConfigMap config) {
        super(config);
        this.commands = Utils.toList(config.get("commands"));
        this.phonePreprocessJexl = config.getSok("expressionNumberPreprocess", "stringExpressionNumberPreprocess");
    }

    @Override
    public void search(DynActionForm form, ConnectionSet conSet, Message message, Set<CommonObjectLink> result) {
        String numberFrom = MessageTypeSearchCall.preprocessNumber(message, this.phonePreprocessJexl);
        log.debug("Search by numberFrom: {}", numberFrom);
        DBInfo dbInfo = DBInfoManager.getDbInfo(this.billingId);
        if (dbInfo == null) {
            log.warn("Billing not found: {}", this.billingId);
            return;
        }
        for (String command : this.commands) {
            if (command.startsWith("contractByComment:") || !command.startsWith("contractByPhoneParam:")) continue;
            String paramIds = StringUtils.substringAfter((String)command, (String)":");
            Pageable<Contract> searchResult = new Pageable<Contract>();
            new ContractDAO(form.getUser(), this.billingId).searchContractByPhoneParam(searchResult, null, Utils.toIntegerSet(paramIds), numberFrom);
            for (Contract contract : searchResult.getList()) {
                result.add(new CommonObjectLink(0, "contract:" + contract.getBillingId(), contract.getId(), contract.getTitle(), contract.getComment()));
            }
        }
    }
}

