/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.dao;

import java.sql.Connection;
import java.util.Date;
import java.util.Set;
import java.util.SortedMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import ru.bgcrm.dao.CustomerDAO;
import ru.bgcrm.dao.CustomerLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.util.Utils;

@Deprecated
public class ContractDAO
extends BillingDAO {
    private static final Log log = Log.getLog();

    public ContractDAO(User user, String billingId) {
        super(user, billingId);
    }

    public ContractDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    @Deprecated
    public void copyAddress(ParameterAddressValue address, int contractId, int toParamId) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("UpdateAddressInfo");
        request.setAttribute("cid", contractId);
        request.setAttribute("pid", toParamId);
        request.setAttribute("hid", address.getHouseId());
        request.setAttribute("flat", address.getFlat());
        request.setAttribute("floor", address.getFloor() == null ? "" : address.getFloor());
        request.setAttribute("pod", address.getPod());
        request.setAttribute("room", address.getRoom());
        request.setAttribute("comment", address.getComment());
        this.transferData.postData(request, this.user);
    }

    public void copyParametersToBilling(Connection con, int customerId, int contractId, String title) throws Exception {
        Customer customer = new CustomerDAO(con).getCustomerById(customerId);
        String copyParamsMapping = this.dbInfo.getSetup().get("copyParamMapping", "");
        this.copyObjectParamsToContract(con, copyParamsMapping, customerId, contractId, customer);
    }

    public void copyObjectParamsToContract(Connection con, String copyParamsMapping, int objectId, int contractId, Customer customer) throws Exception {
        String[] params;
        ParamValueDAO paramDAO = new ParamValueDAO(con);
        try {
            if (customer != null) {
                Request req = new Request();
                req.setModule("contract");
                req.setAction("UpdateContractTitleAndComment");
                req.setContractId(contractId);
                req.setAttribute("comment", customer.getTitle());
                this.transferData.postData(req, this.user);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new BGMessageExceptionWithoutL10n("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430: " + customer.getTitle() + "; " + this.dbInfo.getTitle() + ", " + e.getMessage(), new Object[0]);
        }
        if (Utils.isBlankString(copyParamsMapping)) {
            return;
        }
        for (String pair : params = copyParamsMapping.split(";")) {
            try {
                Object value;
                String[] keyValue = pair.split(":");
                String fromParamId = keyValue[0].indexOf(91) == -1 ? keyValue[0] : keyValue[0].substring(0, keyValue[0].indexOf(91));
                int toParamId = Utils.parseInt(keyValue[1].indexOf(91) == -1 ? keyValue[1] : keyValue[1].substring(0, keyValue[1].indexOf(91)));
                Request request = new Request();
                request.setModule("contract");
                request.setAttribute("cid", contractId);
                request.setAttribute("pid", toParamId);
                if (fromParamId.equals("customerTitle")) {
                    if (customer == null) continue;
                    request.setAttribute("action", "UpdateParameterType1");
                    request.setAttribute("value", customer.getTitle());
                    this.transferData.postData(request, this.user);
                    continue;
                }
                Parameter param = ParameterCache.getParameter(Integer.parseInt(fromParamId));
                if (param == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 ID=" + fromParamId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", new Object[0]);
                }
                String type = param.getType();
                if ("address".equals(type)) {
                    SortedMap<Integer, ParameterAddressValue> values = paramDAO.getParamAddress(objectId, Integer.parseInt(fromParamId));
                    if (values.size() <= 0) continue;
                    ParameterAddressValue value2 = (ParameterAddressValue)values.get(values.firstKey());
                    request.setAction("UpdateAddressInfo");
                    request.setAttribute("hid", value2.getHouseId());
                    request.setAttribute("flat", value2.getFlat());
                    request.setAttribute("floor", value2.getFloor() == null ? "" : value2.getFloor());
                    request.setAttribute("pod", value2.getPod());
                    request.setAttribute("room", value2.getRoom());
                    request.setAttribute("comment", value2.getComment());
                    this.transferData.postData(request, this.user);
                    continue;
                }
                if ("text".equals(type)) {
                    value = paramDAO.getParamText(objectId, Integer.parseInt(fromParamId));
                    if (!Utils.notBlankString((String)value)) continue;
                    request.setAction("UpdateParameterType1");
                    request.setAttribute("value", value);
                    this.transferData.postData(request, this.user);
                    continue;
                }
                if ("list".equals(type)) {
                    Set<Integer> listValue = paramDAO.getParamList(objectId, Integer.parseInt(fromParamId));
                    String fromValue = "-1";
                    if (listValue == null || listValue.size() <= 0) continue;
                    fromValue = listValue.iterator().next().toString();
                    String toValue = null;
                    if (keyValue[0].indexOf(91) > 0) {
                        String[] fromVals = keyValue[0].substring(keyValue[0].indexOf(91) + 1, keyValue[0].indexOf(93)).split(",");
                        String[] toVals = keyValue[1].substring(keyValue[1].indexOf(91) + 1, keyValue[1].indexOf(93)).split(",");
                        for (int i = 0; i < fromVals.length; ++i) {
                            if (!fromVals[i].equals(fromValue)) continue;
                            toValue = toVals[i];
                            break;
                        }
                    } else {
                        toValue = fromValue;
                    }
                    if (!Utils.notBlankString(toValue)) continue;
                    new ContractParamDAO(this.user, this.dbInfo).updateListParameter(contractId, toParamId, toValue);
                    continue;
                }
                if ("phone".equals(type)) {
                    value = paramDAO.getParamPhone(objectId, Integer.parseInt(fromParamId));
                    if (value == null) continue;
                    new ContractParamDAO(this.user, this.dbInfo).updatePhoneParameter(contractId, toParamId, (ParameterPhoneValue)value);
                    continue;
                }
                if ("date".equals(type)) {
                    value = paramDAO.getParamDate(objectId, Integer.parseInt(fromParamId));
                    if (value == null) continue;
                    new ContractParamDAO(this.user, this.dbInfo).updateDateParameter(contractId, toParamId, (Date)value);
                    continue;
                }
                if (!"email".equals(type) || (value = paramDAO.getParamEmail(objectId, Integer.parseInt(fromParamId))).size() <= 0) continue;
                new ContractParamDAO(this.user, this.dbInfo).updateEmailParameter(contractId, toParamId, value.values());
            }
            catch (BGException e) {
                log.error(e.getMessage(), e);
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433! [" + pair + "] " + e.getMessage(), new Object[0]);
            }
        }
    }

    public static void copyParametersToAllContracts(Connection con, User user, int customerId) throws Exception {
        CustomerLinkDAO linkDao = new CustomerLinkDAO(con);
        for (CommonObjectLink link : linkDao.getObjectLinksWithType(customerId, "contract%")) {
            Contract contract = new Contract(link);
            new ContractDAO(user, contract.getBillingId()).copyParametersToBilling(con, customerId, contract.getId(), link.getLinkObjectTitle());
        }
    }

    public static class TaskStatus {
        public static final int OPENED = 0;
        public static final int ACCEPTED = 1;
        public static final int CLOSED = 2;
    }
}

