/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.message;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.event.ProcessFileGetEvent;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.file.FileData;
import org.bgerp.model.file.tmp.FileInfo;
import org.bgerp.model.file.tmp.SessionTemporaryFiles;
import org.bgerp.model.msg.Message;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageTypeContactSaver;
import ru.bgcrm.dao.message.MessageTypeSearch;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

public abstract class MessageType
extends IdTitle {
    private static final Log log = Log.getLog();
    private final LinkedHashMap<Integer, MessageTypeSearch> searchMap = new LinkedHashMap();
    private MessageTypeContactSaver contactSaver;
    protected final Setup setup;
    protected final ConfigMap configMap;
    private final boolean checkEmptySubject;
    private volatile boolean reading;
    protected volatile Integer unprocessedMessagesCount;

    protected MessageType(Setup setup, int id, String title, ConfigMap config) {
        this.setup = setup;
        this.configMap = config;
        this.id = id;
        this.title = title;
        if (Utils.isBlankString(title)) {
            throw new BGException("Title of message type is empty.", new Object[0]);
        }
        this.checkEmptySubject = this.configMap.getBoolean("check.empty.subject", true);
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("search.").entrySet()) {
            int searchId = me.getKey();
            ConfigMap searchConf = me.getValue();
            MessageTypeSearch search = null;
            String className = searchConf.get("class");
            if (!Utils.notBlankString(className)) continue;
            try {
                Class<?> clazz = Bean.getClass(className);
                if (!MessageTypeSearch.class.isAssignableFrom(clazz)) continue;
                Constructor<?> constr = clazz.getConstructor(ConfigMap.class);
                search = (MessageTypeSearch)constr.newInstance(searchConf);
                this.searchMap.put(searchId, search);
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        ConfigMap saver = config.sub("saver.");
        String className = saver.get("class");
        if (Utils.notBlankString(className)) {
            try {
                Class<?> clazz = Bean.getClass(className);
                if (MessageTypeContactSaver.class.isAssignableFrom(clazz)) {
                    Constructor<?> constr = clazz.getConstructor(ConfigMap.class);
                    this.contactSaver = (MessageTypeContactSaver)constr.newInstance(saver);
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    public Map<Integer, MessageTypeSearch> getSearchMap() {
        return this.searchMap;
    }

    public MessageTypeContactSaver getContactSaver() {
        return this.contactSaver;
    }

    @Dynamic
    public boolean isCheckEmptySubject() {
        return this.checkEmptySubject;
    }

    public boolean isReading() {
        return this.reading;
    }

    public Integer getUnprocessedMessagesCount() {
        return this.configMap.getBoolean("unprocessedMessageNotify", true) ? this.unprocessedMessagesCount : null;
    }

    public boolean isAnswerSupport() {
        return false;
    }

    public Message getAnswerMessage(Message original) {
        throw new UnsupportedOperationException();
    }

    protected String answerText(String text) {
        text = ">" + ((String)text).replace("\r", "").replace("\n", "\n>");
        return text;
    }

    public boolean isAttachmentSupport() {
        return true;
    }

    public boolean isEditable(Message message) {
        return false;
    }

    public boolean isRemovable(Message message) {
        return false;
    }

    public boolean isProcessChangeSupport() {
        return false;
    }

    public String getViewerJsp() {
        return null;
    }

    public String getProcessMessageHeaderColor(Message message) {
        return message.isIncoming() ? "#c3f6b6" : "#aceae7";
    }

    public String getHeaderJsp() {
        return null;
    }

    public String getMessageDescription(String lang, Message message) {
        return "";
    }

    public boolean isReadable() {
        return true;
    }

    public String getEditorJsp() {
        return null;
    }

    public void process() {
    }

    public List<Message> newMessageList(ConnectionSet conSet) throws Exception {
        return Collections.emptyList();
    }

    public Message newMessageGet(ConnectionSet conSet, String messageId) throws Exception {
        return null;
    }

    public void messageDelete(ConnectionSet conSet, String ... messageIds) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Message newMessageLoad(Connection con, String messageId) throws Exception {
        return null;
    }

    public abstract void updateMessage(Connection var1, DynActionForm var2, Message var3) throws Exception;

    public List<CommonObjectLink> searchObjectsForLink(Message message) {
        return Collections.emptyList();
    }

    public Message messageLinkedToProcess(Message message) throws Exception {
        return null;
    }

    protected Map<Integer, FileInfo> processMessageAttaches(Connection con, DynActionForm form, Message message) throws Exception {
        FileDataDAO fileDao = new FileDataDAO(con);
        List<FileData> attachList = message.getAttachList();
        attachList.clear();
        attachList.addAll(fileDao.list(form.getParamValuesList("fileId")));
        Map<Integer, FileInfo> tmpFiles = SessionTemporaryFiles.getFiles(form, "tmpFileId");
        for (FileInfo fileInfo : tmpFiles.values()) {
            FileData file = new FileData();
            file.setTitle(fileInfo.getTitle());
            FileOutputStream out = fileDao.add(file);
            try (InputStream inputStream = fileInfo.getInputStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
            ((OutputStream)out).close();
            message.addAttach(file);
        }
        for (String fileId : form.getParamValuesListStr("announcedFileId")) {
            ProcessFileGetEvent event = new ProcessFileGetEvent(form, message.getProcessId(), fileId);
            EventProcessor.processEvent(event, new SingleConnectionSet(con));
            if (event.getFileData() == null) {
                log.debug("Not found bytes for announcedFileId: " + fileId, new Object[0]);
                continue;
            }
            FileData file = new FileData();
            file.setTitle(event.getFileTitle());
            FileOutputStream out = fileDao.add(file);
            IOUtils.write((byte[])event.getFileData(), (OutputStream)out);
            out.close();
            message.addAttach(file);
        }
        return tmpFiles;
    }
}

