/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.expression;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bgcrm.dao.expression.ExpressionObject;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;

public class ProcessLinkExpressionObject
implements ExpressionObject {
    private static final String KEY = "processLink";
    private static final String KEY_SHORT = "pl";
    private final ProcessLinkDAO linkDao;
    private final int processId;

    public ProcessLinkExpressionObject(Connection con, int processId) {
        this.linkDao = new ProcessLinkDAO(con);
        this.processId = processId;
    }

    @Override
    public void toContext(Map<String, Object> context) {
        context.put(KEY, this);
        context.put(KEY_SHORT, this);
    }

    public List<String> linkTitles(String typeLike) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (CommonObjectLink link : this.linkDao.getObjectLinksWithType(this.processId, typeLike)) {
            result.add(link.getLinkObjectTitle());
        }
        return result;
    }

    public String linkTitle(String typeLike) throws Exception {
        Iterator<CommonObjectLink> iterator = this.linkDao.getObjectLinksWithType(this.processId, typeLike).iterator();
        if (iterator.hasNext()) {
            CommonObjectLink link = iterator.next();
            return link.getLinkObjectTitle();
        }
        return null;
    }
}

