/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.mail;

import java.util.Properties;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.util.Utils;

public class MailConfig {
    private final ConfigMap configMap;
    private final String host;
    private final String email;
    private final String from;
    private final String store;
    private final int port;
    private final String login;
    private final String pswd;

    public MailConfig(ConfigMap config) {
        this.configMap = config;
        this.host = config.get("host");
        this.email = config.get("email");
        this.from = config.get("from", this.email);
        this.store = config.get("store", "imap");
        this.port = config.getInt("port", 0);
        this.login = config.get("login");
        this.pswd = config.get("pswd");
    }

    public String getEmail() {
        return this.email;
    }

    public String getFrom() {
        return this.from;
    }

    public boolean check() {
        return Utils.notBlankString(this.email) && Utils.notBlankString(this.login) && Utils.notBlankString(this.pswd);
    }

    public static Properties getImapSessionStaticProperties() {
        Properties props = new Properties();
        props.setProperty("mail.imap.timeout", "7000");
        props.setProperty("mail.imap.partialfetch", "false");
        props.setProperty("mail.imaps.timeout", "7000");
        props.setProperty("mail.imaps.partialfetch", "false");
        props.setProperty("mail.mime.allowutf8", "true");
        return props;
    }

    public Session getImapSession() throws Exception {
        Properties props = MailConfig.getImapSessionStaticProperties();
        if ("imaps".equals(this.store)) {
            props.setProperty("mail.imap.ssl.enable", "true");
            props.setProperty("mail.imaps.ssl.trust", "*");
        }
        props.setProperty("mail.debug", String.valueOf(this.configMap.getBoolean("debug", false)));
        return Session.getInstance((Properties)props, null);
    }

    public Store getImapStore() throws Exception {
        Store store = this.getImapSession().getStore(this.store);
        if (this.port > 0) {
            store.connect(this.host, this.port, this.login, this.pswd);
        } else {
            store.connect(this.host, this.login, this.pswd);
        }
        return store;
    }

    public Session getSmtpSession(ConfigMap defaultParamMap) {
        Session session = null;
        String user = MailConfig.getOptionFromConfigs(this.configMap, defaultParamMap, "mail.smtp.user", null);
        String pswd = MailConfig.getOptionFromConfigs(this.configMap, defaultParamMap, "mail.smtp.pswd", null);
        String proto = this.configMap.get("mail.transport.protocol", "smtp");
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", proto);
        props.setProperty("mail." + proto + ".host", MailConfig.getOptionFromConfigs(this.configMap, defaultParamMap, "mail.smtp.host", ""));
        props.setProperty("mail." + proto + ".port", MailConfig.getOptionFromConfigs(this.configMap, defaultParamMap, "mail.smtp.port", ""));
        props.setProperty("mail." + proto + ".localhost", MailConfig.getOptionFromConfigs(this.configMap, defaultParamMap, "mail.smtp.localhost", ""));
        props.setProperty("mail.debug", String.valueOf(this.configMap.getBoolean("mail.debug", false)));
        props.put("mail." + proto + ".timeout", "10000");
        props.put("mail." + proto + ".connectiontimeout", "10000");
        if ("smtps".equals(proto)) {
            props.put("mail.smtps.ssl.trust", "*");
        }
        Authenticator authenticator = null;
        if (Utils.notBlankString(user) && Utils.notBlankString(pswd)) {
            authenticator = new Authenticator(user, pswd);
            props.setProperty("mail." + proto + ".auth", "true");
            props.setProperty("mail." + proto + ".submitter", authenticator.getPasswordAuthentication().getUserName());
        }
        session = Session.getInstance((Properties)props, authenticator);
        return session;
    }

    private static final String getOptionFromConfigs(ConfigMap paramMap, ConfigMap defaultParamMap, String paramName, String defaultValue) {
        return paramMap.get(paramName, defaultParamMap != null ? defaultParamMap.get(paramName, defaultValue) : defaultValue);
    }

    private static class Authenticator
    extends javax.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator(String user, String password) {
            this.authentication = new PasswordAuthentication(user, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

