/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.backup;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.servlet.file.Files;
import org.bgerp.util.Dynamic;

public class Config
extends org.bgerp.app.cfg.Config {
    private final int cleanupCandidateCountMoreThan;
    private final int cleanupCandidateDbCountMoreThan;

    protected Config(ConfigMap config) {
        super(null);
        config = config.sub("backup:");
        this.cleanupCandidateCountMoreThan = config.getInt("cleanup.candidate.count.more.than", 3);
        this.cleanupCandidateDbCountMoreThan = config.getInt("cleanup.candidate.db.count.more.than", 3);
    }

    @Dynamic
    public Set<String> cleanupCandidates(Files files) {
        List names = files.list().stream().map(File::getName).collect(Collectors.toList());
        HashSet<String> result = new HashSet<String>(names.size());
        int cleanupCandidateMoreThat = this.cleanupCandidateCountMoreThan;
        int cleanupCandidateDbMoreThat = this.cleanupCandidateDbCountMoreThan;
        for (String name : names) {
            if (name.contains(".db.")) {
                if (cleanupCandidateDbMoreThat-- > 0) continue;
                result.add(name);
                continue;
            }
            if (cleanupCandidateMoreThat-- > 0) continue;
            result.add(name);
        }
        return Collections.unmodifiableSet(result);
    }
}

