/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.plugin.pln.callboard.cache.CallboardCache;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import org.bgerp.util.Log;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class WorkTypeTime {
    private static final Log log = Log.getLog();
    private boolean isDynamic;
    private int workTypeId;
    private int dayMinuteFrom;
    private int dayMinuteTo;
    private boolean inNextDay;
    private String comment = "";
    private static final Pattern OLD_TIME_PATTERN = Pattern.compile("\\d{2}/\\d{2}/\\d{4}\\s+(\\d{2}):(\\d{2})");

    public WorkTypeTime() {
    }

    public WorkTypeTime(boolean isDynamic, int workTypeId, int timeFrom, int timeTo, String comment) {
        this.workTypeId = workTypeId;
        this.dayMinuteFrom = timeFrom;
        this.dayMinuteTo = timeTo;
        this.comment = comment;
        this.isDynamic = isDynamic;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getWorkTypeId() {
        return this.workTypeId;
    }

    public void setWorkTypeId(int workTypeId) {
        this.workTypeId = workTypeId;
    }

    public int getDayMinuteFrom() {
        return this.dayMinuteFrom;
    }

    public void setDayMinuteFrom(int timeFrom) {
        this.dayMinuteFrom = timeFrom;
    }

    public int getDayMinuteTo() {
        return this.dayMinuteTo;
    }

    public void setDayMinuteTo(int timeTo) {
        this.dayMinuteTo = timeTo;
    }

    public static final String minutesToHourMin(int minutes) {
        return String.format("%02d:%02d", minutes / 60, minutes % 60);
    }

    public String getFormatedTimeFrom() {
        return WorkTypeTime.minutesToHourMin(this.dayMinuteFrom);
    }

    public String getFormatedTimeTo() {
        return WorkTypeTime.minutesToHourMin(this.dayMinuteTo);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean getIsDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public static final List<WorkTypeTime> createFromString(String config) {
        ArrayList<WorkTypeTime> result = new ArrayList<WorkTypeTime>();
        Preferences setup = new Preferences(config);
        SortedMap<Integer, ConfigMap> sortedMap = setup.subIndexed("rule.");
        for (ConfigMap entry : sortedMap.values()) {
            try {
                WorkTypeTime workTypeTime = new WorkTypeTime();
                workTypeTime.setWorkTypeId(entry.getInt("workTypeId", 0));
                workTypeTime.setDayMinuteFrom(WorkTypeTime.getMinutes(entry.get("timeFrom", "")));
                workTypeTime.setDayMinuteTo(WorkTypeTime.getMinutes(entry.get("timeTo", "")));
                workTypeTime.setDynamic(entry.getInt("isDynamic", 0) == 1);
                result.add(workTypeTime);
            }
            catch (BGException e) {
                log.error(e.getMessage(), e);
            }
        }
        WorkTypeTime.setNextDays(result);
        return result;
    }

    public static final void setNextDays(List<WorkTypeTime> workTimes) {
        boolean inNextDay = false;
        for (WorkTypeTime workTypeTime : workTimes) {
            workTypeTime.inNextDay = inNextDay;
            if (inNextDay || workTypeTime.dayMinuteTo >= workTypeTime.dayMinuteFrom) continue;
            inNextDay = true;
        }
    }

    private static final int getMinutes(String value) {
        int result = Utils.parseInt(value, -1);
        if (result < 0) {
            Matcher m = OLD_TIME_PATTERN.matcher(value);
            if (m.matches()) {
                result = Utils.parseInt(m.group(1)) * 60 + Utils.parseInt(m.group(2));
            } else {
                throw new BGException("Can't parse: " + value, new Object[0]);
            }
        }
        return result;
    }

    public int getWorkMinutesInDay(WorkType type, Date dateStart, Date inDate) {
        return this.getMinutesInDay(type, dateStart, inDate, true);
    }

    public int getMinutesInDay(WorkType type, Date dateStart, Date inDate, boolean onlyWork) {
        if (!(type == null || onlyWork && type.isNonWorkHours())) {
            Calendar inDateStart = TimeUtils.convertDateToCalendar(inDate);
            Calendar timeFrom = new GregorianCalendar();
            timeFrom.setTime(dateStart);
            ((Calendar)timeFrom).add(12, this.dayMinuteFrom);
            Calendar timeTo = new GregorianCalendar();
            timeTo.setTime(dateStart);
            ((Calendar)timeTo).add(12, this.dayMinuteTo);
            if (this.dayMinuteTo < this.dayMinuteFrom) {
                ((Calendar)timeTo).add(6, 1);
            } else if (this.inNextDay) {
                ((Calendar)timeFrom).add(6, 1);
                ((Calendar)timeTo).add(6, 1);
            }
            if (inDate != null) {
                Calendar inDateEnd = TimeUtils.getNextDay(inDateStart);
                TimeUtils.clear_HOUR_MIN_MIL_SEC(inDateEnd);
                if (inDateEnd.before(timeFrom) || timeTo.before(inDateStart)) {
                    return 0;
                }
                if (timeFrom.before(inDateStart)) {
                    timeFrom = inDateStart;
                } else if (inDateEnd.before(timeTo)) {
                    timeTo = inDateEnd;
                }
            }
            return Math.max((int)((timeTo.getTimeInMillis() - timeFrom.getTimeInMillis()) / 60000L), 0);
        }
        return 0;
    }

    public static int getWorkMinutesInDay(List<WorkTypeTime> workTypeTimeList, Date dateStart, Date inDate) {
        int result = 0;
        if (workTypeTimeList != null) {
            for (WorkTypeTime typeTime : workTypeTimeList) {
                result += typeTime.getWorkMinutesInDay(CallboardCache.getWorkType(typeTime.getWorkTypeId()), dateStart, inDate);
            }
        }
        return result;
    }
}

