/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.sms;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.plugin.msg.sms.Sender;
import org.bgerp.util.Log;

public class SenderSMSC
extends Sender {
    private static final Log log = Log.getLog();
    private final String url;
    private final String login;
    private final String password;

    protected SenderSMSC(ConfigMap config) throws Config.InitStopException {
        super(null);
        this.url = config.get("url", "https://smsc.ru/sys/send.php");
        this.login = config.get("login");
        this.password = config.get("password");
        this.initWhen(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.login, this.password}));
    }

    @Override
    public void send(String number, String text) {
        try {
            URIBuilder url = new URIBuilder(this.url);
            url.addParameter("login", this.login);
            url.addParameter("psw", this.password);
            url.addParameter("phones", number);
            url.addParameter("mes", text);
            Request req = Request.Get((URI)url.build());
            log.debug("Sending: {}", req);
            String response = req.execute().returnContent().asString(StandardCharsets.UTF_8);
            log.debug("=> {}", response);
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

