/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javassist.NotFoundException;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.param.ParamValueDAO;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.StatusChangeDAO;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.struts.form.DynActionForm;

public class ProcessCloneDAO
extends CommonDAO {
    private final DynActionForm form;
    private boolean params;

    public ProcessCloneDAO(Connection con, DynActionForm form) {
        super(con);
        this.form = form;
    }

    public ProcessCloneDAO withParams(boolean value) {
        this.params = value;
        return this;
    }

    public Process clone(int id) throws SQLException, NotFoundException {
        ProcessDAO dao = new ProcessDAO(this.con, this.form);
        Process process = dao.getProcessOrThrow(id);
        ProcessType type = ProcessTypeCache.getProcessTypeOrThrow(process.getTypeId());
        Process clone = new Process();
        clone.setCreateTime(new Date());
        clone.setCreateUserId(this.form.getUserId());
        clone.setTypeId(process.getTypeId());
        clone.setStatusId(process.getStatusId());
        clone.setPriority(process.getPriority());
        clone.setDescription(process.getDescription());
        dao.updateProcess(clone);
        dao.updateProcessGroups(process.getGroups(), clone.getId());
        dao.updateProcessExecutors(process.getExecutors(), clone.getId());
        StatusChange change = new StatusChange();
        change.setDate(new Date());
        change.setProcessId(process.getId());
        change.setUserId(this.form.getUserId());
        change.setComment(this.form.l.l("Process cloned from {}", process.getId()));
        change.setStatusId(process.getStatusId());
        new StatusChangeDAO(this.con).changeStatus(process, null, change);
        if (this.params) {
            new ParamValueDAO(this.con).copyParams((int)process.getId(), (int)clone.getId(), type.getProperties().getParameterIds());
        }
        return clone;
    }
}

