/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import ru.bgcrm.struts.form.DynActionForm;

public class ServletResponseInterceptor
extends HttpServletResponseWrapper {
    private CustomServletOutPutStream outputStream;
    private PrintWriter printWriter;

    public ServletResponseInterceptor(HttpServletResponse response, OutputStream result) throws UnsupportedEncodingException {
        super(response);
        this.outputStream = new CustomServletOutPutStream(result);
        this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.outputStream), StandardCharsets.UTF_8));
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.printWriter;
    }

    public void flush() {
        this.printWriter.flush();
    }

    public static byte[] jsp(DynActionForm form, String jsp, int approxSize) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(approxSize);
        ServletResponseInterceptor resp = new ServletResponseInterceptor(form.getHttpResponse(), bos);
        HttpServletRequest req = form.getHttpRequest();
        req.getRequestDispatcher(jsp).include((ServletRequest)req, (ServletResponse)resp);
        resp.flush();
        form.getResponse().getData().clear();
        return bos.toByteArray();
    }

    private static class CustomServletOutPutStream
    extends ServletOutputStream {
        private final OutputStream buffer;

        private CustomServletOutPutStream(OutputStream buffer) {
            this.buffer = buffer;
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.write(b, off, len);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

